/*******************************************************************************

 Project Name:      ADC0_15.cprj
 Required Libs's:   IntFunc_lib.cc
 Files:             ADC0_15.cc
 Writer:            CCPRO-TEAM
 Date:              22.08.2013
 Function:          Demonstrate the Analog-Digital-Converter function
                    Read ADC0 and ADC15

 ------------------------------------------------------------------------------
 AVR32 Serie:
 Required the C-Control PRO AVR32-Bit UNIT Conrad BN: 192573
 Applicationboard Conrad BN: 192587
 Or Mainboard Conrad BN: 192702
 ------------------------------------------------------------------------------

 Note:
 -----

 To test the program, connect the Applicationboard external
 REF_voltage (2.048V) to P8. Connect the Poti P1 to ADC0 P9
 and the Poti P2 to ADC15 P24.

 The program returns the raw value of the ADC.

*******************************************************************************/

// Only for the C-Control PRO AVR32
#ifdef AVR32

void main(void)
{
    // Local ADC and string variables
    int result[5];
    char str[30];

    // Turn off the ADC
    ADC_Disable();

    /***************************************************************************
       The ADC sequencer in the AVR32 can carry up to 8 AD conversion at a time.
       The function ADC_SetInput defines the ADC inputs between a differential
       measurement is carried out. If you want to measure only one input,
       one define ADC_GND as the second input. In addition,
       a GAIN factor can be defined.

       Even if a measurement between an input and ADC_GND delivers only
       positive values, one bit of the ADC resolution still
       remains reserved for the sign.

       Syntax:
       -------
       ADC_SetInput(indx, inp1, inp2, gain)

       Parameter:
       ----------
       indx  =  index for conversion (0-7)
       inp1  =  first AD input (0-15)
       inp2  =  second AD input (0-15)
       gain  =  GAIN factor

       Gain:
       -----
       ADC_SHG_1    =    gain factor 1
       ADC_SHG_2    =    gain factor 2
       ADC_SHG_4    =    gain factor 4
       ADC_SHG_8    =    gain factor 8
       ADC_SHG_16   =    gain factor 16
       ADC_SHG_32   =    gain factor 32
       ADC_SHG_64   =    gain factor 64
    ***************************************************************************/

    ADC_SetInput(0, 0, 1, ADC_SHG_1);       // activate ADC0-ADC1 - Gain 1
    //ADC_SetInput(1, 2, ADRC_GND, ADC_SHG_1);    // activate ADC2 - Gain 1


    /***************************************************************************
     The ADC sequencer in the AVR32 can carry up to 8 A/D-conversions
     at the same time. An A/D-conversion can be a differential measurement
     between an ADC pin and GND, or a differential measurement between two pins.
     See ADC_SetInput.

     For the mode parameter various properties can be ORed
     (this of course only makes sense with one ADC resolution).
     Oversampling and Sample & Hold can be turned off. If enabled, an interrupt
     is triggered when an ADC measurement is finished (see interrupt Table).

     ADC_Start has to be called for each new measurement.
     The end of the measurement can be displayed via interrupt,
     or use ADC_GetValues with the parameter ADC_GET_WAIT.
     Is the Free Running mode selected, ADC_Start is called only once,
     after that the inputs are continuously measured, and ADC_GetValues
     always returns the value of the last measurement.

     Please look into the datasheet AT32UC3C for the exact meaning of
     oversampling and sample & hold, and the impact on the measurements!

     If ADC is set to very high speeds and the interrupt is enabled,
     this can overwhelm the interpreter.

     Syntax:
     -------
     ADC_Enable(mode, speed, ref, input_cnt, offset)

     Parameter:
     ----------
     mode       =   work modes (see Table)
     speed      =   ADC Clock (32khz - 1.5Mhz)
     ref        =   reference Voltage (see Table)
     input_cnt  =   number of ADC Pins (1-8)
     offset     =   correction factor (-128 to 127)

     Mode Table:
     -----------
     ADC_MODE_12BIT         =    ADC 12-Bit resolution
     ADC_MODE_8BIT          =    ADC 8-Bit resolution
     ADC_MODE_10BIT         =    ADC 10-Bit resolution
     ADC_MODE_NO_OVERSAMP   =    turns Oversampling off
     ADC_MODE_ENAB_IRQ      =    activates ADC IRQ
     ADC_MODE_NO_SAMPHOLD   =    no Sample & Hold
     ADC_MODE_FREE_RUN      =    activates Free Running

     Reference Voltage Table:
     ------------------------
     ADC_REF1V      =    internal 1V Reference
     ADC_REF06VDD   =    internal 0.6 x VDDANA Reference
     ADC_ADCREF0    =    external ADCREF0 Reference
     ADC_ADCREF1    =    external ADCREF1 Reference
    ***************************************************************************/

    ADC_Enable(ADC_MODE_12BIT|ADC_MODE_FREE_RUN, 100000, ADC_ADCREF0, 2, 0);


    // The built-in A/D converter starts to convert analog data
    ADC_Start();


   // Endless loop
    while(1)
    {
        /*******************************************************************
          The function read the measured values from the A/D-converter and
          copies them into a 16-bit array. If the value ADC_GET_WAIT (0x80)
          is ORed to cnt, then the function waits for the completion of all
          ADC measurements before the values are copied.

          The ADC_GET_WAIT functionality should not be used in
          "free running" mode, or when the ADC is switched off!

          Syntax:
          -------
          ADC_GetValues(values[], cnt)

          Parameter:
          ----------
          values    =   pointer to the 16-Bit array (0-7)
          cnt       =   number of values that are copied into the array
        *******************************************************************/

        ADC_GetValues(result, 2);


        // Print result
        Str_Printf(str, "ADC0:%d ADC2:%d\r", result[0], result[1]);
        Msg_WriteText(str);



        // Delay
        AbsDelay(300);

    }

}


#else
#error "Only C-Control PRO AVR32-Bit"
#endif

/*******************************************************************************
 * Info
 *******************************************************************************
 * Changelog:
 * -
 *
 *******************************************************************************
 * Bugs, feedback, questions and modifications can be posted on the
 * C-Control Forum on http://www.c-control.de
 * Of course you can also write us an e-mail to: webmaster@c-control.de
 * We publish updates from time to time on www.c-control.de!
/******************************************************************************/

// EOF