/*******************************************************************************

 Project Name:      multithread2.cprj
 Required Libs's:   IntFunc_lib.cc
 Files:             multithread2.cc
 Writer:            CCPRO-TEAM
 Date:              29.08.2013
 Function:          Multithreading with Thread_Delay

 ------------------------------------------------------------------------------
 AVR32 Serie:
 Required the C-Control PRO AVR32-Bit UNIT Conrad BN: 192573
 Applicationboard Conrad BN: 192587
 Or Mainboard Conrad BN: 192702

 MEGA Serie:
 Required the C-Control PRO MEGA32 UNIT Conrad BN: 198206
 and Evalationboard Conrad BN: 198245
 Or Projectboard Conrad BN: 197287

 Or C-Control PRO MEGA128 UNIT Conrad BN: 198219
 Or C-Control PRO MEGA128CAN Conrad BN: 197989
 and Evaluationboard Conrad BN: 198258
 or Projectboard Conrad BN: 197313
 ------------------------------------------------------------------------------

 Note:
 -----

*******************************************************************************/

#thread 0, 0, 10    // main thread with task change every 10 * 10ms = 100ms
#thread 1, 128, 10  // thread 1 with 128 byte RAM & task change 10 * 10ms = 100ms

byte lock;
/*------------------------------------------------------------------------------
name:           thread1
input:          -
output:         -
description:    Thread1 with character output
------------------------------------------------------------------------------*/
void thread1(void)
{
    while(true)
    {
       //Thread_Lock(1);
       Msg_WriteText("Thread 1");
       Msg_WriteChar(13);
       Thread_Delay(100);
    }                                   // Write "Thread2"
}                                       // Set Thread to sleep for 2000ms

/*------------------------------------------------------------------------------
name:           main
input:          -
output:         -
description:    Main program
------------------------------------------------------------------------------*/
void main(void)
{
    Thread_Start(1,thread1);            // Start thread
    Thread_Delay(200);
    Thread_Lock(1);                     //Thread 1 sollte nicht weiter ausgefhrt werden knnen

    while(true)                         // Endless loop
    {
        Thread_Delay(100);
        Msg_WriteText("Thread 0");
        Msg_WriteChar(13);
    }                                   // The thread sleeps for 1000ms
}                                       // Then write "Thread1"


/*******************************************************************************
 * Info
 *******************************************************************************
 * Changelog:
 * -
 *
 *******************************************************************************
 * Bugs, feedback, questions and modifications can be posted on the
 * C-Control Forum on http://www.c-control.de
 * Of course you can also write us an e-mail to: webmaster@c-control.de
 * We publish updates from time to time on www.c-control.de!
/******************************************************************************/

// EOF


