
;*******************************************************************************
;* File: Watchdog.asm
;* Author  : M. Benninger
;* Ident   : Rev 1 30-DEC-2008
;* Function: Watchdog Timer Functions
;*           This module implements three functions:
;*           WDT_on (prescalar), WDT_off () and WDT_reset ()
;*           The parameter prescalar determine the Watchdog Timer prescaling
;*           when the Watchdog Timer is enabled. The different prescaling values
;*           and their corresponding Timeout Periods are shown below:
;*              Prescalar        Typical Timeout Value
;*                  0                   15 ms
;*                  1                   30 ms
;*                  2                   60 ms
;*                  3                  120 ms
;*                  4                  240 ms
;*                  5                  0.5 sec
;*                  6                  1.0 sec
;*                  7                  2.0 sec
;*
;* Library:  none
;*
;* History : Rev 1 30-DEC-2008 M. Benninger
;*                 - first implementation
;*           Rev.1.1 29.12.2010 Joachim Khnapfel (Jo)
;*                 - WTD_off: rettrn und wiederherstellen von R16 und R17 wie im
;*                   wie im Forum diskutiert / beschrieben
;*                 - .ifdef tag_xxx / .endif hinzugefgt gem Vorgaben aus
;*                   Beispiel der C-Control Hilfe
;*                 - rename
;*                     WDT_on       -> WatchDog_On
;*                     WDT_off      -> WatchDog_Off
;*                     WDT_reset    -> WatchDog_Reset
;*
;*******************************************************************************

;**** Watchdog Timer Definitions ****

.equ WDTCR = $21               ; Watchdog Timer Control Register
.equ WDCE  = 4                 ; WDT Change Enable bit
.equ WDE   = 3                 ; WDT Enable bit
.equ WDPM  = 7                 ; WDT Prescalar mask

.ifdef tag_WDT_reset

WatchDog_Reset:                          ; Reset Watchdog Timer
    wdr
    ret

.endif


.ifdef tag_WDT_on

WatchDog_On:                        ; Enable Watchdog Timer
    push    R16
    push    R17
    movw    r26, r6                 ; r7:r6 points to ret_addr
    adiw    r26, 4                  ; X now points to prescalar parameter
    ld      r16, x                  ; get prescalar parameter
    andi    r16, WDPM               ; and mask lower 3 bits
    ori     r16, (1<<WDE)
    ldi     r17, (1<<WDCE)|(1<<WDE) ; Write logical one to WDCE and WDE
    out     WDTCR, r17              ; enable write to WDT control register
    out     WDTCR, r16              ; write WDT control register
    pop     R17
    pop     R16
    ret

.endif


.ifdef tag_WDT_off

WatchDog_Off:
    push    R16
    push    R17
                                    ; Disable Watchdog Timer
    in      r16, WDTCR              ; get WDT control register
    ori     r16, (1<<WDCE)|(1<<WDE) ; enable write to WDT control register
    out     WDTCR, r16              ; write to WDT control register
    ldi     r16, (0<<WDE)           ; turn off WDE bit
    out     WDTCR, r16              ; write WDT control register

    pop     R17
    pop     R16

    ret

.endif

;* End of Watchdog.asm -- Watchdog Timer Functions fr ATmega128
;******************************************************************************/<<