//-------------------------- E-KFZ Datenerfassung ------------------------------
void E_KFZ_Messung(void)
{
//----------- Mittelwertbildung der gemessenen Werte vom AD-Wandler ------------
// ACHTUNG: unter main und Sekundenabfrage wird die Energie ermittelt
      if (cnt_Strom_E_KFZ>=ADC_Limit)   // Anzahl der Messwerte ereicht?
      {
        Strom_E_KFZ=(Strom_E_KFZ+m_Strom_E_KFZ)/(cnt_Strom_E_KFZ+1);
        m_Strom_E_KFZ=0; cnt_Strom_E_KFZ=0;
        ADC_Nr=0;                       // Nchsten ADC fr Interruptmessung freigeben LM35 Tmpmessung
        if (Strom_E_KFZ<0.5)            // Strungen-Brumm abfangen
        {                               // hier liegen noch die digitalisierten Werte vor
          E_KFZdigit=Strom_E_KFZ;
          Strom_E_KFZ=0;
          P_E_KFZ=0;
        }
        else
        {
          E_KFZdigit=Strom_E_KFZ;
          Strom_E_KFZ=((0.012*Strom_E_KFZ)+0.1242)*0.975; // Berechnung der Stromstrke aus 0,98
          P_E_KFZ=Strom_E_KFZ*233;     // Digitalwert mit Polynom 1.Ordnung
        }
      }
}
// U-Prg wird ber main aufgefufen, wenn erstmalig Ladestecker abgenommen wurde und
// in weiterer
void E_KFZ(void)
{
      if (Ladeartwahl==E_KFZ_AUS_down && E_KFZ_Ladestatus<=8)  // Bei Ladung AUS => ABBRUCH
      {
        m_Ladeartwahl=Ladeartwahl;
        m_E_KFZ_Ladeart=Ladeartwahl;
        E_KFZ_Ladestatus=0;
      }
      switch (E_KFZ_Ladestatus)
      {
        case 0:
        if (IN9_16&E_KFZ_Stecker) E_KFZ_Ladestatus=2;  // Ladestecker abgenommen => nchste Ebene
        delay_ECO=0; delay_EIN_AUS=0;
        f_E_KFZ_Ladestatus=0;
        if (StromstossEIN_AUS==1 && f_Stromstoss==0) E_KFZ_FS20_schalten();
        if (f_Stromstoss) E_KFZ_Stromstoss_toggle();   // Stromstoschalter geschaltet? gibt f_Stromstoss=0 zurck
        break;
        case 2:
        if (Strom_E_KFZ>E_KFZ_Stromschwelle) // Ladung in die Ladeebene => Stromstoschalter gedrckt
        {
          f_E_KFZ_Ladestatus=E_KFZ_Ladestatus;  // Ladestatus merken => 100% Ladung durchfhren
          StromstossEIN_AUS=1;                  // Stromstoschalter Status auf EIN => wurde gedrckt
          if (delay_EIN_AUS>=2)
          {
            E_KFZ_Ladestatus=8;
            delay_EIN_AUS=45;                   // Ausschaltverzgerung auf 10 Sekunden
          }
        }
        if (!(IN9_16&E_KFZ_Stecker)) E_KFZ_Ladestatus=0;
        if (delay_EIN_AUS>=45) E_KFZ_Ladestatus=3; // Ladung in die Ladeebene => laden mit Ladungsvorwahl
        break;
        case 3:
        if (m_E_KFZ_Ladeart>=E_KFZ_Eco_down)
        {
          E_KFZ_Ladestatus=4; // Selektion der Ladungswahl
          delay_EIN_AUS=10;
        }
        else E_KFZ_Ladestatus=7;
        break;
        case 4:               // PV Leistung ausreichend?
        if (delay_EIN_AUS>=45)
        {
            E_KFZ_Ladestatus=7; // 35 sec genug Leistung siehe void E_KFZ_f_second(void)
            delay_ECO=45;       // 45 Sekunden Schaltverzgerung bei Leistungsunterschreitung fr ECO plus aktivieren
        }
        break;
        case 7:               // Stromstoschalter einschalten
        if (StromstossEIN_AUS==0 && f_Stromstoss==0) E_KFZ_FS20_schalten();
        if (f_Stromstoss==0) E_KFZ_Ladestatus=8; // Ladung in nchste Ebene, wenn Stromstoschalter geschaltet hat
        else E_KFZ_Stromstoss_toggle();          // Stromstoschalter geschaltet? gibt f_Stromstoss=0 zurck
        break;
        case 8:
      //  if (Strom_E_KFZ>E_KFZ_Stromschwelle) E_KFZ_Ladestatus=9; // Ladung in die Ladeebene => Stromstoschalter gedrckt
        if (delay_EIN_AUS>=47)
        {
            E_KFZ_Ladestatus=9;
            secondE_KFZ_Ladung=0;
            minuteE_KFZ_Ladung=0;
            hourE_KFZ_Ladung=0;
            E_KFZ_Ladung=0;
        }
        if (!(IN9_16&E_KFZ_Stecker))
        {
            if (StromstossEIN_AUS==1 && f_Stromstoss==0) E_KFZ_FS20_schalten();
            if (f_Stromstoss==0) E_KFZ_Ladestatus=0;
            else E_KFZ_Stromstoss_toggle();    // Stromstoschalter geschaltet? gibt f_Stromstoss=0 zurck
        }
        break;
        case 9:
        // E_KFZ_f_second(void) wird Verzgerung (delay_HAND_EIN) frs Aussschalten bearbeitet
        if (delay_EIN_AUS==0)
        {
          if (StromstossEIN_AUS==1 && f_Stromstoss==0) E_KFZ_FS20_schalten();
          if (f_Stromstoss==0)
          {
            E_KFZ_Ladestatus=10;
            EgesE_KFZ=EgesE_KFZ+E_KFZ_Ladung;
            EEPROM_WriteFloat(e_adr_EgesE_KFZ,EgesE_KFZ);
          }
          else E_KFZ_Stromstoss_toggle();     // Stromstoschalter geschaltet? gibt f_Stromstoss=0 zurck
        }
        break;
        case 10:
        if (!(IN9_16&E_KFZ_Stecker)) E_KFZ_Ladestatus=1;
        if (Ladeartwahl==E_KFZ_AUS_down) E_KFZ_Ladestatus=20;  // nach AUS, wenn nicht abgesteckt wird, muss noch 100%Ladung mglich sein
        delay_ECO=0; f_E_KFZ_Ladestatus=0;
        break;
        case 20:
        if (Ladeartwahl!=m_Ladeartwahl)
        {
            E_KFZ_Ladestatus=0;
            m_Ladeartwahl=Ladeartwahl;
        }
        if (!(IN9_16&E_KFZ_Stecker)) E_KFZ_Ladestatus=1;
        break;
      }
      E_KFZ_f_second();
//Msg_WriteWord(delay_EIN_AUS);Msg_WriteText("  Ladestatus: "); Msg_WriteWord(E_KFZ_Ladestatus);  Msg_WriteChar(CR);
}
//----------------- Sekundenabhngige Programmteile ----------------------------
byte f_power_gr;
void E_KFZ_f_second(void)
{
/*if (WR_power<700 && f_power_gr==0) WR_power=WR_power+5;
else f_power_gr=1;
if (WR_power>100 && f_power_gr) WR_power=WR_power-5;
else f_power_gr=0;  */

  if (E_KFZ_Ladestatus==2) delay_EIN_AUS++;
  if (E_KFZ_Ladestatus==4 && WR_power>=E_KFZ_powerpoint) delay_EIN_AUS++;
  if (E_KFZ_Ladestatus==8 && Strom_E_KFZ>E_KFZ_Stromschwelle) delay_EIN_AUS++;

  if (f_E_KFZ_Ladestatus==2) m_E_KFZ_Ladeart=E_KFZvoll_down;   // wegen manueller Ladung ber Stromstoschalter
  else m_E_KFZ_Ladeart=Ladeartwahl;

  if (E_KFZ_Ladestatus==9 && delay_EIN_AUS)
  {
    switch (m_E_KFZ_Ladeart)
    {
      case E_KFZvoll_down:
      E_KFZ_Zeichen="Vollladung:   ";
      break;
      case E_KFZ_4h_down:
      E_KFZ_Zeichen="Ladung 4Std:  ";
      if (hourE_KFZ_Ladung==4) delay_EIN_AUS--;
      break;
      case E_KFZ_7h_down:
      E_KFZ_Zeichen="Ladung 7Std:  ";
      if (hourE_KFZ_Ladung==7) delay_EIN_AUS--;
      break;
      case E_KFZ_Eco_down:
      E_KFZ_Zeichen="ECO:          ";
     // if (hourE_KFZ_Ladung==7) delay_EIN_AUS--;
      break;
      case E_KFZ_Ecoplus_down:
      E_KFZ_Zeichen="ECO plus:     ";

      // Kontakt fr beide folgende Schalthandlungen kontrollieren
//      if (f_Stromstoss) E_KFZ_Stromstoss_toggle();       // Stromstoschalter geschaltet? gibt f_Stromstoss=0 zurck

      // Einschaltbedingung abfragen => positiv - Einschalten
      if (WR_power>E_KFZ_powerpoint && delay_ECO<40) delay_ECO++;
      if (delay_ECO>=40 && StromstossEIN_AUS==0 && f_Stromstoss==0)
      {
        E_KFZ_FS20_schalten();
        delay_EIN_AUS=47;      // Ausschaltverzgerung wird nach Wiedereinschalten der Leistung durch Aufprfen des E-KFZ heruntergezhlt
      }

      // Ausschaltbedingung abfragen => positiv - Ausschalten
      if (WR_power<=(E_KFZ_powerpoint-100) && delay_ECO) delay_ECO--;
      if (delay_ECO==0 && StromstossEIN_AUS==1 && f_Stromstoss==0) E_KFZ_FS20_schalten();

      // Kontakt fr beide folgende Schalthandlungen kontrollieren
      if (f_Stromstoss) E_KFZ_Stromstoss_toggle();       // Stromstoschalter geschaltet? gibt f_Stromstoss=0 zurck

      // Fertig geladen? => Ausschaltverzgerung aktivieren und in caseabfrage E_KFZ_Ladestatus=9 weiterbehandeln
      if ((!(IN9_16&E_KFZ_Stecker))&& delay_EIN_AUS) delay_EIN_AUS--;      // Stecker in Parkstellung -> Ausschalten
      if (Strom_E_KFZ<E_KFZ_Stromschwelle && StromstossEIN_AUS && delay_EIN_AUS) delay_EIN_AUS--;
      break;
    }
    if (Strom_E_KFZ>=E_KFZ_Stromschwelle)
    {
      E_KFZ_Ladung=E_KFZ_Ladung+(P_E_KFZ/3600000);
      secondE_KFZ_Ladung++;
      E_KFZ_time();
    }
    else {if (delay_EIN_AUS && (m_E_KFZ_Ladeart != E_KFZ_Ecoplus_down)) delay_EIN_AUS--;}
    if (Ladeartwahl==E_KFZ_AUS_down)
    {
        E_KFZ_Zeichen="ABBRUCH:     ";
        if (delay_EIN_AUS) delay_EIN_AUS--;     // Ladevorgang abbrechen => Ladestatus=9 Stromstoschalter muss noch ausgeschaltet werden
    }
  }
}
void E_KFZ_time(void)
{
    if (secondE_KFZ_Ladung==60)
    {
        secondE_KFZ_Ladung=0;
        minuteE_KFZ_Ladung++;
        if (minuteE_KFZ_Ladung==60)
        {
          minuteE_KFZ_Ladung=0;
          hourE_KFZ_Ladung++;
        }
    }
}
void E_KFZ_FS20_schalten(void)         // Stromstoschalter schalten
{
  FS20ST4_Adr=ST4_KFZ_Ladung_FS20ADR;
  FS20Befehl=0x39; FS20Erweitrg=0x0B;   // 04=1Sekunde 0B=2,75Sekunden
  FS20ST4 ();
  f_Stromstoss=1;                      // Schaltkontrolle aktivieren
}
void E_KFZ_Stromstoss_toggle(void)     // Kontrolle des Stromstoschalter mittels Relaiskontakt
{
    WORD_WERT((IN9_16&E_KFZ_Stromstoss),0,wordWert,385,WGy1);
    if (IN9_16&E_KFZ_Stromstoss)
    {
      if (StromstossEIN_AUS) StromstossEIN_AUS=0;  // Stromstoschalter Status ndern
      else StromstossEIN_AUS=1;
      cntE_KFZ_Error=0;
      f_Stromstoss=0;                              // Stromstoschalter wurde geschaltet
    }
    else
    {
      if(f_Stromstoss<20 && cntE_KFZ_Error<4) f_Stromstoss++;
      else
      {
          if (cntE_KFZ_Error<4)
          {
              E_KFZ_FS20_schalten();
              cntE_KFZ_Error++;
              Error=Error|E_KFZ_Error;
              if (m_Error==0) m_Error=1;
          }
      }
    }
}