
//DEFINITIONEN fr IIC-PORTANSTEUERUNGEN
//    HIGH BYTE      |     LOW BYTE
//--------------------------------------
//  8    4   2   1   |   8   4   2   1
//--------------------------------------
// 7F   BF  DF   EF  |  F7  FB  FD  FE    -> Relais ON
// 80   40  20  10   |  08  04  02  01    -> Relais OFF
//------------------------------------------------------------------------------
// ------------------------------ OUT1-8 ---------------------------------------
// Ausgang 1, Bit 0 -> Lfter Wechselrichter
// Ausgang 2, Bit 1 -> Teichpumpe
// Ausgang 3, Bit 2 -> Beschattung WG Richtungsrelais
// Ausgang 4, Bit 3 -> Oberlichtfenster WG Richtungsrelais
// Ausgang 5, Bit 4 -> Lftungsklappe Dachgescho
// Ausgang 6, Bit 5 -> Lftermotor Wintergartenspeicher
// Ausgang 7, Bit 6 -> Alarmanlage
// Ausgang 8, Bit 7 -> Bewsserung Balkon
// ------------------------------ OUT9-16 --------------------------------------
// Ausgang 9, Bit 0 ->  Wasserenthrtung
// Ausgang 10, Bit 1 -> Blumenlicht Wohnzimmer
// Ausgang 11, Bit 2 -> Richtungsrelais HK Mischer
// Ausgang 12, Bit 3 -> Richtungsrelais FBH Mischer   S
// Ausgang 13, Bit 4 -> Spannung an ZSauger
// Ausgang 14, Bit 5 -> ZSauger einschalten
// Ausgang 15, Bit 6 ->
// Ausgang 16, Bit 7 ->
// ------------------------------ OUT17-24 -------------------------------------
// Ausgang 17, Bit 0 -> Rollladen Stiege K16
// Ausgang 18, Bit 1 -> Rollladen Bad K15
// Ausgang 19, Bit 2 -> Rollladen Kind K17
// Ausgang 20, Bit 3 ->
// Ausgang 21, Bit 4 ->
// Ausgang 22, Bit 5 ->
// Ausgang 23, Bit 6 ->
// Ausgang 24, Bit 7 ->
// ------------------------------ OUT25-32 -------------------------------------
// --------------------------- TRIAC OUT1-8 ------------------------------------
// Ausgang 1, Bit 0 -> Beschattung -> Spannung auf Richtungsrelais
// Ausgang 2, Bit 1 -> Oberlichtfenster -> Spannung auf Richtungsrelais
// Ausgang 3, Bit 2 -> Rollladen Stiege -> Spannung auf Richtungsrelais
// Ausgang 4, Bit 3 -> Rollladen Bad -> Spannung auf Richtungsrelais
// Ausgang 5, Bit 4 -> Rollladen Kind -> Spannung auf Richtungsrelais
// Ausgang 6, Bit 5 ->
// Ausgang 7, Bit 6 ->
// Ausgang 8, Bit 7 ->
// ----------------------------- INPUT1-8 --------------------------------------
// Eingang 1, Bit 0 -> Alarmanlage: Reedkontakt Haustre
// Eingang 2, Bit 1 -> Alarmanlage: Reedkontakt Wohnzimmertre
// Eingang 3, Bit 2 -> Alarmanlage: Reedkontakt Wintergartentre
// Eingang 4, Bit 3 -> Alarmanlage: Reedkontakt Kellertre
// Eingang 5, Bit 4 ->
// Eingang 6, Bit 5 ->
// Eingang 7, Bit 6 ->
// Eingang 8, Bit 7 ->
// ------------------------------ INPUT9-16 ------------------------------------
// Eingang 9, Bit 0 ->  WZ Schalter Res
// Eingang 10, Bit 1 -> WZ Schalter Res
// Eingang 11, Bit 2 -> WZ Schalter Res
// Eingang 12, Bit 3 -> Klingeltaster
// Eingang 13, Bit 4 -> ZSauger Einschaltanforderung
// Eingang 14, Bit 5 ->
// Eingang 15, Bit 6 -> Stromstoschalter E-KFZ wird geschaltet abgenommen mit Relaiskontakt
// Eingang 16, Bit 7 -> Ladestecker E-KFZ Garage abgenommen
// ------------------------------ INPUT17-24 -----------------------------------
// Eingang 17, Bit 0 -> Rollladen Stiege nach Unten
// Eingang 18, Bit 1 -> Rollladen Stiege nach Oben
// Eingang 19, Bit 2 -> Rollladen Bad nach Unten
// Eingang 20, Bit 3 -> Rollladen Bad nach Oben
// Eingang 21, Bit 4 -> Rollladen Kind nach Unten
// Eingang 22, Bit 5 -> Rollladen Kind nach Oben
// Eingang 23, Bit 6 ->
// Eingang 24, Bit 7 ->
// ------------------------------ INPUT25-32 -----------------------------------
//------------------------ Allgemeine Konstante --------------------------------
#define Mrz 3
#define April 4                 // Sommeranfang Flag setzen
#define Mai 5
#define August 8
#define September 9
#define Oktober 10
#define November 11             //
#define 5Uhr 5                  // 5 Uhr
#define 6Uhr 6                  // 6 Uhr
#define 7Uhr 7                  // 7 Uhr
#define 11Uhr 11                // 11 Uhr
#define 18Uhr 18                // 18 Uhr
#define 19Uhr 19                // 19 Uhr
#define 20Uhr 20                // 20 Uhr
#define 21Uhr 21                // 21 Uhr
#define 22Uhr 22                // 22 Uhr
#define x 150                   // keine Funktion bei Rollden in Bezug auf Ein-bzw. Ausfahren
#define DCFupdateStunde 3       // DCF update bei Stunde=>3Uhr Sommerzeitumstellung
#define DCFupdateMinute 15      // DCF update bei Minute
#define DeltaUTI 0.5            // Schwankungsunterdrckung bei UTI TMP-Verarbeitung
#define DeltaADC 0.2            // Schwankungsunterdrckung bei ADC TMP Verarbeitung
//----------------------- Portdefinitionen -------------------------------------
#define ZSaugPower 12           // Spannung an Zentralstaubsauger
#define ZSaugON 13              // Zentralstaubsauger Einschalten
#define UTI1 16                 // UTI1=PortC.0
#define UTI2 17                 // UTI2=PortC.1
#define UTI3 18                 // UTI3=PortC.2
#define eDIP_RESET 34           // Port 34 RESET eDIP-Display
#define eDIP_SBUF 37            // Inputport des Sendepuffers eDIP -> Interrupt
#define ADC0_TMP_LM35 40        // AD Eingang fr LM35 CZ Tempfhler
#define ADC1_Lichtsensor 41     // Lichtsensor bei Anemometer
#define ADC2_E_KFZ 42           // Wandler fr Ladestrom messen
#define DCF_IN 51               // Eingang fr DCF Antenne

#define I2C_ADR_IN1_8 112       // Schreibadresse fr Porterweiterung
#define I2C_ADR_IN9_16 114      // Schreibadresse fr Porterweiterung
#define I2C_ADR_IN17_24 116     // Schreibadresse fr Porterweiterung
#define I2C_ADR_IN25_32 118     // Schreibadresse fr Porterweiterung

#define I2C_ADR_OUT1_8 120      // Schreibadresse fr Porterweiterung
#define I2C_ADR_OUT9_16 122     // Schreibadresse fr Porterweiterung
#define I2C_ADR_OUT17_24 124    // Schreibadresse fr Porterweiterung
#define I2C_ADR_OUT25_32 126    // Schreibadresse fr Porterweiterung

#define I2C_ADR_TriacOUT1_8 64  // Schreibadresse fr Triac Porterweiterung
#define I2C_ADR_TriacHeizung 66 // Schreibadresse fr Triac Porterweiterung fr Heizung

//---------------------------- RS 232 Multiplexer ------------------------------
#define WR_RS 0                 // RS 232 Nr.:0 auf Wechselrichterschnittstelle einstellen
#define WR_DatenRS 1            // RS 232 Nr.:1 Wechselrichterdaten lesen
#define FS20_RS 20              // RS 232 Nr.:1 auf FS20 Schnittstelle einstellen:Rollden
#define FS20WS_RS 21            // RS 232 Nr.:1 auf FS20 Schnittstelle einstellen:andere Ansteuerungen Wechselschalter, RSU Timer programmieren
#define FS20page_RS 22          // RS 232 Nr.:1 auf FS20 Schnittstelle einstellen:RSU Timer programmieren
#define FS20ST4_RS 23           // RS 232 Nr.:1 auf FS20 Schnittstelle einstellen:RSU Timer programmieren
#define FS20_DatenRS 3          // RS 232 Nr.:1 FS20 Daten schreiben/lesen
#define FS20WS_DatenRS 4        // RS 232 Nr.:1 FS20 Daten schreiben/lesen
#define FS20page_DatenRS 5      // RS 232 Nr.:1 FS20 Daten schreiben/lesen
#define FS20ST4_DatenRS 6       // RS 232 Nr.:1 FS20 Daten schreiben/lesen fr SSD
#define CD4052_A 22             // Bitport X4/2 PC6 22 fr Analogmultiplexer Eingang A
#define CD4052_B 23             // Bitport X4/1 PC6 23 fr Analogmultiplexer Eingang B
//----------------------------- Arraylimits ------------------------------------
#define Datenlimit 100          // max. Byteanzahl beim Datenarray
#define Sel_datenlimit 100      // max. Zeichenanzahl beim Datenarray
#define Ausgabelimit 65         // max. Zeichenanzahl beim Datenarray
#define eDIP_Dat_limit 65       // max. Byteanzahl beim eingelesenen Datenarray
#define Zeichenlimit 100        // max. Zeichenanzahl fr am Display angezeigte Zeichen
#define CR 13                   // Enter fr Zeilenende
// ----------------- Deklaration fr Sting fr WORD Variable--------------------
#define PVLeistung 1            // Textselektierung fr Leistungsanzeige
#define PVSolarspg 2            // Textselektierung fr PV-Spannung
#define PVNetzspg 3             // Textselektierung fr Netzspannung
#define PVTemp 4                // Textselektierung fr WR Temperatur
#define Datum 5                 // Textselektierung fr Datumsanzeige
#define Zeit 6                  // Textselektierung fr Zeitanzeige
#define TMP_LM35 7              // Textselektierung fr Temperaturfhler TMP_LM35
#define Wind 8                  // Textselektierung fr Windanzeige
#define tWGBdelay 9             // Textsel. fr Verzgerungsanzeige Beschattung
#define tWGBWRtmp 10            // Textsel. fr Wechselrichtertemp mit Maxgrenze
#define tWGFdelay 11            // Textsel. fr Verzgerungsanzeige Fenster
#define Zeitformat 12           // Textsel. fr Zeitanzeige   Variable:00
#define Startzeit 13            // Textsel. fr Startzeitnderung   Variable:00
#define LaufzeitStunden 14      // Textsel. fr Laufzeitnderung   Variable:00
#define LaufzeitMinuten 15      // Textsel. fr Laufzeitnderung   Variable:00
#define UTI_Error_txt 16        // Textsel. fr UTI Erroranzeige
#define DCF_Error_par_txt 17    // Textsel. fr DCF 77 Parity-Erroranzeige
#define FS20_Error_txt 18       // Textsel. fr FS20 Status-Erroranzeige
#define LaufMinuten 19          // Anzeige der vergangenen Minuten+Sekunden
#define LaufStunden 20          // Anzeige der vergangenen Stunde+Minuten+Sekunden
#define Laufzeit_h 21           // Anzeige der Stunden mit h
#define RollZeitFenster 22      // Anzeige der Rollladenlaufzeiten Fenster
#define RollZeitTure 23         // Anzeige der Rollladenlaufzeiten Tre
#define wordWert 24             // Anzeigen eines word Werte
#define Zeitformat_hh_mm 25     // Zeitformat mit Stunden und Minuten
// ----------------- Deklaration fr Sting fr FLOAT Variable-------------------
#define Temp 1                  // Textselektierung fr Temperaturanzeige allg.
#define tWG_TMP 2               // Textsel. fr Tempanzeige mit Grenzwert
#define Strom 3                 // Textsel. fr Stromanzeige E-KFZ
#define Leistung 4              // Textsel. fr Leistungsanzeige E-KFZ
#define E_Ladung 5              // Textsel. fr Energieanzeige E-KFZ
#define E_ges 6                 // Textsel. fr Geamtenergieanzeige E-KFZ
//---------------------------- Errorkonstante ----------------------------------
#define UTI_Error 1
#define DCF_Error 2
#define DCF_Error_parity 4
#define eDIP_Error 8
#define E_KFZ_Error 16
//--------------------------- Deklaration eDIP ---------------------------------
#define page1 1                 // erste Seite Tempanzeigen
#define page1_menu 2            // Erste Menseite
#define pagePV 3                // Festlegung der Seite fr die PV-Anlage
#define pageWG 4                // Festlegung der Seiten fr den Wintergarten
#define pageBewBLicht 5         // Seite fr Bewsserung Balkon u. Blumenlicht Wohnzimmer
#define pageAlarm 6             // Festlegung der Seite fr die Alarmanlage
#define pageRollDach 7          // Seite fr die Rollladensteuerung Dach
#define pageZSaugTeichp 8       // Seite fr Zentralstaubsauger/Teichpumpe
#define pageError 9             // Seite fr Erroranzeige
#define page2_menu 10           // Zweite Menseite
#define pageRollKUCHE 11        // Seite fr Rollladensteuerung Kche
#define pageRollWZ 12           // Seite fr Rollladensteuerung Wohnzimmer
#define pageRollOG 13           // Seite fr Rollladensteuerung OG
#define pageFS20 14             // Seite fr Einstellung FS20 Sender
#define pageE_KFZ 15            // Seite fr E-KFZ Ladungseinstellungen
#define pageHEIZUNG_STAT 16     // Seite fr Heizungssteuerung
#define pageHEIZUNG_TMP 17      // Seite fr Heizungssteuerung Temperaturanzeige
#define pageHEIZUNG_ZEIT 18     // Seite fr Heizungssteuerung Zeiteinstellung
#define pageHEIZUNG_ENERGIE 19  // Seite fr Heizungssteuerung Energieermittlung
#define pageHEIZUNG_EINSTLLG 20 // Seite fr Heizungssteuerung SOOLL Tempeinstellung

#define pageEINST 30            // Seite fr Laufzeiteinstellungen
#define pageWG_MW 31            // Seite fr Wintergartenmesswerte

#define page3_menu 40           // Dritte Menseite

#define eDIP_R 0xDF             // Leseadresse eDIP-Display
#define eDIP_W 0xDE             // Schreibadresse eDIP-Display
#define DC1 0x11                // Softwarehandshake eDIP-Display
#define DC2 0x12                // Softwarehandshake eDIP-Display
#define ACK 0x06                // Besttigung vom Display
#define ESC 0x1B                // Steuerzeichen Escape eDIP-Display
#define NULL 0x00               // Steuerzeichen Null eDIP-Display
//#define eDIP_RESET 34           // Port 34 RESET eDIP-Display
#define eDIP_Watchdog 3         // Watchdog in Sekunden -> RESET eDIP-Display
//#define eDIP_SBUF 37            // Inputport des Sendepuffers eDIP -> Interrupt
#define eDIPdimm_time 5         // eDIP_Abdimmzeitpunkt f. Display in Minuten
#define eDIP_Bel_max 90         // Maximale Beleuchtung
#define eDIP_Bel_mittel 30      // Mittlere Beleuchtung
#define eDIP_Bel_Sommer_min 15  // Minimale Beleuchtung
#define eDIP_Bel_Winter_min 8   // Minimale Beleuchtung
#define eDIP_Bel_zero 0         // Beleuchtung Null
#define T1x1 50                 // Touchform quadratisch 1x1 cm
#define T2x2 81                 // Touchform quadratisch 2x2 cm
#define Zeile 30                // Zeilenabstand
#define TAB 20                  // Tabulator
#define d16 65000               // 16 Bit eDIP Ausgabe->keine relevanten bertragungsdaten
#define d8 255                  // 8 Bit eDIP Ausgabe->keine relevanten bertragungsdaten

// ---------------------- Touchpositionen --------------------------------------
#define menu_up 0               // Keine Aktion
#define menu_down 1             // Auf Menseite wechseln
#define menu_ret_down 2         // auf Tempanzeige vom Men zurck
#define pageWG_MWdown 3         // Seite fr Wintergartenmesswerte
#define RETURN 4                // Zurck bei Zeiteinstellungseite
#define START_plus 5            // Zeiteinstellung Wert erhhen
#define START_minus 6           // Zeiteinstellung Wert senken
#define DAUER_plus 7            // Zeitdauereinstellung Wert erhhen
#define DAUER_minus 8           // Zeitdauereinstellung Wert senken

#define page1_menu_down 9       // Taste fr Auswahl der ersten Menseite
#define page_E_KFZ_down 10      // Taste fr E-KFZ Men/Anzeige
#define pagePVdown 11           // PV Seite gewhlt
#define pageWGdown 12           // Wintergarten Seite gewhlt
#define pageBlumendown 13       // Bewsserung Blumenlichtseite gewhlt
#define pageAlarmdown 14        // Alarm Seite gewhlt
#define pageZS_TPdown 15        // ZSauger Teichpumpe gewhlt

#define page2_menu_down 16      // Taste fr Auswahl der zweite Menseite
#define page3_menu_down 17      // Taste fr Auswahl der dritte Menseite
#define pageRollDach_down 18    // Rolladenseite Dach gewhlt
#define pageRollKUCHEdown 19    // Rolladenseite Kche gewhlt
#define pageRollWZdown 20       // Rolladenseite Wohnzimmer gewhlt
#define pageRollOGdown 21       // Rolladenseite OG gewhlt
#define pageFS20down 22         // FS20 Men Seite gewhlt

#define WGBautodown 25          // Beschattung Automatik
#define BeschOBENdown 26        // Beschattung  nach Oben gewhlt
#define BeschUNTENdown 27       // Beschattung  nach Unten gewhlt
#define WGFautodown 28          // Fenster Automatik
#define FensterZUdown 29        // Fenster zumachen gewhlt
#define FensterOFFENdown 30     // Fenster aufmachen gewhlt
#define WGKautodown 31          // Klappe Automatik
#define KlappeZUdown 32         // Klappe OG schlieen gewhlt
#define KlappeOFFENdown 33      // Klappe OG ffnen gewhlt
#define WGSautodown 34          // Speicher Automatik
#define SpeicherAUSdown 35      // Speicherlfter ausschalten gewhlt
#define SpeicherEINdown 36      // Speicherlfter einschalten gewhlt
#define Al_Start_plus 37        // Plus Taster Alarmanl. Einschaltzeit
#define Al_Ende_plus 38         // Plus Taster Alarmanl. Ausschaltzeit
#define Al_Start_minus 39       // Minus Taster Alarmanl. Einschaltzeit
#define Al_Ende_minus 40        // Minus Taster Alarmanl. Ausschaltzeit
#define Al_ein_down 41          // Taster fr Alarmanlage EIN/AUS/Alarm RESET
#define Al_Panik_down 42        // Paniktaster fr Alarmanlage
#define Al_Urlaub_down 43       // Taster fr Urlaubbedingung
#define Al_StiegeLicht_down 44  // Taster fr Stiegenhauslicht
#define WR_LufterON 45          // Wechselrichterlfterschalter EIN
#define WR_LufterOFF 46         // Wechselrichterlfterschalter AUS
#define ZSaugerON 47            // Zentralstaubsauger EIN
#define ZSaugerOFF 48           // Zentralstaubsauger AUS
#define ZSauger_Nachl 49        // Nachlaufzeit stellen in Minuten
#define TeichpONdown 50         // Teichpumpe EIN
#define TeichpOFFdown 51        // Teichpumpe AUS
#define TeichpTIME1 52          // Taster fr Zeiteinstellung1 Teichpumpe einstellen
#define TeichpTIME2 53          // Taster fr Zeiteinstellung2 Teichpumpe einstellen
#define H2O_EnthartgON 54       // Wasserenthrtung EIN
#define H2O_EnthartgOFF 55      // Wasserenthrtung AUS
#define BLichtONdown 56         // Blumenlicht Wohnzimmer EIN
#define BLichtOFFdown 57        // Blumenlicht Wohnzimmer AUS
#define BLicht_Start 58         // Startzeit fr Wohnzimmerblumenlicht stellen
#define BLicht_Lauf 59          // Laufzeit WZ Blumenlicht in Stunden stellen
#define BewassrgONdown 60       // Blumenbewsserung Balkon EIN
#define BewassrgOFFdown 61      // Blumenbewsserung Balkon AUS
#define Bewassrg_Start1 62      // Taster fr Starzeit1 Bewsserung einstellen
#define Bewassrg_Lauf1 63       // Taster fr Laufzeit1 Bewsserung einstellen
#define Bewassrg_Start2 64      // Taster fr Starzeit2 Bewsserung einstellen
#define Bewassrg_Lauf2 65       // Taster fr Laufzeit2 Bewsserung einstellen
#define TeichpAUTO 66           // Schalter fr Automatik Teichpumpe EIN
//#define TeichpHAND 67           // Schalter fr Automatik Teichpumpe AUS
#define RSobendown 68           // Taster fr Rollladen Stiegenhaus rauf
#define RSuntendown 69          // Taster fr Rollladen Stiegenhaus runter
#define RSautodown 70           // Rollladen Stiegenhaus Automatik
#define RBobendown 71           // Taster fr Rollladen Bad rauf
#define RBuntendown 72          // Taster fr Rollladen Bad runter
#define RBautodown 73           // Rollladen Bad Automatik
#define RKobendown 74           // Taster fr Rollladen Kind rauf
#define RKuntendown 75          // Taster fr Rollladen Kind runter
#define RKautodown 76           // Rollladen Kinderzimmer Automatik
#define RKNeinfdown 77          // Taster fr Rollladen Kche Nord rauf
#define RKNausfdown 78          // Taster fr Rollladen Kche Nord runter
#define RKNautodown 79          // Rollladen Kche Nord Automatik
#define RKOeinfdown 80          // Taster fr Rollladen Kche Ost rauf
#define RKOausfdown 81          // Taster fr Rollladen Kche Ost runter
#define RKOautodown 82          // Rollladen Kche Ost Automatik
#define RWZTeinfdown 83         // Taster fr Rollladen Wohnzimmer Tre rauf
#define RWZTausfdown 84         // Taster fr Rollladen Wohnzimmer Tre runter
#define RWZTautodown 85         // Rollladen Wohnzimmer Tre Automatik
#define RWZSeinfdown 86         // Taster fr Rollladen Wohnzimmer Sd rauf
#define RWZSausfdown 87         // Taster fr Rollladen Wohnzimmer Sd runter
#define RWZSautodown 88         // Rollladen Wohnzimmer Sd Automatik
#define RWZWeinfdown 89         // Taster fr Rollladen Wohnzimmer West rauf
#define RWZWausfdown 90         // Taster fr Rollladen Wohnzimmer West runter
#define RWZWautodown 91         // Rollladen Wohnzimmer West Automatik
#define RGOeinfdown 92         // Taster fr Rollladen Gast Ost rauf
#define RGOausfdown 93         // Taster fr Rollladen Gast Ost runter
#define RGOautodown 94         // Rollladen Gast Ost Automatik
#define RGTeinfdown 95         // Taster fr Rollladen Gast Tre rauf
#define RGTausfdown 96         // Taster fr Rollladen Gast Tre runter
#define RGTautodown 97         // Rollladen Gast Tre Automatik
#define RSTeinfdown 98         // Taster fr Rollladen Schlafen Tre rauf
#define RSTausfdown 99         // Taster fr Rollladen Schlafen Tre runter
#define RSTautodown 100        // Rollladen Schlafen Tre Automatik
#define RKWeinfdown 101         // Taster fr Rollladen Kind West rauf
#define RKWausfdown 102         // Taster fr Rollladen Kind West runter
#define RKWautodown 103         // Rollladen Kind West Automatik
#define RKNtimedown 104         // Taster fr Rollladen Laufzeiteinstellung
#define RKOtimedown 105         // Taster fr Rollladen Laufzeiteinstellung
#define RWZTtimedown 106         // Taster fr Rollladen Laufzeiteinstellung
#define RWZStimedown 107         // Taster fr Rollladen Laufzeiteinstellung
#define RWZWtimedown 108         // Taster fr Rollladen Laufzeiteinstellung
#define RGOtimedown 109         // Taster fr Rollladen Laufzeiteinstellung
#define RGTtimedown 110         // Taster fr Rollladen Laufzeiteinstellung
#define RSTtimedown 111         // Taster fr Rollladen Laufzeiteinstellung
#define RKWtimedown 112         // Taster fr Rollladen Laufzeiteinstellung
#define RL_Timerdown 113        // Verborgener Taster fr Zeiteinstellung
//-------------------------------- E-KFZ ---------------------------------------
#define E_KFZvoll_down 117      // E-KFZ vollladen
#define E_KFZ_4h_down 118       // E-KFZ 1 Stunde laden
#define E_KFZ_7h_down 119       // E-KFZ 3 Stunden laden
#define E_KFZ_Eco_down 120      // E-KFZ leistungsbezogen Einschalten danach 3 Stunden laden
#define E_KFZ_Ecoplus_down 121  // E-KFZ rein leistungsbezogen Laden
#define E_KFZ_AUS_down 122      // E-KFZ Ladung ausschalten
//------------------------------ Heizung ---------------------------------------
#define pageHEIZUNG_STATdown 123 // Heizungsmen Status bzw. Steuerung
#define pageHEIZUNG_TMPdown 124  // Heizungsmen Temperaturen anzeigen
#define pageHEIZUNG_EINSTLLGdown 125 // Heizungsmen Solltemp. einstellen
#define pageHEIZUNG_ZEITdown 126 // Heizungsmen Schaltzeiten einstellen
#define pageHEIZUNG_ENERGIEdown 127 // Heizungsmen fr Energieermittelung einstellen
#define GasZeitdown 128          // Zeitpunkt Gasheizung
#define PufferZeitdown 129       // Zeitpunkt Pufferheizung
#define FBH_Zeitdown 130         // Zeitpunkt FBH Heizung
#define SPEICHERN 131            // Zeiteinstellungen speichern
#define EIN1plus 132             // Einschaltzeit1 plus stellen
#define EIN1minus 133            // Einschaltzeit1 minus stellen
#define AUS1plus 134             // Ausschaltzeit1 plus stellen
#define AUS1minus 135            // Ausschaltzeit1 minus stellen
#define EIN2plus 136             // Einschaltzeit2 plus stellen
#define EIN2minus 137            // Einschaltzeit2 minus stellen
#define AUS2plus 138             // Ausschaltzeit2 plus stellen
#define AUS2minus 139            // Ausschaltzeit2 minus stellen
#define HEIZGautodown 140        // Heizung Automatik
#define HEIZGhanddown 141        // Heizung Hand
#define Hzgwahl_down 142         // Heizung Wahl der Betriebsart Tag Nacht usw.
#define HK_EINdown 143           // Heizkrper EIN
#define HK_AUSdown 144           // Heizkrper AUS
#define FBH_EINdown 145          // Fubodenheizung EIN
#define FBH_AUSdown 146          // Fubodenheizung AUS
#define OfenEINdown 147          // Ofenpumpe EIN
#define OfenAUSdown 148          // Ofenpumpe AUS
#define GasEINdown 149           // Gasofen EIN
#define PufferEINdown 150        // Gasofen AUS Puffer EIN
#define HKMischerAUFdown 151     // Mischer Heizkrper AUF
#define HKMischerZUdown 152      // Mischer Heizkrper ZU
#define FBHMischerAUFdown 153    // Mischer Fubodenheizung AUF
#define FBHMischerZUdown 154     // Mischer Fubodenheizung ZU
#define StartEnergie 155         // Energiemessung starten
#define StopEnergie 156          // Energiemessung stoppen
#define HK_TempSOLLdown 157      // Temperaturwahl fr HK
#define FBH_TempSOLLdown 158     // Temperaturwahl fr FBH
//------------------------------------------------------------------------------
#define Error_reset 250         // Errors zurcksetzten
#define Error_return 251        // Zurck aus dem Errormen
#define Error_down 252          // Taste fr Errormen
#define Error_up 253            // Taste fr Errormen
#define Touchdown 254           // fr Display max. Beleuchtung, sonst keine Funktion
#define Touchup 255             // fr Display max. Beleuchtung, sonst keine Funktion
// -------------------- Definitionen fr UTI Bearbeitung -----------------------
#define 4Draht 4                // PT1000 Sensor mit 4 Drhten->Jumper+Widerstand ndern
#define 2Draht 2                // PT1000 Sensor mit 2 Drhten
#define Tmax 20000.0            // Obere Grenze fr ein Tempzeitsignal Signal
#define T_OFFmax 1500.0         // Obere Grenze fr das OFF Signal
#define T_OFFmin 1000.0         // Untere Grenze fr das OFF Signal
#define UTI_Limit 8             // Anzahl der addierten Temperaturwerte  5
#define A 3.9083e-3             // Umrechung der Widerstandswerte auf Temperatur
#define B -5.775e-7             // Polynom dritter Ordnung
#define C -4.183e-12
#define R0 1000.0
#define A_R0 -A*R0
#define A_R0_2 (A*R0)*(A*R0))
#define B_R0_4 4*B*R0
#define B_R0_2 2*B*R0

#define TMP_aussen_korr -0.2    // Fr Leitungskorrektur
#define UTI1T1korr 0.0
#define UTI1T2korr -0.0
#define TMP_Ofen_korr -2.0
#define TMP_Rauchgas_korr -1.5
#define UTI2T2korr 0.0
#define UTI3T0korr 0.0
#define UTI3T1korr 0.0
#define UTI3T2korr 0.0
// ------------------------- Definitionen fr ADC ------------------------------
#define Helligkeit 100          // ADC 1 fr Lichtsensor aktivieren
#define StromE_KFZ 101          // ADC 2 fr Stromwandlermessung E-KFZ Ladestrom
#define ADC_Limit 30            // Anzahl der Integrationen
#define TMP_WG_OBENkorr 0.0     // Korrektur fr LM35
#define TMP_WG_UNTENkorr 0.0    // Korrektur fr LM35
#define TMP_WG_OSTkorr 0.0      // Korrektur fr LM35
#define TMP_WG_WESTkorr -0.0    // Korrektur fr LM35
#define TMP_RAUMkorr 0.5        // Korrektur fr LM35
#define TMP_SPEICH_unten_korr -0.4 // Speicherfhler unten Korrektur LM35
#define TMP_SPEICH_1_4_korr 0.0 // Speicherfhler 1/4 Hhe Korrektur LM35
#define TMP_SPEICH_2_4_korr -0.1 // Speicherfhler 2/4 Hhe Korrektur LM35
#define TMP_SPEICH_3_4_korr -0.4 // Speicherfhler 3/4 Hhe Korrektur LM35
#define TMP_SPEICH_oben_korr -0.7// Speicherfhler unten Korrektur LM35
#define TMP_FBH_korr -0.5        // Fhlerkorrektur LM35 Fubodenheizung Vorlauf
#define TMP_HK_korr 0.1         // Fhlerkorrektur LM35 Heizkrper Vorlauf
#define MUXA 19                 // Portansteuerung Analogmux -> A  H=aktiv
#define MUXB 20                 // Portansteuerung Analogmux -> B
#define MUXC 21                 // Portansteuerung Analogmux -> C
#define MUXD 50                 // Portansteuerung Analogmux -> Umschaltung zwischen 2 Bausteinen L=aktiv
//--------------------- Definitionen fr Anzeige am Display --------------------
#define P1TXTx1 75              // xPos Page1 Spalte1 fr Text+Messwert
#define P1TXTy1 32              // yPos Page1 Zeile1 fr Text
#define P1TXTx2 315             // xPos Page1 Spalte1 fr Text+Messwert
#define P1TXTy2 134             // yPos Page1 Zeile2 fr Text
#define P1Werty1 60             // yPos Page1 Spalte1 fr Messwert
#define P1Werty2 162            // yPos Page1 Zeile2 fr Messwert

#define WGy0 32                 // 0te Zeile vor Menleiste
#define WGy1 55                 // 1te Zeile nach Menleiste
#define WGy2 78                 // 2te Zeile
#define WGy3 101                // 3te Zeile
#define WGy4 124                // 4te Zeile
#define WGy5 147                // 5te Zeile
#define WGy6 170                // 6te Zeile
#define WGy7 193                // 7te Zeile
#define WGy8 216                // 8te Zeile
#define WGy9 239                // 9te Zeile
#define WGy10 262               // 10te Zeile
#define WGTy1 53                // 1te Touchkoordinate in y
#define WGTy2 100               // 2te Touchkoordinate in y
#define WGTy3 147               // 3te Touchkoordinate in y
#define WGTy4 194               // 4te Touchkoordinate in y
#define WGTy5 251               // 5te Touchkoordinate in y
#define WGT45P 45               // Touchabstand 40 Pixel
#define WGT70P 75               // Touchabstand 70 Pixel
//--------------------------- E-KFZ --------------------------------------------
#define E_KFZ_Stromstoss 0x40   // Stromstoschalter wird geschaltet (Reedkontakt)
#define E_KFZ_Stecker 0x80      // Ladekabel wird angesteckt  0x80 ( fr Test 0x01 Schalter Tableau Wohnzimmer)
#define E_KFZ_Stromschwelle 0.8 // Schwelle fr Ladungserkennung des E-KFZ  1.0
#define E_KFZ_powerpoint 400    // Schwelle fr Ladungseinschaltung abhngig von PV Leistung
//------------------------ P V - A N L A G E -----------------------------------
#define WR_LufterON 50          // Max. WR Temp. frs Lftereinschalten
#define WR_LufterOFF 48         // Ausschalt Temp. fr Lfter
#define WRL_RelOFF 0x01         // Relais fr Lfter AUS  Ausgang1 Bit0 von OUT_1-8
#define WRL_RelON 0xFE          // Relais fr Lfter EIN  Ausgang1 Bit0 von OUT_1-8
//------------ S T A T U S D E F I N I T I O N E N  Wintergarten ---------------
#define WGB_AUTOM 0x10          // Beschattung AUTOMATIKBETRIEB
#define WGF_AUTOM 0x20          // Fenster AUTOMATIKBETRIEB
#define WGK_AUTOM 0x40          // Klappe AUTOMATIKBETRIEB
#define WGS_AUTOM 0x80          // Speicher AUTOMATIKBETRIEB
#define WGBunten 0x01           // Beschattung ist ausgefahren
#define WGBoben 0xFE            // Beschattung ist eingefahren
#define WGFoffen 0x02           // Fenster sind offen
#define WGFzu 0xFD              // Fenster sind geschlossen
#define WGKoffen 0x04           // Klappe OG ist offen
#define WGKzu 0xFB              // Klappe OG ist geschlossen
#define WGSein 0x08             // Speicherlfter EIN
#define WGSaus 0xF7             // Speicherlfter AUS
//---------------------- B E S C H A T T U N G ---------------------------------
#define WGBdelay  15            // Verzgerung fr Beschattung ausfahren in Minuten
#define WGBmove  50             // Zeit fr Beschattung ausfahren in Sekunden
#define WGB_TMPmax 46           // Max. WR Temp. zum verzgerten Ausfahren
#define WGB_TMPmin 45           // AuslseWR Temp. zum verzgerten Einfahren
#define WGB_WINDmax 26          // Maximale Windgeschwindigkeit Markise rein
#define cntWind_max 3           // Maximale Einfahrten aufgrund von Wind
#define WGB_RelOFF 0x04         // Relais fr Markise AUS und Richtung EINFAHREN
#define WGB_RelON 0xFB          // Relais fr Markise EIN und Richtung AUSFAHREN
#define WGB_TriacOFF 0x01       // Triac fr Markise EIN -> Markise steht
#define WGB_TriacON 0xFE        // Triac fr Markise AUS -> Markise fhrt
#define ModeB_NOP 0             // Minimale Aktivitt Markisensteuerung (PrgZeiten)
#define ModeB_Zero 1            // Rcksetzen einiger Beschattungsparameter
#define ModeB_ausfdel 2         // Mode fr verzgertes Ausfahren
#define ModeB_einfdel 3         // Mode fr verzgertes Einfahren
#define ModeB_ausf 4            // Mode frs Ausfahren
#define ModeB_Hausf 5           // Mode frs hndisches Ausfahren
#define ModeB_einf 6            // Mode frs Einfahren
#define ModeB_Wind 7            // Mode fr Windberschreitung
#define ModeB_Wind_einf 8       // Mode fr windbedingt Einfahren
//--------------------------- F E N S T E R ------------------------------------
#define WGFdelay  5             // Verzgerung fr Fenster ausfahren in Minuten
#define WGFmove  40             // Zeit fr Fenster ausfahren in Sekunden
#define WGF_WINDmax 17          // Maximale Windgeschwindigkeit f. Fenster ZU
#define WGF_TMPmax 32           // Auslse Temp. zum verzgerten ffnen
#define WGF_TMPmin 30           // Auslse Temp. zum verzgerten Schlieen
#define WGF_RelOFF 0x08         // Relais fr Fenster AUS und Richtung SCHLIEEN
#define WGF_RelON 0xF7          // Relais fr Fenster EIN und Richtung FFNEN
#define WGF_TriacOFF 0x02       // Triac Fenster AUS -> Fenstermotor steht
#define WGF_TriacON 0xFD        // Triac Fenster EIN -> Fenstermotor luft
#define ModeF_NOP 0             // Minimale Aktivitt Fenstersteuerung (PrgZeiten)
#define ModeF_Zero 1            // Rcksetzen einiger Beschattungsparameter
#define ModeF_opendel 2         // Mode fr verzgertes ffnen
#define ModeF_closedel 3        // Mode fr verzgertes Schlieen
#define ModeF_open 4            // Mode frs ffnen
#define ModeF_close 5           // Mode frs Schlieen
//------------------------- K L A P P E   O G ----------------------------------
#define WGK_TMPmax 23           // Auslse Temp. zum ffnen
#define WGK_TMPmin 20           // Auslse Temp. zum Schlieen
#define WGK_RelOFF 0x10         // Relais fr Klappe AUS->Klappe SCHLIET
#define WGK_RelON 0xEF          // Relais fr Klappe EIN->Klappe FFNET
#define ModeK_Aopen 1           // Klappen FFNEN im Automatikbetrieb TMPabhngig
#define ModeK_Aclose 6          // Klappen SCHLIEEN automatisch
#define ModeK_open 2            // Klappe per Touch geffnet
#define ModeK_close 5           // Klappe wird per Touch geschlossen
#define ModeK_NOP 3             // Keine Aktivitt bei der Klappe. Mode neutral
//#define ModeK_AUTO 4            // Automatikbetrieb ist aktiv
//------------------ S P E I C H E R   L  F T E R -----------------------------
#define WGS_TMPdiff_max 7       // Max. Tempdifferenz fr Speicherlfter EIN
#define WGS_TMPdiff_min 5       // Tempdifferenz fr Speicherlfter AUS
#define WGS_RelOFF 0x20         // Relais fr Speicherlfter AUS->Motor AUS
#define WGS_RelON 0xDF          // Relais fr Speicherlfter EIN->Motor EIN
#define ModeS_Aon 1             // Motor EIN im Automatikbetrieb TMPabhngig
#define ModeS_Aoff 6            // Motor AUS im Automatikbetrieb TMPabhngig
#define ModeS_on 2              // Motor per Touch EIN
#define ModeS_off 5             // Motor per Touch AUS
#define ModeS_NOP 3             // Keine Aktivitt beim Lfter. Mode neutral
//#define ModeS_TOUCH 3           // Touchbetrieb ist aktiv
//#define ModeS_AUTO 4            // Automatikbetrieb ist aktiv
//------------------------WINTERGARTEN ENDE ------------------------------------
//-------------- R O L L L  D E N   D A C H F E N S T E R ---------------------
#define DachRoll_TMPmax 27      // Aussentemperatur Sommer Rollladen runterfahren
#define DachRoll_TMPmin 24      // Aussentemperatur Sommer Rollladen rauffahren
//#define DachRoll_TMPWintermax 17      // Aussentemperatur Winter Rollladen runterfahren
#define DachR_WinterTempmin 4 // Min. Temp fr Rolladenbewegung => Einfrieren
//------------- S T A T U S D E F I N I T I O N E N  ROLLLDEN -----------------
#define RS_AUTOM 0x10           // Rollladen Stiege AUTOMATIKBETRIEB
#define RB_AUTOM 0x20           // Rollladen Bad AUTOMATIKBETRIEB
#define RK_AUTOM 0x40           // Rollladen Kind AUTOMATIKBETRIEB
#define RSunten 0x01            // Rollladen Stiege ist unten
#define RSoben 0xFE             // Rollladen Stiege ist oben
#define RBunten 0x02            // Rollladen Bad ist unten
#define RBoben 0xFD             // Rollladen Bad ist oben
#define RKunten 0x04            // Rollladen Kind ist unten
#define RKoben 0xFB             // Rollladen Kind ist oben
//-------------------- R O L L A D E N   S T I E G E ---------------------------
#define RSmove  40              // Zeit fr Rollladen ausfahren in Sekunden
#define RS_TMPmax 32            // Auslse Temp. zum Ausfahren
#define RS_TMPmin 30            // Auslse Temp. zum Einfahren
#define RS_RelOFF 0x01          // Relais fr Rollladen AUS und Richtung EINFAHREN
#define RS_RelON 0xFE           // Relais fr Rollladen EIN und Richtung AUSFAHREN
#define RS_TriacOFF 0x04        // Triac Rollladen AUS -> Rollladenmotor steht
#define RS_TriacON 0xFB         // Triac Rollladen EIN -> Rollladenmotor luft
#define ModeRS_NOP 0            // Minimale Aktivitt Rollladensteuerung (PrgZeiten)
#define ModeRS_Zero 1           // Rcksetzen einiger Parameter
#define ModeRS_unten 3          // Mode frs Ausfahren
#define ModeRS_oben 4           // Mode frs Einfahren
//---------------------- Eingnge Taster Obergescho ---------------------------
#define RSdown 0x01             // Taster Rollladen Stiege nach Unten Eingang 17, Bit 0 von IN 17-24
#define RSup 0x02               // Taster Rollladen Stiege nach Oben Eingang 18, Bit 1 von IN 17-24
//---------------------- R O L L A D E N   B A D -------------------------------
#define RBmove  40              // Zeit fr Rollladen ausfahren in Sekunden
#define RB_TMPmax 32            // Auslse Temp. zum Ausfahren
#define RB_TMPmin 30            // Auslse Temp. zum Einfahren
#define RB_RelOFF 0x02          // Relais fr Rollladen AUS und Richtung EINFAHREN
#define RB_RelON 0xFD           // Relais fr Rollladen EIN und Richtung AUSFAHREN
#define RB_TriacOFF 0x08        // Triac Rollladen AUS -> Rollladenmotor steht
#define RB_TriacON 0xF7         // Triac Rollladen EIN -> Rollladenmotor luft
#define ModeRB_NOP 0            // Minimale Aktivitt Rollladensteuerung (PrgZeiten)
#define ModeRB_Zero 1           // Rcksetzen einiger Parameter
#define ModeRB_unten 3          // Mode frs Ausfahren
#define ModeRB_oben 4           // Mode frs Einfahren
//---------------------- Eingnge Taster Obergescho ----------------------------
#define RBdown 0x04             // Taster Rollladen Bad nach Unten Eingang 19, Bit 2 von IN 17-24
#define RBup 0x08               // Taster Rollladen Bad nach Oben Eingang 20, Bit 3 von IN 17-24
//---------------------- R O L L A D E N   K I N D -----------------------------
#define RKmove  40              // Zeit fr Rollladen ausfahren in Sekunden
#define RK_TMPmax 32            // Auslse Temp. zum Ausfahren
#define RK_TMPmin 30            // Auslse Temp. zum Einfahren
#define RK_RelOFF 0x04          // Relais fr Rollladen AUS und Richtung EINFAHREN
#define RK_RelON 0xFB           // Relais fr Rollladen EIN und Richtung AUSFAHREN
#define RK_TriacOFF 0x10        // Triac Rollladen AUS -> Rollladenmotor steht
#define RK_TriacON 0xEF         // Triac Rollladen EIN -> Rollladenmotor luft
#define ModeRK_NOP 0            // Minimale Aktivitt Rollladensteuerung (PrgZeiten)
#define ModeRK_Zero 1           // Rcksetzen einiger Parameter
#define ModeRK_unten 3          // Mode frs Ausfahren
#define ModeRK_oben 4           // Mode frs Einfahren
//---------------------- Eingnge Taster Obergescho ---------------------------
#define RKdown 0x10             // Taster Rollladen Kind nach Unten Eingang 21, Bit 4 von IN 17-24
#define RKup 0x20               // Taster Rollladen Kind nach Oben Eingang 22, Bit 5 von IN 17-24

//------------------------ ROLLLDEN Fenster und Tren EG ----------------------
#define Mode_NOP 0              // Minimale Aktivitt Rollladensteuerung (PrgZeiten)
#define Mode_ausf 3             // Mode frs Ausfahren
#define Mode_einf 4             // Mode frs Einfahren

//------- S T A T U S D E F I N I T I O N E N  ROLLLDEN Kche -----------------
#define RKN_AUTOM 0x10          // Rollladen Kche Nord AUTOMATIKBETRIEB
#define RKO_AUTOM 0x20          // Rollladen Kche Ost AUTOMATIKBETRIEB
#define RKNunten 0x01           // Rollladen Kche Nord ist unten
#define RKNoben 0xFE            // Rollladen Kche Nord ist oben
#define RKOunten 0x02           // Rollladen Kche Ost ist unten
#define RKOoben 0xFD            // Rollladen Kche Ost ist oben
//------- S T A T U S D E F I N I T I O N E N  ROLLLDEN Wohnzimmer ------------
#define RWZT_AUTOM 0x10         // Rollladen Wohnzimmer Tre AUTOMATIKBETRIEB
#define RWZS_AUTOM 0x20         // Rollladen Wohnzimmer Sd AUTOMATIKBETRIEB
#define RWZW_AUTOM 0x40         // Rollladen Wohnzimmer West AUTOMATIKBETRIEB
#define RWZTunten 0x01          // Rollladen Wohnzimmer Tre ist unten
#define RWZToben 0xFE           // Rollladen Wohnzimmer Tre ist oben
#define RWZSunten 0x02          // Rollladen Wohnzimmer Sd ist unten
#define RWZSoben 0xFD           // Rollladen Wohnzimmer Sd ist oben
#define RWZWunten 0x04          // Rollladen Wohnzimmer West ist unten
#define RWZWoben 0xFB           // Rollladen Wohnzimmer West ist oben
//------- S T A T U S D E F I N I T I O N E N  ROLLLDEN OG --------------------
#define RGO_AUTOM 0x10          // Rollladen Gast Ost AUTOMATIKBETRIEB
#define RGT_AUTOM 0x20          // Rollladen Gast Tre AUTOMATIKBETRIEB
#define RST_AUTOM 0x40          // Rollladen Schlafen Tre AUTOMATIKBETRIEB
#define RKW_AUTOM 0x80          // Rollladen Gast West AUTOMATIKBETRIEB
#define RGOunten 0x01           // Rollladen Gast Ost ist unten
#define RGOoben 0xFE            // Rollladen Gast Ost ist oben
#define RGTunten 0x02           // Rollladen Gast Tre ist unten
#define RGToben 0xFD            // Rollladen Gast Tre ist oben
#define RSTunten 0x04           // Rollladen Schlafen Tre ist unten
#define RSToben 0xFB            // Rollladen Schlafen Tre ist oben
#define RKWunten 0x08           // Rollladen Kind West ist unten
#define RKWoben 0xF7            // Rollladen Kind West ist oben
//-------------------- R O L L A D E N   K  C H E  N O R D --------------------
#define RKN_FS20ADR 0x00
//--------------------- R O L L A D E N   K  C H E  O S T ---------------------
#define RKO_FS20ADR 0x01        // nach Test auf 0x01
//--------------- R O L L A D E N   W O H N Z I M M E R T  R E ----------------
#define RWZT_FS20ADR 0x02       // nach Test auf 0x02
//----------------- R O L L A D E N   W O H N Z I M M E R   S  D --------------
#define RWZS_FS20ADR 0x03       // nach Test auf 0x03
//----------------- R O L L A D E N   W O H N Z I M M E R   West ---------------
#define RWZW_FS20ADR 0x04       // nach Test auf 0x04
//----------------- R O L L A D E N   OG Gast Ost ------------------------------
#define RGO_FS20ADR 0x05        // nach Test auf 0x05
//----------------- R O L L A D E N   OG Gast Tre -----------------------------
#define RGT_FS20ADR 0x06        // nach Test auf 0x06
 //----------------- R O L L A D E N   Schlafen Tre ---------------------------
#define RST_FS20ADR 0x07        // nach Test auf 0x07
//----------------- R O L L A D E N   Kind West --------------------------------
#define RKW_FS20ADR 0x08        // nach Test auf 0x08
//------------- FS20 Wechselschalter Stiegenhauslicht --------------------------
#define WS1_Stiege_FS20ADR 0xF8 // nach Test auf 0xF8
//----------------- FS20 Steckdose --------------------------------
#define ST4_Ventilator_FS20ADR 0xA0 //Ventilator Keller
#define ST4_KFZ_Ladung_FS20ADR 0xA1 //E-KFZ Ladung
//-------------------------- RS 232 fr FS20 Sender ----------------------------
// 10 byte Sende + 10 Empfangspuffer + 6 byte interne FIFO Verwaltung
#define FSbuffer 156         // Definition des Sende-Eingangspuffers
#define FS20US_Empf 100         // Empfangspuffer fr FS20US
#define FS20US_Send 50          // Sendepuffer fr FS20US
#define FS20US_RS232 1          // Schnittstelle fr FS20US 1te RS232

//--------------------------- FS20 Sender --------------------------------------
#define RL_einfahren 0x39       // Befehl frs Einfahren FS20 US => FS20 RSU
#define RL_ausfahren 0x38

#define RL_intTimer 0x36        // Interne Timerzeit fr Handbetrieb programmieren

#define R_timer 40              // Verzgerung im Autobetrieb zwischen dem Ein-
                                // bzw- Ausfahren der Rolllden
#define Hausadresse1 0x17
#define Hausadresse2 0x09
#define RL_Timer_Ture 0x48      // Rolladentimerzeit Tre ber FS20 0x4A=40 0x48=42 Sekunden
#define RL_Timer_Fenster 0x3A   // Rolladentimerzeit Fenster ber FS20 20 Sekunden
#define RL_Timer_5 0x1A        // Rolladentimerzeit ber FS20 5 Sekunden
#define RL_Timer_10 0x2A        // Rolladentimerzeit ber FS20 10 Sekunden
#define RL_Timer_50 0x2A        // Rolladentimerzeit 50% ber FS20 10 Sekunden
#define RL_Timer_75 0x2A        // Rolladentimerzeit 75% ber FS20 10 Sekunden
#define RL_KcheOst 0x01
#define RL_WZ_Ost 0x02
#define RL_WZ_Sud 0x03
#define RL_WZ_West 0x04
#define RL_Kind_West 0x05
#define RL_Gast_Ost 0x06
#define RL_Gast_Sud 0x07
#define RL_Schlaf_Ost 0x08
//------------------------ROLLLDEN ENDE ------------------------------------
//------------------------ ALARMANLAGE -----------------------------------------
#define default_Urlaub 13       // Startzeit fr Anwesenheitsvortuschung => Rollden
#define Al_Sirene 15            // Verzgerungszeit fr Alarmierung
#define Al_time 60              // Zeit in der alarmiert wird
#define Al_OFF 0                // Alarmcheck -> 0 = Alarm ausgeschaltet
#define Al_ON 1                 // Alarmcheck -> 1 = Alarm eingeschaltet
#define Al_Kontakt_Test 2       // Alarmcheck -> 2 = Kontakte werden getestet
#define Al_Kontakte_defekt 128  // Alarmcheck -> 128 = mind. ein Reedkontakt defekt
#define Al_scharf 4             // Alarmcheck -> 4 = Alarmkontakte werden berwacht
#define Alarm 8                 // Alarmcheck -> 4 = Alarmkontakt hat angesprochen
#define Al_merken 16            // Alarmcheck -> 8 = Alarm ist ausgelst worden
#define Al_PANIK 32             // Sirene nach Verzgerungszeit ansteuern
#define AL_RelON 0xBF           // Relais fr Sirene ansteuern Ausgang7 Bit6 von OUT_1-8
#define AL_RelOFF 0x40          // Relais fr Sirene absteuern Ausgang7 Bit6 von OUT_1-8
#define Al_KontakteOK 0xF0      // Alle Tren sind geschlossen
#define Al_time_KontaktCheck 10 // Zeit fr die Abfrage der Trkontakte->OK
#define Haust 0x01              // Kontakt Haustre
#define Wohnzt 0x02             // Kontakt Wohnzimmertre
#define Wintergt 0x04           // Kontakt Wintergartentre
#define Kellert 0x08            // Kontakt Kellertre
//------------------------------ ZSauger  --------------------------------------
#define ZSaugerNachl_max 20     // Max. eizustellende Laufzeit (Spg bleibt am Sauger)
                                //  fr ZSaugernachlauf Blumen in Minuten
#define ZSaugerAnford 0x10      // Anforderung ZSauger einschalten Eingang 13, Bit 4 von IN 9-16
//------------------------------- Teichpumpe -----------------------------------
#define Teichp_WRtmpON 40       // Einschalttemp WR fr Pumpe EIN im Auotbetrieb
#define Teichp_WRtmpOFF 38      // Ausschalttemp WR fr Pumpe AUS im Auotbetrieb
#define TeichpLauf1_max 5       // Max. eizustellende Laufzeit1 fr Teichpumpe in Stunden
#define TeichpLauf2_max 5       // Max. eizustellende Laufzeit2 fr Teichpumpe in Stunden
#define Teichp_RelOFF 0x02      // Relais Teichpumpe AUS -> Ausgang2 Bit1 von OUT 1-8
#define Teichp_RelON 0xFD       // Relais Teichpumpe EIN -> Ausgang2 Bit1 von OUT 1-8

#define ModeTeichpHAND 0        // Teichpumpe im Handbetrieb
#define ModeTeichpAUTO 1        // Teichpumpe im Automatikbetrieb
#define ModeTeichp_off 2        // Teichpumpe Wohnzimmer ausschalten
#define ModeTeichp_PVon 3       // Teichpumpe Leistungsbezogen einschalten
#define ModeTeichp1_on 4        // Teichpumpe einschalten Start1
#define ModeTeichp2_on 5        // Teichpumpe einschalten Start2
#define ModeTeichp_Hoff 6       // Teichpumpe hndisch Ausschalten
#define ModeTeichp_Hon 7        // Teichpumpe hndisch Einschalten
//----------------------------- Wasserenthrtung -------------------------------
#define H2OEnthartg_RelOFF 0x01    // Relais Wasserenthrtung AUS -> Ausgang9 Bit0 von OUT 9-16
#define H2OEnthartg_RelON 0xFE     // Relais Wasserenthrtung EIN -> Ausgang9 Bit0 von OUT 9-16
//-------------------------- Bewsserung Blumenlicht ---------------------------
#define BLichtLauf_max 5        // Max. eizustellende Laufzeit fr Beleuchtung Blumen in Stunden
#define BLicht_RelOFF 0x02      // Relais Blumenlicht AUS -> Ausgang10 Bit1 von OUT 9-16
#define BLicht_RelON 0xFD       // Relais Blumenlicht EIN -> Ausgang10 Bit1 von OUT 9-16
#define ModeBLicht_off 0        // Blumenlicht Wohnzimmer ausschalten
#define ModeBLicht_on 1         // Blumenlicht Wohnzimmer einschalten
#define ModeBLicht_Hoff 2       // Blumenlicht Wohnzimmer hndisch ausschalten
//---------------------------------- Heizung -----------------------------------
#define Ofen_TriacOFF 0x40      // Triac fr Ofenpumpe AUS
#define Ofen_TriacON 0xBF       // Triac fr Ofenpumpe EIN
#define HK_M_TriacOFF 0x20      // Triac fr Heizkrpermischer AUS
#define HK_M_TriacON 0xDF       // Triac fr Heizkrpermischer EIN
#define FBH_M_TriacOFF 0x10     // Triac fr Fubodenheizungsmischer AUS
#define FBH_M_TriacON 0xEF      // Triac fr Fubodenheizungsmischer EIN
#define FBH_TriacOFF 0x08       // Triac fr FBH Pumpe AUS
#define FBH_TriacON 0xF7        // Triac fr FBH Pumpe EIN
#define HK_TriacOFF 0x04        // Triac fr HK Pumpe AUS
#define HK_TriacON 0xFB         // Triac fr HK Pumpe EIN
#define ZEIT_TriacOFF 0x02      // Triac fr Zeitschaltuhr AUS ber Stromstoschalter umschalten
#define ZEIT_TriacON 0xFD       // Triac fr Zeitschaltuhr EIN ber Stromstoschalter umschalten
#define PUFFER_TriacOFF 0x02    // Triac auf Puffer schalten
#define GAS_TriacON 0xFE        // Triac auf Gas schalten

#define HK_Mzu_RelOFF 0x04      // Relais K2 AUS -> Ausgang11 Bit2 von OUT 9-16 (Mischer HK Richtung)
#define HK_Mauf_RelON 0xFB      // Relais K2 EIN -> Ausgang11 Bit2 von OUT 9-16
#define FBH_Mzu_RelOFF 0x08     // Relais K1 AUS -> Ausgang12 Bit3 von OUT 9-16 (Mischer FBH Richtung)
#define FBH_Mauf_RelON 0xF7     // Relais K1 EIN -> Ausgang12 Bit3 von OUT 9-16

#define ModeHK_M_NOP 0          // Minimale Aktivitt Mischersteuerung (PrgZeiten)
#define ModeHK_M_Zero 1         // Rcksetzen einiger Parameter
#define ModeHK_M_auf 3          // Mode frs Auffahren
#define ModeHK_M_zu 4           // Mode frs Zufahren

#define ModeFBH_M_NOP 0         // Minimale Aktivitt Mischersteuerung (PrgZeiten)
#define ModeFBH_M_Zero 1        // Rcksetzen einiger Parameter
#define ModeFBH_M_auf 3         // Mode frs Auffahren
#define ModeFBH_M_zu 4          // Mode frs Zufahren

#define T_schalt_Ofen 62        // Einschalttemperatur fr Holzofenpumpe

#define Aus 0                   // Heizungswahl Aus
#define Tag 1                   // Heizungswahl Tag
#define TagNacht 2              // Heizungswahl Tag/Nachtabsenkung
#define TagAus 3                // Heizungswahl Tag/Aus
//------------------------------- Klingel --------------------------------------
#define Klingel 0x08            // Klingeltaster Eingang 12, Bit 3 von IN 9-16
//--------------------- Definitionen Vergabe der EEProm Adressen ---------------
#define e_adr_AL_Start 0        // EEProm Adresse fr Alarm Startzeit
#define e_adr_AL_Ende 1         // EEProm Adresse Alarm Endezeit
#define e_adr_AL_Check 2        // EEProm Adresse AlarmKontakt/Statusspeicher


#define e_adr_ZSAUG_Nachl 3     // EEProm Adresse fr Saugernachlaufzeit
#define e_adr_TPUMP_Start1 4    // EEProm Adresse fr Teichpumpenstartzeit1
#define e_adr_TPUMP_Lauf1 5     // EEProm Adresse Teichpumpenlaufzeit1 in Minuten
#define e_adr_TPUMP_Start2 6    // EEProm Adresse fr Teichpumpenstartzeit2
#define e_adr_TPUMP_Lauf2 7     // EEProm Adresse Teichpumpenlaufzeit2 in Minuten

#define e_adr_ZSAUG_second 8    // EEProm Adresse fr Betriebsstundenzhler ZSauger
#define e_adr_ZSAUG_minute 9    // EEProm Adresse fr Betriebsstundenzhler ZSauger
#define e_adr_ZSAUG_hour 11     // EEProm Adresse fr Betriebsstundenzhler ZSauger
#define e_adr_BLICHT_Start 12   // EEProm Adresse Licht Blumen Wohnzimmer Startzeit
#define e_adr_BLICHT_Lauf 13    // EEProm Adresse Licht Blumen Wohnzimmer Laufzeit in Stunden
#define e_adr_BEW_Start1 14     // EEProm Adresse fr Bewsserungsstartzeit1
#define e_adr_BEW_Lauf1 15      // EEProm Adresse Bewsserungslaufzeit1 in Minuten
#define e_adr_BEW_Start2 16     // EEProm Adresse fr Bewsserungsstartzeit2
#define e_adr_BEW_Lauf2 17      // EEProm Adresse Bewsserungslaufzeit2 in Minuten

#define e_adr_WGstat 18         // EEProm Adresse Status Wintergarten
#define e_adr_Rstat 19          // EEProm Adresse Status Rolllden Dachflche
#define e_adr_RKstat 20         // EEProm Adresse Status Rolllden Kche
#define e_adr_RWZstat 21        // EEProm Adresse Status Rolllden Wohnzimmer
#define e_adr_ROGstat 22        // EEProm Adresse Status Rolllden OG

#define e_adr_Ladeartwahl 23    // EEProm Adresse Status Ladeart Eco, fix laden usw.
#define e_adr_E_KFZ_Ladestatus 24 // EEProm Adresse Status der momentanen Ladung
#define e_adr_Starts 25         // EEProm Adresse fr Prozessorstarts - Abstrze Watchdog?

#define e_adr_GasEIN1_hh 26     // EEProm Adresse fr Gasstart1 Stunde
#define e_adr_GasEIN1_mm 27     // EEProm Adresse fr Gasstart1 Minute
#define e_adr_GasAUS1_hh 28     // EEProm Adresse fr Gasstop1 Stunde
#define e_adr_GasAUS1_mm 29     // EEProm Adresse fr Gasstop1 Minute
#define e_adr_GasEIN2_hh 30     // EEProm Adresse fr Gasstart2 Stunde
#define e_adr_GasEIN2_mm 31     // EEProm Adresse fr Gasstart2 Minute
#define e_adr_GasAUS2_hh 32     // EEProm Adresse fr Gasstop2 Stunde
#define e_adr_GasAUS2_mm 33     // EEProm Adresse fr Gasstop2 Minute

#define e_adr_PufferEIN1_hh 34     // EEProm Adresse fr Pufferstart1 Stunde
#define e_adr_PufferEIN1_mm 35     // EEProm Adresse fr Pufferstart1 Minute
#define e_adr_PufferAUS1_hh 36     // EEProm Adresse fr Pufferstop1 Stunde
#define e_adr_PufferAUS1_mm 37     // EEProm Adresse fr Pufferstop1 Minute
#define e_adr_PufferEIN2_hh 38     // EEProm Adresse fr Pufferstart2 Stunde
#define e_adr_PufferEIN2_mm 39     // EEProm Adresse fr Pufferstart2 Minute

#define e_adr_EgesE_KFZ 40    // Energieverbrauch fr E-KFZ speichern 4 byte freilassen

#define e_adr_PufferAUS2_hh 44     // EEProm Adresse fr Pufferstop2 Stunde
#define e_adr_PufferAUS2_mm 45     // EEProm Adresse fr Pufferstop2 Minute

#define e_adr_FBH_EIN1_hh 46     // EEProm Adresse fr Fubodenhzgstart1 Stunde
#define e_adr_FBH_EIN1_mm 47     // EEProm Adresse fr Fubodenhzgstart1 Minute
#define e_adr_FBH_AUS1_hh 48     // EEProm Adresse fr Fubodenhzgstop1 Stunde
#define e_adr_FBH_AUS1_mm 49     // EEProm Adresse fr Fubodenhzgstop1 Minute
#define e_adr_FBH_EIN2_hh 50     // EEProm Adresse fr Fubodenhzgstart2 Stunde
#define e_adr_FBH_EIN2_mm 51     // EEProm Adresse fr Fubodenhzgstart2 Minute
#define e_adr_FBH_AUS2_hh 52     // EEProm Adresse fr Fubodenhzgstop2 Stunde
#define e_adr_FBH_AUS2_mm 53     // EEProm Adresse fr Fubodenhzgstop2 Minute

#define e_adr_TIMER_Ladung 54    // EEProm Adresse fr Pufferladungszeit fr Energiemessung
#define e_adr_Hzgwahl 55         // EEProm Adresse fr Heizungwahl Tag,Tag/Nachtabsenkung usw.
#define e_adr_HK_TmpSOLL 56          // EEProm Adresse fr Heizkrper Zieltemp fr Mischer
#define e_adr_FBH_TmpSOLL 57         // EEProm Adresse fr Fubodenheizung Zieltemp fr Mischer