//----- Programm fr Ausgabe von 4 Steuercodes mit jeweils 8 Bit ---------------
//
// Code1/2 =Steuerzeichen, x1/y1Positionsplatzhalter.
//
void eDIP_cmd4_8(char code1,char code2,byte x1,byte y1)
{
  bcc_eDIP=0;               // Checksummenzhler auf Null setzten
  len=5;                    // ESC, code1, code2, x1, y1

  I2C_Start();              // IIC Bus Starten
  I2C_Write(eDIP_W);        // Schreibadresse des Displays auf Bus
  I2C_Write(DC1);           // Protokollbeginn fr Ausgabecode/Text
  bcc_eDIP=bcc_eDIP+DC1;    // Zeichen f. Protokollbeginn zu Checksumme addieren
  I2C_Write(len);           // Lnge der zu bertragenen Byte angeben
  bcc_eDIP=bcc_eDIP+len;    // Bytelnge zu Checksumme
  I2C_Write(ESC);           // Befehlseinleitung
  bcc_eDIP=bcc_eDIP+ESC;
  I2C_Write(code1);         // Befehlscode 1 bertragen
  bcc_eDIP=bcc_eDIP+code1;
  I2C_Write(code2);
  bcc_eDIP=bcc_eDIP+code2;
//~~~~~~~~~~~~~~~~~~~~~~~~~~ Positionen bertragen ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  I2C_Write(x1); bcc_eDIP=bcc_eDIP+x1;  // Position ausgeben, Checksumme erhhen
  I2C_Write(y1); bcc_eDIP=bcc_eDIP+y1;
  Checks_IICstop_ACK();
}
//-------------- Programm fr Ausgabe von Steuercodes bzw. Texten --------------
//
// Bei Textausgabe len=Textlnge, code1/2 entsprechende Steuerzeichen,
// x1/y1/x2/y2 Positionsplatzhalter, downC/upC sind Zuweisungen fr Tasten-
// definition. x1/y1/x2/y2/downC/upC werden bei Wert 255 ignoriert; len bei 0.
//
void eDIP_cmd(byte len,char code1,char code2,byte x1,byte y1,byte x2,byte y2,
              byte downC, byte upC)
{
  byte m_len;
  m_len=len;
  bcc_eDIP=0;               // Checksummenzhler auf Null setzten
  if (len>0) len=len+1;     // Textlnge+NULL (Textabschlu)
  len=len+3;                // ESC, code1, code2
  if (x1!=d8) len=len+1;       if (y1!=d8) len=len+1;
  if (x2!=d8) len=len+1;       if (y2!=d8) len=len+1;
  if (downC!=d8) len=len+1;    if (upC!=d8) len=len+1;

  I2C_Start();              // IIC Bus Starten
  I2C_Write(eDIP_W);        // Schreibadresse des Displays auf Bus
  I2C_Write(DC1);           // Protokollbeginn fr Ausgabecode/Text
  bcc_eDIP=bcc_eDIP+DC1;    // Zeichen f. Protokollbeginn zu Checksumme addieren
  I2C_Write(len);           // Lnge der zu bertragenen Byte angeben
  bcc_eDIP=bcc_eDIP+len;    // Bytelnge zu Checksumme
  I2C_Write(ESC);           // Befehlseinleitung
  bcc_eDIP=bcc_eDIP+ESC;
  I2C_Write(code1);         // Befehlscode 1 bertragen
  bcc_eDIP=bcc_eDIP+code1;
  I2C_Write(code2);
  bcc_eDIP=bcc_eDIP+code2;
//~~~~~~~~~~~~~~~~~~~~~~~~~~ Positionen bertragen ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  if (x1!=d8)
  {
    I2C_Write(x1); bcc_eDIP=bcc_eDIP+x1;  // Position ausgeben, Checksumme erhhen
  }
  if (y1!=d8)
  {
    I2C_Write(y1); bcc_eDIP=bcc_eDIP+y1;
  }
  if (x2!=d8)
  {
    I2C_Write(x2); bcc_eDIP=bcc_eDIP+x2;
  }
  if (y2!=d8)
  {
    I2C_Write(y2); bcc_eDIP=bcc_eDIP+y2;
  }
  if (downC!=d8)
  {
    I2C_Write(downC); bcc_eDIP=bcc_eDIP+downC;
  }
  if (upC!=d8)
  {
    I2C_Write(upC); bcc_eDIP=bcc_eDIP+upC;
  }
  if (m_len==0) Checks_IICstop_ACK();  // Wenn kein Text len=0 -> Abschlu
  // ansonsten muss vom aufrufenden Prg noch der Text aufgerufen werden
}
//-------------------- Programm fr Ausgabe von Texten -------------------------
//
// Bei Textausgabe len=Textlnge, code1/2 entsprechende Steuerzeichen,
// xx1/yy1 Positionsplatzhalter. Dient nur zur Textausgabe
//
void eDIP_cmd16TXT(char code1,char code2,word xx1,word yy1)
{
  byte m_len;
  len=StringLength(Zeichenkette);
  bcc_eDIP=0;               // Checksummenzhler auf Null setzten
  len=len+8;                // ESC, code1, code2, xx1, yy1, Textlnge+NULL (Textabschlu)

  I2C_Start();              // IIC Bus Starten
  I2C_Write(eDIP_W);        // Schreibadresse des Displays auf Bus
  I2C_Write(DC1);           // Protokollbeginn fr Ausgabecode/Text
  bcc_eDIP=bcc_eDIP+DC1;    // Zeichen f. Protokollbeginn zu Checksumme addieren
  I2C_Write(len);           // Lnge der zu bertragenen Byte angeben
  bcc_eDIP=bcc_eDIP+len;    // Bytelnge zu Checksumme
  I2C_Write(ESC);           // Befehlseinleitung
  bcc_eDIP=bcc_eDIP+ESC;
  I2C_Write(code1);         // Befehlscode 1 bertragen
  bcc_eDIP=bcc_eDIP+code1;
  I2C_Write(code2);
  bcc_eDIP=bcc_eDIP+code2;
//~~~~~~~~~~~~~~~~~~~~~~~~~~ Positionen bertragen ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  I2C_Write(xx1); bcc_eDIP=bcc_eDIP+xx1;  // Position ausgeben, Checksumme erhhen
  I2C_Write(xx1>>8); bcc_eDIP=bcc_eDIP+(xx1>>8);

  I2C_Write(yy1); bcc_eDIP=bcc_eDIP+yy1;  // Position ausgeben, Checksumme erhhen
  I2C_Write(yy1>>8); bcc_eDIP=bcc_eDIP+(yy1>>8);
  Zeichenk();
}
//-------------- Programm fr Ausgabe von Steuercodes bzw. Texten --------------
//
// Bei Textausgabe len=Textlnge, code1/2 entsprechende Steuerzeichen,
// x1/y1/x2/y2 Positionsplatzhalter, downC/upC sind Zuweisungen fr Tasten-
// definition. x1/y1/x2/y2/downC/upC werden bei Wert 255 ignoriert; len bei 0.
//
void eDIP_cmd16(byte len,char code1,char code2,word xx1,word yy1,word xx2,word yy2,
              word downC, word upC)
{
  byte m_len;  byte test;
  m_len=len;
  bcc_eDIP=0;               // Checksummenzhler auf Null setzten
  if (len>0) len=len+1;     // Textlnge+NULL (Textabschlu)
  len=len+3;                // ESC, code1, code2
  if (xx1!=d16) len=len+2;            if (yy1!=d16) len=len+2;
  if (xx2!=d16) len=len+2;            if (yy2!=d16) len=len+2;
  if (downC!=d16)len=len+1;           if (upC!=d16) len=len+1;

  I2C_Start();              // IIC Bus Starten
  I2C_Write(eDIP_W);        // Schreibadresse des Displays auf Bus
  I2C_Write(DC1);           // Protokollbeginn fr Ausgabecode/Text
  bcc_eDIP=bcc_eDIP+DC1;    // Zeichen f. Protokollbeginn zu Checksumme addieren
  I2C_Write(len);           // Lnge der zu bertragenen Byte angeben
  bcc_eDIP=bcc_eDIP+len;    // Bytelnge zu Checksumme
  I2C_Write(ESC);           // Befehlseinleitung
  bcc_eDIP=bcc_eDIP+ESC;
  I2C_Write(code1);         // Befehlscode 1 bertragen
  bcc_eDIP=bcc_eDIP+code1;
  I2C_Write(code2);
  bcc_eDIP=bcc_eDIP+code2;
//~~~~~~~~~~~~~~~~~~~~~~~~~~ Positionen bertragen ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  if (xx1!=d16)
  {
    I2C_Write(xx1); bcc_eDIP=bcc_eDIP+xx1;  // Position ausgeben, Checksumme erhhen
    I2C_Write(xx1>>8); bcc_eDIP=bcc_eDIP+(xx1>>8);
  }
  if (yy1!=d16)
  {
    I2C_Write(yy1); bcc_eDIP=bcc_eDIP+yy1;  // Position ausgeben, Checksumme erhhen
    I2C_Write(yy1>>8); bcc_eDIP=bcc_eDIP+(yy1>>8);
  }
  if (xx2!=d16)
  {
    I2C_Write(xx2); bcc_eDIP=bcc_eDIP+xx2;  // Position ausgeben, Checksumme erhhen
    I2C_Write(xx2>>8); bcc_eDIP=bcc_eDIP+(xx2>>8);
  }
  if (yy2!=d16)
  {
    I2C_Write(yy2); bcc_eDIP=bcc_eDIP+yy2;  // Position ausgeben, Checksumme erhhen
    I2C_Write(yy2>>8); bcc_eDIP=bcc_eDIP+(yy2>>8);;
  }
  if (downC!=d16)
  {
    I2C_Write(downC); bcc_eDIP=bcc_eDIP+downC;
  }
  if (upC!=d16)
  {
    I2C_Write(upC); bcc_eDIP=bcc_eDIP+upC;
  }
  if (m_len==0) Checks_IICstop_ACK();  // Wenn kein Text len=0 -> Abschlu
  // ansonsten muss vom aufrufenden Prg noch der Text aufgerufen werden
}
//----------------------- Leseanforderung an Display ---------------------------
void eDIP_cmd_read(char code1)
{
  byte len;
  bcc_eDIP=DC2;
  len=1;
  I2C_Start();
  I2C_Write(eDIP_W);                // Schreiben ins Display
  I2C_Write(DC2);
  I2C_Write(len);
  bcc_eDIP=bcc_eDIP+len;
  I2C_Write(code1);
  bcc_eDIP=bcc_eDIP+code1;
}

//--------------- Programm fr die Vorbereitung der Zeichenausgabe -------------
//Format ist durch bergabe nderbar
void eDIP_TXT(char Format)
{
  len=StringLength(Zeichenkette);  // Lnge der bergebenen Zeichen bestimmen
  eDIP_cmd16(len,'Z',Format,TXTxx1,TXTyy1,d16,d16,d16,d16);
  Zeichenk();
}
//-------- Touch/Schalterdefinition mit zentrierter Beschriftung ---------------
void Touch_TXT(char T_SCH)
{
  len=StringLength(Zeichenkette)+1;     // Zeichekettenlnge bestimmen
  eDIP_cmd16(len,'A',T_SCH,Txx1,Tyy1,Txx2,Tyy2,Tdown,Tup);
  I2C_Write('C');                        // Beschriftung zentrieren
  bcc_eDIP=bcc_eDIP+'C';                 // Zentrierbefehl zur Checksumme
  Zeichenk();                            // Zeichen ausgeben
}
//------------------- Programm gibt die Zeichen Byteweise aus ------------------
void Zeichenk(void)
{
  int i;
  i=0;
  while(Zeichenkette[i] && i<Zeichenlimit)// wiederhole solange Zeichen nicht Null
  {
      I2C_Write(Zeichenkette[i]);    // Zeichen ans Display senden
      bcc_eDIP=bcc_eDIP+Zeichenkette[i];  // Checksumme aktualisieren
      Zeichenkette[i]=0;       // Zeichenarray leeren
      i++;
  }
  I2C_Write(NULL);             // Null bedeutet fr Display -> Zeichenende
  bcc_eDIP=bcc_eDIP+NULL;      // Checksumme aktualisieren
  Checks_IICstop_ACK();        // Checksumme bergeben und bertragung beenden
}

//-------------- Befehlsbesttigung mit Checksumme und Bus stoppen -------------
void Checks_IICstop_ACK(void)
{
  I2C_Write(bcc_eDIP);              // bergabe der Checksumme
  I2C_Stop();                       // Bus stoppen
  AbsDelay(1);                      // Verzgerung notwendig, da Display fr die
                                    // Bereitstellung der Daten Zeit bentigt
  eDIP_ACK();                       // Besttigung von Display abholen
}

//------------------------- IIC Bus stoppen ------------------------------------
void eDIP_ACK(void)
{
  I2C_Start();
  I2C_Write(eDIP_R);                // Lesemodus beim Display einstellen
  eDIP_Daten[i]=I2C_Read_NACK();    // Besttigung vom Display anfordern
  I2C_Stop();
}

//------------- Programm fr das Dimmen der Hintergrundbeleuchtung -------------
void eDIP_DIMMEN(void)
{
    eDIP_cmd(0,'Y','H',eDIP_dimm,d8,d8,d8,d8,d8);  //Helligkeit einstellen
}