/*------------------------------------------------------------------------------
 -- DEMO ----- DEMO ----- DEMO ----- DEMO ----- DEMO ----- DEMO ----- DEMO -----
 -------------------------------------------------------------------------------
 Projektname:       IC_BUS_PORTERWEITERUNG_OUT.cprj
 Bentigte Libss:  IntFunc_lib.cc,
 Routinen:          IC_BUS_PORTERWEITERUNG_OUT.cbas
 Autor:             UlliS
 Datum:             27.11.2007
 Funktion:          Verschiedene Ausgabe-Beispiele fr den PFC8574

 -------------------------------------------------------------------------------
 Beschreibung:
 Der PCF8574 hat eine whlbare 3-Bit Adresse. In unserem Beispiel gehen wir
 davon aus, dass alle Bits der Adresse LOW sind, die Adresse ist also nach
 der aufgedruckten Tabelle Hex 40!
 -------------------------------------------------------------------------------
 Achtung, ganz wichtig:
 Die Ports mssen als Ausgang initialisiert werden bevor der IIC-Bus
 benutzt wird: I2C_Init(I2C_100kHz)
 Wenn Sie einen Portzustand lesen. ist wichtig, dass vorher der PCF8574
 initialisiert wurde (alle Ports die gelesen werden sollen Output HI),
 dann liegen alle Ports hochohmig auf HI und knnen LO gezogen werden.
 Ist ein Port auf LO geschaltet, knnen sie ihn nicht nach HI ziehen,
 Das ist deshalb so, weil der PCF 8574 kein Datenrichtungsregister hat,
 und die Ports (auch beim Lesen des Eingangswertes) immer als Ausgang
 geschaltet sind.
 -----------------------------------------------------------------------------*/

byte PORTREAD(byte I2C_ADR, byte I2C_DATA)
{
       I2C_Start();
       I2C_Write(I2C_ADR);
       I2C_Write(I2C_DATA);
       I2C_Start();
       I2C_Write(I2C_ADR+1);
       I2C_DATA=(I2C_Read_NACK());
       I2C_Stop();
       return I2C_DATA;
}




void PORTWRITE(byte I2C_ADR, byte I2C_DATA)
{
       I2C_Start();
       I2C_Write(I2C_ADR);
       I2C_Write(I2C_DATA);
       I2C_Stop();
}

