/*** main.cc ***/
//------------------------------------------------
// This program requires these other modules and libraries:
// 1. LCD_Command.h
// 2. PCF8574_Interface.h
// 3. PCF8574_LCD.cc
// 4. Test1WriteChar.cc
// 5. Test2RunningText.cc
// 6. Test3ReadData.cc
// 7. Test4CreateShip.cc
// 8. Test5BackLight.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
// Before you test the program, please check the hardware interface
// between the PCF8574 port extender and the LC-Display.
// If you have different hardware, you must adjust the definitions
// in the PCF8574_Interface.h file.
//------------------------------------------------
 void main(void)
    {

    LCDInit(I2C_W_ADDR);
    Thread_Delay(100);

    Test5BackLight(I2C_W_ADDR);
    Thread_Delay(100);

    Test4CreateShip(I2C_W_ADDR);
    Thread_Delay(100);

    while(1)
        {
        Test1WriteChar(I2C_W_ADDR);
        Thread_Delay(100);

        Test2RunningText(I2C_W_ADDR);
        Thread_Delay(100);

        Test3ReadData(I2C_W_ADDR);
        Thread_Delay(100);

        Test4MoveShip(I2C_W_ADDR);
        Thread_Delay(100);
        }
    }
//------------------------------------------------