#!/usr/bin/perl -w
#*** asm_table_generator.pl ***#
#------------------------------------------------
 use strict;
 use warnings;
 use 5.012;
#------------------------------------------------
 say('please enter number of fft points: ');
 chomp(my $fft_n = <STDIN>);
 #my $fft_n = 1024;
#-----------------------------------------------
 sub Line { return ';' . '-' x 49; }
#------------------------------------------------
 sub InsertCosSin
    {
    my @strings = ();
    my $cos = 0;
    my $sin = 0;
    my $stp = $fft_n / 2;
    my $pi  = atan2(1, 1) * 4;

    for(my $point = 0; $point < $stp; $point++)
        {
        $sin = int(sin($point * $pi / $stp) * 32767);
        $cos = int(cos($point * $pi / $stp) * 32767);

        push(@strings, '    ldi    @0,    ' . sprintf("0x%2.2X", ($cos & 0x00FF)));
        push(@strings, '    ldi    @1,    ' . sprintf("0x%2.2X", ($cos & 0xFF00) >> 8));
        push(@strings, '    ldi    @2,    ' . sprintf("0x%2.2X", ($sin & 0x00FF)));
        push(@strings, '    ldi    @3,    ' . sprintf("0x%2.2X", ($sin & 0xFF00) >> 8));
        push(@strings, '    jmp    COS_SIN_LOOK_UP_TABLE_RETURN');
        push(@strings, '    nop');
        push(@strings, '    nop');
        push(@strings, '');

        }
    return @strings;
    }
#------------------------------------------------
 my @code = (
    ';*** MacroCosSin.inc ***;',
    Line(),
    ' .macro COS_SIN_LOOK_UP_TABLE',
    Line(),
    InsertCosSin(),
    Line(),
    ' .endmacro',
    Line()
    );

 open(my $code, '>', 'MacroCosSin.inc') or die("error in open: $!\n");
 say($code $_) foreach(@code);
 close($code);
 say('end of program');
#------------------------------------------------