;*** AsmLookUpTable.asm ***;
;-------------------------------------------------
 .include "MacroCosSin.inc"
;-------------------------------------------------
;*** Register Definitions ***;
 .def R_DATA_LOW   = R0
 .def R_DATA_HIGH  = R1
 .def R_SP_LOW     = R6
 .def R_SP_HIGH    = R7
 .def R_PARAM_LOW  = R10
 .def R_PARAM_HIGH = R11
 .def R_TEMP_LOW   = R22
 .def R_TEMP_HIGH  = R23
 .def R_COUNT_LOW  = R24
 .def R_COUNT_HIGH = R25
 .def R_XP_LOW     = R26
 .def R_XP_HIGH    = R27
 .def R_ZP_LOW     = R30
 .def R_ZP_HIGH    = R31
;-------------------------------------------------
 .ifdef TagTestMacroCosSin

 BEGIN_COS_SIN_LOOK_UP_TABLE:
    COS_SIN_LOOK_UP_TABLE R20, R21, R22, R23

 TestMacroCosSin:
    push  R20
    push  R21
    movw  R_ZP_LOW,      R_PARAM_LOW

    ld    R_COUNT_LOW,   Z+
    ld    R_COUNT_HIGH,  Z

    lsl   R_COUNT_LOW
    rol   R_COUNT_HIGH

    lsl   R_COUNT_LOW
    rol   R_COUNT_HIGH

    ldi   R_ZP_LOW,      low(BEGIN_COS_SIN_LOOK_UP_TABLE)
    ldi   R_ZP_HIGH,     high(BEGIN_COS_SIN_LOOK_UP_TABLE)

    add   R_ZP_LOW,      R_COUNT_LOW
    adc   R_ZP_HIGH,     R_COUNT_HIGH
    ijmp

 COS_SIN_LOOK_UP_TABLE_RETURN:

    movw  R_ZP_LOW,      R_SP_LOW
    adiw  R_ZP_LOW,      4
    movw  R_SP_LOW,      R_ZP_LOW

    st    Z+,            R20
    st    Z+,            R21
    st    Z+,            R22
    st    Z,             R23

    pop   R21
    pop   R20
    ret
 .endif
;-------------------------------------------------
