/*
    This subroutine calculates the Fourier transform of an array of N real
    numbers. N must be a power of 2.
    The array with the data points (f) is also used to store the result in.
    f(0)=F(0) and f(1)=F(N/2).
    The rest of the array (f(2)...f(N)) contains alternate real and imaginary
    parts for F(1) through F(N/2-1).
    F(N/2) is the value of the Fourier transform at the Nyquist frequency, i.e.
    at half the sample frequency.
    The power spectrum can be constructed as follows:
    - Horizontal (frequency): Sample_frequency/N*(0,1,2,...,N/2)
    - Vertical (power): 2/N*(f(0),sqrt(f(2)^2+f(3)^2),sqrt(f(4)^2+f(5)^2),...
                             ,sqrt(f(N-2)^2+f(N-1)^2),f(1))
*/
void fft(float f[], int N)
{
    int Nd2, b, i, j, tr_size, tr;
    float pi2, pi2n, cospi2n, sinpi2n, wb[2], temp1[2],temp2[2];
    pi2=2*PI;
    Nd2=N/2;
    j=0;
    for(i=1;i<Nd2;i++)
    {
        for(b=Nd2/2;j>=b;b=b/2)
            j=j-b;
        j=j+b;
        if(j>i)
        {
            temp1[0]=f[2*j];
            temp1[1]=f[2*j+1];
            f[2*j]=f[2*i];
            f[2*j+1]=f[2*i+1];
            f[2*i]=temp1[0];
            f[2*i+1]=temp1[1];
        }
    }
    for(tr_size=2;tr_size<=Nd2;tr_size=tr_size*2)
    {
        pi2n=pi2/tr_size;
        cospi2n=cos(pi2n);
        sinpi2n=sin(pi2n);
        wb[0]=1.0;
        wb[1]=0.0;
        for(b=0;b<tr_size/2;b++)
        {
            for(tr=0;tr<Nd2/tr_size;tr++)
            {
                i=tr*tr_size+b;
                j=i+tr_size/2;
                temp1[0]=f[2*i];
                temp1[1]=f[2*i+1];
                temp2[0]=f[2*j];
                temp2[1]=f[2*j+1];
                f[2*i]=temp1[0]+wb[0]*temp2[0]-wb[1]*temp2[1];
                f[2*i+1]=temp1[1]+wb[0]*temp2[1]+wb[1]*temp2[0];
                f[2*j]=temp1[0]-wb[0]*temp2[0]+wb[1]*temp2[1];
                f[2*j+1]=temp1[1]-wb[0]*temp2[1]-wb[1]*temp2[0];
            }
            temp1[0]=wb[0];
            temp1[1]=wb[1];
            wb[0]=cospi2n*temp1[0]-sinpi2n*temp1[1];
            wb[1]=cospi2n*temp1[1]+sinpi2n*temp1[0];
        }
    }
    pi2n = pi2/N;
    cospi2n=cos(pi2n);
    sinpi2n=sin(pi2n);
    wb[0]=1.0;
    wb[1]=0.0;
    for(b=1;b<N/4;b++)
    {
        temp1[0]=wb[0];
        temp1[1]=wb[1];
        wb[0]=cospi2n*temp1[0]-sinpi2n*temp1[1];
        wb[1]=cospi2n*temp1[1]+sinpi2n*temp1[0];
        temp1[0]=f[2*b];
        temp1[1]=f[2*b+1];
        temp2[0]=f[2*(N/2-b)];
        temp2[1]=f[2*(N/2-b)+1];
        f[2*b]=0.5*(temp1[0]+temp2[0]+wb[0]*(temp1[1]+temp2[1])+wb[1]*(temp1[0]-temp2[0]));
        f[2*b+1]=0.5*(temp1[1]-temp2[1]-wb[0]*(temp1[0]-temp2[0])+wb[1]*(temp1[1]+temp2[1]));
        f[2*(N/2-b)]=0.5*(temp1[0]+temp2[0]-wb[0]*(temp1[1]+temp2[1])-wb[1]*(temp1[0]-temp2[0]));
        f[2*(N/2-b)+1]=0.5*(-temp1[1]+temp2[1]-wb[0]*(temp1[0]-temp2[0])+wb[1]*(temp1[1]+temp2[1]));
    }
    temp1[0]=f[0];
    temp1[1]=f[1];
    f[0]=temp1[0]+temp1[1];
    f[1]=temp1[0]-temp1[1];
}
