/*** InputCaptureT3.cc ***/
//------------------------------------------------
 #define T0_SLOW_TICKS 4096l
//------------------------------------------------
 void ICT3Start $asm("TagICT3Start") (void);
 word ICT3Capture $asm("TagICT3Capture") (void);
//------------------------------------------------
 word gaw_ict3_capture[2] = {0, 0};
 long gal_t0_temp_slow_count[2] = {0, 0};
 long gl_t0_slow_count;
 byte gby_active_counter;
//------------------------------------------------
 void ICT3Init(void)
    {
    gby_active_counter = 0;
    gl_t0_slow_count = 0;
    Irq_SetVect(INT_TIM3CAPT, ICT3IrqCapture);
    Irq_SetVect(INT_TIM0COMP, ICT3T0IrqSlowCount);
    ICT3Start();
    Timer_T0Time(16, PS0_256);
    Thread_Delay(10);
    }
//------------------------------------------------
 void ICT3IrqCapture(void)
    {
    static word w_ict3_old;
    word w_ict3_new;
    w_ict3_new = ICT3Capture();
    gaw_ict3_capture[gby_active_counter] = w_ict3_new - w_ict3_old;
    w_ict3_old = w_ict3_new;
    gal_t0_temp_slow_count[gby_active_counter] = gl_t0_slow_count;
    gl_t0_slow_count = 0;
    Irq_GetCount(INT_TIM3CAPT);
    }
//------------------------------------------------
 void ICT3T0IrqSlowCount(void)
    {
    gl_t0_slow_count = gl_t0_slow_count + Irq_GetCount(INT_TIM0COMP);
    }
//------------------------------------------------
 long ICT3GetCapture(void)
    {
    byte by_index;
    long l_capture;
    long l_overflows;
    by_index = gby_active_counter;
    gby_active_counter = gby_active_counter ^ 0x01;
    l_overflows =
        (((gal_t0_temp_slow_count[by_index] + 8l) * T0_SLOW_TICKS)
        -
        gaw_ict3_capture[by_index])
         / 65536l;
    l_capture = (65536l * l_overflows) + gaw_ict3_capture[by_index];
    return l_capture;
    }
//------------------------------------------------
