
#define PortD 31                                                    // PortD=PD.7
#define PortC 18                                                    // PortC=PC.2
#define val 1                                                       // defines port as an output (1=output,0=input)

#thread 0, 0, 2000                                                  // main thread with task change every 20000 * 10ms = 200s
#thread 1, 128, 10000                                               // thread 1 with 128 byte RAM & task change every 10000 * 10ms = 100s
#thread 2, 128, 10000                                               // thread 2 mit 128 byte RAM & task change every 10000 * 10ms = 100s

int high;                                                           // initializes an integer with the name high
int low;                                                            // initializes an integer with the name low
int delval1;                                                        // initializes an integer with the name delval1
int delval2;                                                        // initializes an integer with the name delval2

high=1;                                                             // writes 1 into the memory with the name high (global variable)
low=0;                                                              // writes 0 into the memory with the name low  (global variable)
delval1=1000;                                                       // writes 1000 into the memory with the name delval(global variable)
delval2=1000;                                                       // writes 1000 into the memory with the name delval(global variable)



void function1(int hi, int lo, int del){                            // creates a function with 3 integer inputs
            hi=high;                                                // sets the local variable hi equal to the global variable high
            lo=low;                                                 // sets the local variable lo equal to the global variable low
            del=delval;                                             // sets the local variable del equal to the global variable delval

                while(1){
                    Port_DataDirBit(PortC,val);                     // defines Port 18 as an output
                    Port_Write(PortC,hi);                           // sets the output of Port 18 to high
                    Thread_Delay(del);                              // makes a delay of 1s (1000ms),output stays for 1s low
                    Port_Write(PortC,lo);                           // sets the output of Port 18 to low
                    Thread_Delay(del);                              // makes a delay of 1s (1000ms), output stays for 1s low
                }
}
void function2(int h, int l, int d){
            h=high;                                                 // sets the local variable h equal to the global variable high
            l=low;                                                  // sets the local variable l equal to the global variable low
            d=delval;                                               // sets the local variable d equal to the global variable delval
                while(1){
                    Port_DataDirBit(PortD,val);                     // defines Port 31 as an output
                    Port_Write(PortD,h);                            // sets the output of Port 31 to high
                    Thread_Delay(d);                                // makes a delay of 1s (1000ms),output stays for 1s low
                    Port_Write(PortD,l);                            // sets the output of Port 31 to low
                    Thread_Delay(d);                                // makes a delay of 1s (1000ms), output stays for 1s low
                }
}

void main (void){



            while(1){                                           // starts infinite while loop
              thread_start(1,function1);                        // starts function1 with parameters set as long as thread 1 may work
              thread_delay(1000);                               // delay of 1s between function 1 and function 2
              function2(high,low,delval2);                      // starts function2 with parameters set
              thread_delay(1000);                               // delay of 1s between function 2 and function 1
    }
}

