/*** XMLParams.cpp ***/
//-----------------------------------------------
 #include "StdAfx.h"
 #include "XMLParams.h"
//-----------------------------------------------
 CXMLParams::CXMLParams(void) :
    ms_xml_file_name("StoreAnalogValues-0.02.xml"),
    m_doc(gcnew XmlDocument)
    {
    }
//-----------------------------------------------
 CXMLParams::CXMLParams(String ^ s_xml_file_name) :
    ms_xml_file_name(s_xml_file_name),
    m_doc(gcnew XmlDocument)
    {
    if(!File::Exists("StoreAnalogValues-0.02.dtd"))
        {
        StreamWriter ^ sw = File::CreateText("StoreAnalogValues-0.02.dtd");
        try { sw->Write(DefaultDTD()); }
        catch(Exception ^ e) { MessageBox::Show(e->Message, "Can Not Create DTD"); }
        finally
            {
            if(sw)
                delete (IDisposable^)sw;
            }
        }
    try
        {
        m_doc->Load(ms_xml_file_name);
        }
    catch(FileNotFoundException ^ e)
        {
        MessageBox::Show(e->Message, "ERROR: Open XML-File");
        m_doc->LoadXml(DefaultDoc());
        }
    catch(XmlException ^ e)
        {
        MessageBox::Show(e->Message, "ERROR: Load XML-File");
        m_doc->LoadXml(DefaultDoc());
        }
    }
//-----------------------------------------------
 CXMLParams::~CXMLParams(void)
    {
    }
//-----------------------------------------------
 String ^ CXMLParams::LoadProperties(array<CADCParams ^> ^ ao_adc_params)
    {
    XmlAttributeCollection ^ xml_attr_coll = nullptr;
    for(Int32 i_channel = 0; i_channel < 8; i_channel++)
        {
        try
            {
            xml_attr_coll = this->m_doc->GetElementById("CHANNEL_" + i_channel.ToString())->Attributes;
            }
        catch(XmlException ^ e)
            {
            return e->Message;
            }
        if(xml_attr_coll)
            {
            ao_adc_params[i_channel]->Name =
                xml_attr_coll["name"] ? xml_attr_coll["name"]->Value : String::Format("Messwert_{0:D}", i_channel + 1);
            ao_adc_params[i_channel]->Max =
                xml_attr_coll["max"] ? Convert::ToSingle(xml_attr_coll["max"]->Value) : 5.0f;
            ao_adc_params[i_channel]->Min =
                xml_attr_coll["min"] ? Convert::ToSingle(xml_attr_coll["min"]->Value) : 0.0f;
            ao_adc_params[i_channel]->Interval =
                xml_attr_coll["interval"] ? Convert::ToUInt32(xml_attr_coll["interval"]->Value) : 10;
            ao_adc_params[i_channel]->Status =
                xml_attr_coll["status"] ? (("run" == xml_attr_coll["status"]->Value) ? true : false) : false;
            }
        else
            {
            ao_adc_params[i_channel]->Name = String::Format("Messwert_{0:D}", i_channel + 1);
            ao_adc_params[i_channel]->Max = 5.0f;
            ao_adc_params[i_channel]->Min = 0.0f;
            ao_adc_params[i_channel]->Interval = 10;
            ao_adc_params[i_channel]->Status = false;
            }
        }
    return "OK";
    }
//-----------------------------------------------
 void CXMLParams::SaveProperties(array<CADCParams ^> ^ ao_adc_params)
    {
    XmlAttributeCollection ^ xml_attr_coll = nullptr;
    for(Int32 i_channel = 0; i_channel < 8; i_channel++)
        {
        xml_attr_coll = this->m_doc->GetElementById("CHANNEL_" + i_channel.ToString())->Attributes;
        xml_attr_coll["name"]->Value = ao_adc_params[i_channel]->Name;
        xml_attr_coll["max"]->Value = ao_adc_params[i_channel]->Max.ToString();
        xml_attr_coll["min"]->Value = ao_adc_params[i_channel]->Min.ToString();
        xml_attr_coll["interval"]->Value = ao_adc_params[i_channel]->Interval.ToString();
        xml_attr_coll["status"]->Value = ao_adc_params[i_channel]->Status ? "run" : "stop";
        }
    this->m_doc->Save(this->ms_xml_file_name);
    }
//-----------------------------------------------
 String ^ CXMLParams::DefaultDTD(void)
    {
    return
        "<!ELEMENT store_analog_values (application, channel+)>\n" +
        "<!ELEMENT application EMPTY>\n" +
        "<!ATTLIST application\n" +
        "    id ID #REQUIRED\n" +
        "    port_name CDATA #REQUIRED\n" +
        "    baud_rate CDATA #REQUIRED\n" +
        "    data_base CDATA #REQUIRED\n" +
        "    >\n" +
        "<!ELEMENT channel EMPTY>\n" +
        "<!ATTLIST channel\n" +
        "    id ID #REQUIRED\n" +
        "    name CDATA #REQUIRED\n" +
        "    max CDATA #REQUIRED\n" +
        "    min CDATA #REQUIRED\n" +
        "    interval CDATA #REQUIRED\n" +
        "    status CDATA #REQUIRED\n" +
        "    >\n";
    }
//-----------------------------------------------
 String ^ CXMLParams::DefaultDoc(void)
    {
    UInt32 ui_default_interval = 1;
    StringBuilder ^ s_doc = gcnew StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    s_doc->Append("<!DOCTYPE store_analog_values SYSTEM \"StoreAnalogValues-0.02.dtd\">");
    s_doc->Append("<store_analog_values>");
    s_doc->Append(
        "<application " +
        "id=\"APPLICATION\" " +
        "baud_rate=\"57600\" " +
        "port_name=\"COM1\" " +
        "data_base=\"StoreAnalogValues-0.02.mdf\"/>");
    for(Int32 i_channel = 0; i_channel < 8; i_channel++)
        s_doc->Append(String::Format(
            "<channel id=\"CHANNEL_{0:D}\" name=\"Value_{1:D}\" max=\"5,0\" min=\"0,0\" status=\"stop\" interval=\"{2:D}\" />",
            i_channel,
            i_channel + 1,
            ui_default_interval << i_channel
            ));
    s_doc->Append("</store_analog_values>");
    return s_doc->ToString();
    }
//-----------------------------------------------
