/*** SqlDataBase.cpp ***/
//-----------------------------------------------
 #include "StdAfx.h"
 #include "SqlDataBase.h"
//-----------------------------------------------
 CSqlDataBase::CSqlDataBase(void)
    {
    }
//-----------------------------------------------
 String ^ CSqlDataBase::Open(String ^ s_db_file)
    {
    try
        {
        if(nullptr != msql_connection)
            if(System::Data::ConnectionState::Closed != msql_connection->State)
                msql_connection->Close();
        msql_connection = gcnew SqlConnection(
            "Data Source=.\\SQLEXPRESS;" +
            "AttachDbFilename=" + s_db_file + ";" +
            "Integrated Security=True;" +
            "Connect Timeout=10;" +
            "User Instance=True"
            );
        msql_connection->Open();
        msql_cmd = msql_connection->CreateCommand();
        }
    catch(SqlException ^ e)
        {
        msql_connection = nullptr;
        msql_cmd = nullptr;
        return e->Message;
        }
    return "OK";
    }
//-----------------------------------------------
 String ^ CSqlDataBase::Close(void)
    {
    try
        {
        if(nullptr != msql_connection)
            if(System::Data::ConnectionState::Closed != msql_connection->State)
                msql_connection->Close();
        }
    catch(SqlException ^ e)
        {
        return e->Message;
        }
    finally
        {
        msql_connection = nullptr;
        msql_cmd = nullptr;
        }
    return "OK";
    }
//-----------------------------------------------
 CSqlDataBase::~CSqlDataBase(void)
    {
    if(nullptr != msql_connection)
        if(System::Data::ConnectionState::Closed != msql_connection->State)
            msql_connection->Close();
    }
//-----------------------------------------------
 String ^ CSqlDataBase::InsertRow(String ^ s_channel, String ^ s_name, String ^ s_value, String ^ s_scaled)
    {
    if(nullptr == msql_connection)
        return ms_no_connection;
    try
        {
        msql_cmd->CommandText =
            "INSERT INTO ADC" + s_channel +
            " (time, name, value, scaled) VALUES (CAST('" +
            System::DateTime::Now.ToString("yyyy-MM-ddTHH:mm:ss.fff") +
            "' AS DateTime), '" + s_name + "', " + s_value + ", " + s_scaled->Replace(',', '.') + ")";
        if(System::Data::ConnectionState::Open == msql_connection->State)
            msql_cmd->ExecuteNonQuery();

        }
    catch(SqlException ^ e)
        {
        return e->Message;
        }
    return ms_ok;
    }
//-----------------------------------------------
 String ^ CSqlDataBase::ClearTable(Int32 i_channel)
    {
    if(nullptr == msql_connection)
        return ms_no_connection;
    try
        {
        msql_cmd->CommandText = "DELETE FROM ADC" + i_channel.ToString();
        if(System::Data::ConnectionState::Open == msql_connection->State)
            msql_cmd->ExecuteNonQuery();
        }
    catch(SqlException ^ e)
        {
        return e->Message;
        }
    return ms_ok;
    }
//-----------------------------------------------
 Int32 CSqlDataBase::GetRowsCount(Int32 i_channel)
    {
    if(nullptr == msql_connection)
        return 0;
    Int32 i_count = 0;
    try
        {
        msql_cmd->CommandText = "SELECT COUNT(*) FROM ADC" + i_channel.ToString();
        if(System::Data::ConnectionState::Open == msql_connection->State)
            i_count = (Int32)msql_cmd->ExecuteScalar();
        }
    catch(SqlException ^ /*e*/)
        {
        return 0;
        }
    return i_count;
    }
//-----------------------------------------------
