/*** Form1.h ***/
//-----------------------------------------------
 #pragma once
 #include "SerialPortCmd.h"
 #include "SetADCParams.h"
 #include "ADCParams.h"
 #include "XMLParams.h"
 #include "SqlDataBase.h"
//-----------------------------------------------
 namespace StoreAnalogValues002 {
//-----------------------------------------------
 using namespace System;
 using namespace System::ComponentModel;
 using namespace System::Collections;
 using namespace System::Windows::Forms;
 using namespace System::Data;
 using namespace System::Drawing;
 using namespace System::IO;
 using namespace System::IO::Ports;
 using namespace System::Data::SqlClient;
//-----------------------------------------------
/// <summary>
/// Zusammenfassung fr Form1
///
/// Warnung: Wenn Sie den Namen dieser Klasse ndern, mssen Sie auch
///          die Ressourcendateiname-Eigenschaft fr das Tool zur Kompilierung verwalteter Ressourcen ndern,
///          das allen RESX-Dateien zugewiesen ist, von denen diese Klasse abhngt.
///          Anderenfalls knnen die Designer nicht korrekt mit den lokalisierten Ressourcen
///          arbeiten, die diesem Formular zugewiesen sind.
/// </summary>
 public ref class Form1 : public System::Windows::Forms::Form
    {
//-----------------------------------------------
 public: Form1(String ^ s_xml_file_name, Boolean bo_auto_start) :
    ms_status_closed("Status: closed"),
    ms_status_open("Status: open"),
    mbo_auto_start(bo_auto_start),
    mby_port_cmd(gcnew array<unsigned char>(1)),
    msql_data_base(gcnew CSqlDataBase()),
    mao_adc_params(gcnew array<CADCParams ^>(8)),
    mo_xml_params(gcnew CXMLParams(s_xml_file_name)),
    mauc_cmd(gcnew array<unsigned char>(8))
    {
    String ^ s_result = nullptr;
    InitializeComponent();
//
//TODO: Konstruktorcode hier hinzufgen.
//
    comboBox_com_port->Items->Add(mo_xml_params->PortName);
    comboBox_com_port->SelectedIndex = 0;
    comboBox_baud_rate->Items->Add(mo_xml_params->BaudRate.ToString());
    comboBox_baud_rate->SelectedIndex = 0;
    for(Int32 i_channel = 0; i_channel < 8; i_channel++)
        mao_adc_params[i_channel] = gcnew CADCParams(i_channel);
    s_result = mo_xml_params->LoadProperties(mao_adc_params);
    if("OK" != s_result)
        textBox_messages->AppendText(s_result + "\n");

    String ^ s_start = "Start";
    String ^ s_stop = "Stop";
    button_adc0_start_stop->Text = mao_adc_params[0]->Status ? s_stop : s_start;
    button_adc1_start_stop->Text = mao_adc_params[1]->Status ? s_stop : s_start;
    button_adc2_start_stop->Text = mao_adc_params[2]->Status ? s_stop : s_start;
    button_adc3_start_stop->Text = mao_adc_params[3]->Status ? s_stop : s_start;
    button_adc4_start_stop->Text = mao_adc_params[4]->Status ? s_stop : s_start;
    button_adc5_start_stop->Text = mao_adc_params[5]->Status ? s_stop : s_start;
    button_adc6_start_stop->Text = mao_adc_params[6]->Status ? s_stop : s_start;
    button_adc7_start_stop->Text = mao_adc_params[7]->Status ? s_stop : s_start;

    for(Int32 i_channel = 0; i_channel < 8; i_channel++)
        SetGroupBoxText(i_channel);

    mauc_cmd[0] = CMD_GET_ADC0;
    mauc_cmd[1] = CMD_GET_ADC1;
    mauc_cmd[2] = CMD_GET_ADC2;
    mauc_cmd[3] = CMD_GET_ADC3;
    mauc_cmd[4] = CMD_GET_ADC4;
    mauc_cmd[5] = CMD_GET_ADC5;
    mauc_cmd[6] = CMD_GET_ADC6;
    mauc_cmd[7] = CMD_GET_ADC7;
    serialPort1->Parity = Parity::None;
    serialPort1->DataBits = 8;
    serialPort1->StopBits = StopBits::One;
    if(mbo_auto_start)
        {
        button_open_com_port_Click(button_open_com_port, nullptr);
        button_open_data_base_Click(button_open_data_base, nullptr);
        }
    }
//-----------------------------------------------
/// <summary>
/// Verwendete Ressourcen bereinigen.
/// </summary>
 protected: ~Form1()
    {
    timer1->Stop();
    if(serialPort1->IsOpen)
        serialPort1->Close();
    if(msql_data_base->IsOpen)
        msql_data_base->Close();
    if (components)
        delete components;
    }
//-----------------------------------------------
/// <summary>
/// Erforderliche Designervariable.
/// </summary>
    private: initonly String ^ ms_status_closed;
    private: initonly String ^ ms_status_open;
    private: Boolean mbo_auto_start;
    private: array<unsigned char> ^ mby_port_cmd;
    private: CSqlDataBase ^ msql_data_base;
    private: array<CADCParams ^> ^ mao_adc_params;
    private: CXMLParams ^ mo_xml_params;
    private: array<unsigned char> ^ mauc_cmd;
    private: System::IO::Ports::SerialPort ^ serialPort1;
    private: System::Windows::Forms::Timer ^ timer1;
    private: System::Windows::Forms::Label ^ label_com_port;
    private: System::Windows::Forms::ComboBox ^ comboBox_com_port;
    private: System::Windows::Forms::Label ^ label_baud_rate;
    private: System::Windows::Forms::ComboBox ^ comboBox_baud_rate;
    private: System::Windows::Forms::Label ^ label_status_com_port;
    private: System::Windows::Forms::Button ^ button_open_com_port;
    private: System::Windows::Forms::GroupBox ^ groupBox_messages;
    private: System::Windows::Forms::TextBox ^ textBox_messages;
    private: System::Windows::Forms::Label ^ label_status_data_base;
    private: System::Windows::Forms::Button ^ button_open_data_base;
    private: System::Windows::Forms::Button ^ button_clear_messages;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc0;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc1;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc2;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc3;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc4;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc5;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc6;
    private: System::Windows::Forms::GroupBox ^ groupBox_adc7;
    private: System::Windows::Forms::Label ^ label_adc0_count;
    private: System::Windows::Forms::Label ^ label_adc1_count;
    private: System::Windows::Forms::Label ^ label_adc2_count;
    private: System::Windows::Forms::Label ^ label_adc3_count;
    private: System::Windows::Forms::Label ^ label_adc4_count;
    private: System::Windows::Forms::Label ^ label_adc5_count;
    private: System::Windows::Forms::Label ^ label_adc6_count;
    private: System::Windows::Forms::Label ^ label_adc7_count;
    private: System::Windows::Forms::Button ^ button_adc0_settings;
    private: System::Windows::Forms::Button ^ button_adc1_settings;
    private: System::Windows::Forms::Button ^ button_adc2_settings;
    private: System::Windows::Forms::Button ^ button_adc3_settings;
    private: System::Windows::Forms::Button ^ button_adc4_settings;
    private: System::Windows::Forms::Button ^ button_adc5_settings;
    private: System::Windows::Forms::Button ^ button_adc6_settings;
    private: System::Windows::Forms::Button ^ button_adc7_settings;
    private: System::Windows::Forms::Button ^ button_adc0_start_stop;
    private: System::Windows::Forms::Button ^ button_adc1_start_stop;
    private: System::Windows::Forms::Button ^ button_adc2_start_stop;
    private: System::Windows::Forms::Button ^ button_adc3_start_stop;
    private: System::Windows::Forms::Button ^ button_adc4_start_stop;
    private: System::Windows::Forms::Button ^ button_adc5_start_stop;
    private: System::Windows::Forms::Button ^ button_adc6_start_stop;
    private: System::Windows::Forms::Button ^ button_adc7_start_stop;
    private: System::Windows::Forms::Button ^ button_app_exit;
    private: System::Windows::Forms::Label ^ label_scaled_adc0;
    private: System::Windows::Forms::Label ^ label_scaled_adc1;
    private: System::Windows::Forms::Label ^ label_scaled_adc2;
    private: System::Windows::Forms::Label ^ label_scaled_adc3;
    private: System::Windows::Forms::Label ^ label_scaled_adc4;
    private: System::Windows::Forms::Label ^ label_scaled_adc5;
    private: System::Windows::Forms::Label ^ label_scaled_adc6;
    private: System::Windows::Forms::Label ^ label_scaled_adc7;

    private: System::ComponentModel::IContainer^  components;
#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
            this->components = (gcnew System::ComponentModel::Container());
            this->label_com_port = (gcnew System::Windows::Forms::Label());
            this->comboBox_com_port = (gcnew System::Windows::Forms::ComboBox());
            this->label_baud_rate = (gcnew System::Windows::Forms::Label());
            this->comboBox_baud_rate = (gcnew System::Windows::Forms::ComboBox());
            this->label_status_com_port = (gcnew System::Windows::Forms::Label());
            this->button_open_com_port = (gcnew System::Windows::Forms::Button());
            this->groupBox_messages = (gcnew System::Windows::Forms::GroupBox());
            this->button_clear_messages = (gcnew System::Windows::Forms::Button());
            this->textBox_messages = (gcnew System::Windows::Forms::TextBox());
            this->serialPort1 = (gcnew System::IO::Ports::SerialPort(this->components));
            this->timer1 = (gcnew System::Windows::Forms::Timer(this->components));
            this->label_status_data_base = (gcnew System::Windows::Forms::Label());
            this->button_open_data_base = (gcnew System::Windows::Forms::Button());
            this->groupBox_adc0 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc0_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc0_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc0_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc1 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc1_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc1_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc1_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc2 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc2_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc2_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc2_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc3 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc3_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc3_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc3_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc4 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc4_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc4_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc4_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc5 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc5_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc5_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc5_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc6 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc6_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc6_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc6_count = (gcnew System::Windows::Forms::Label());
            this->groupBox_adc7 = (gcnew System::Windows::Forms::GroupBox());
            this->button_adc7_start_stop = (gcnew System::Windows::Forms::Button());
            this->button_adc7_settings = (gcnew System::Windows::Forms::Button());
            this->label_adc7_count = (gcnew System::Windows::Forms::Label());
            this->button_app_exit = (gcnew System::Windows::Forms::Button());
            this->label_scaled_adc0 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc1 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc2 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc3 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc4 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc5 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc6 = (gcnew System::Windows::Forms::Label());
            this->label_scaled_adc7 = (gcnew System::Windows::Forms::Label());
            this->groupBox_messages->SuspendLayout();
            this->groupBox_adc0->SuspendLayout();
            this->groupBox_adc1->SuspendLayout();
            this->groupBox_adc2->SuspendLayout();
            this->groupBox_adc3->SuspendLayout();
            this->groupBox_adc4->SuspendLayout();
            this->groupBox_adc5->SuspendLayout();
            this->groupBox_adc6->SuspendLayout();
            this->groupBox_adc7->SuspendLayout();
            this->SuspendLayout();
            // 
            // label_com_port
            // 
            this->label_com_port->AutoSize = true;
            this->label_com_port->Location = System::Drawing::Point(9, 16);
            this->label_com_port->Name = L"label_com_port";
            this->label_com_port->Size = System::Drawing::Size(75, 17);
            this->label_com_port->TabIndex = 0;
            this->label_com_port->Text = L"COMx Port";
            // 
            // comboBox_com_port
            // 
            this->comboBox_com_port->FormattingEnabled = true;
            this->comboBox_com_port->Location = System::Drawing::Point(126, 9);
            this->comboBox_com_port->Name = L"comboBox_com_port";
            this->comboBox_com_port->Size = System::Drawing::Size(121, 24);
            this->comboBox_com_port->TabIndex = 1;
            this->comboBox_com_port->SelectedIndexChanged += gcnew System::EventHandler(this, &Form1::comboBox_com_port_SelectedIndexChanged);
            this->comboBox_com_port->DropDown += gcnew System::EventHandler(this, &Form1::comboBox_com_port_DropDown);
            // 
            // label_baud_rate
            // 
            this->label_baud_rate->AutoSize = true;
            this->label_baud_rate->Location = System::Drawing::Point(9, 55);
            this->label_baud_rate->Name = L"label_baud_rate";
            this->label_baud_rate->Size = System::Drawing::Size(75, 17);
            this->label_baud_rate->TabIndex = 2;
            this->label_baud_rate->Text = L"Baud Rate";
            // 
            // comboBox_baud_rate
            // 
            this->comboBox_baud_rate->FormattingEnabled = true;
            this->comboBox_baud_rate->Location = System::Drawing::Point(126, 48);
            this->comboBox_baud_rate->Name = L"comboBox_baud_rate";
            this->comboBox_baud_rate->Size = System::Drawing::Size(121, 24);
            this->comboBox_baud_rate->TabIndex = 3;
            this->comboBox_baud_rate->SelectedIndexChanged += gcnew System::EventHandler(this, &Form1::comboBox_baud_rate_SelectedIndexChanged);
            this->comboBox_baud_rate->DropDown += gcnew System::EventHandler(this, &Form1::comboBox_baud_rate_DropDown);
            // 
            // label_status_com_port
            // 
            this->label_status_com_port->AutoSize = true;
            this->label_status_com_port->Location = System::Drawing::Point(9, 96);
            this->label_status_com_port->Name = L"label_status_com_port";
            this->label_status_com_port->Size = System::Drawing::Size(97, 17);
            this->label_status_com_port->TabIndex = 4;
            this->label_status_com_port->Text = L"Status: closed";
            // 
            // button_open_com_port
            // 
            this->button_open_com_port->Location = System::Drawing::Point(126, 87);
            this->button_open_com_port->Name = L"button_open_com_port";
            this->button_open_com_port->Size = System::Drawing::Size(145, 35);
            this->button_open_com_port->TabIndex = 5;
            this->button_open_com_port->Text = L"Open COMx Port";
            this->button_open_com_port->UseVisualStyleBackColor = true;
            this->button_open_com_port->Click += gcnew System::EventHandler(this, &Form1::button_open_com_port_Click);
            // 
            // groupBox_messages
            // 
            this->groupBox_messages->Controls->Add(this->button_clear_messages);
            this->groupBox_messages->Controls->Add(this->textBox_messages);
            this->groupBox_messages->Location = System::Drawing::Point(278, 2);
            this->groupBox_messages->Name = L"groupBox_messages";
            this->groupBox_messages->Size = System::Drawing::Size(518, 235);
            this->groupBox_messages->TabIndex = 6;
            this->groupBox_messages->TabStop = false;
            this->groupBox_messages->Text = L"Messages";
            // 
            // button_clear_messages
            // 
            this->button_clear_messages->Location = System::Drawing::Point(186, 185);
            this->button_clear_messages->Name = L"button_clear_messages";
            this->button_clear_messages->Size = System::Drawing::Size(145, 35);
            this->button_clear_messages->TabIndex = 1;
            this->button_clear_messages->Text = L"Clear Messages";
            this->button_clear_messages->UseVisualStyleBackColor = true;
            this->button_clear_messages->Click += gcnew System::EventHandler(this, &Form1::button_clear_messages_Click);
            // 
            // textBox_messages
            // 
            this->textBox_messages->Location = System::Drawing::Point(18, 21);
            this->textBox_messages->Multiline = true;
            this->textBox_messages->Name = L"textBox_messages";
            this->textBox_messages->ScrollBars = System::Windows::Forms::ScrollBars::Both;
            this->textBox_messages->Size = System::Drawing::Size(485, 153);
            this->textBox_messages->TabIndex = 0;
            this->textBox_messages->WordWrap = false;
            // 
            // serialPort1
            // 
            this->serialPort1->BaudRate = 57600;
            this->serialPort1->ReadTimeout = 200;
            this->serialPort1->WriteTimeout = 200;
            // 
            // timer1
            // 
            this->timer1->Interval = 1000;
            this->timer1->Tick += gcnew System::EventHandler(this, &Form1::timer1_Tick);
            // 
            // label_status_data_base
            // 
            this->label_status_data_base->AutoSize = true;
            this->label_status_data_base->Location = System::Drawing::Point(9, 146);
            this->label_status_data_base->Name = L"label_status_data_base";
            this->label_status_data_base->Size = System::Drawing::Size(97, 17);
            this->label_status_data_base->TabIndex = 7;
            this->label_status_data_base->Text = L"Status: closed";
            // 
            // button_open_data_base
            // 
            this->button_open_data_base->Location = System::Drawing::Point(126, 137);
            this->button_open_data_base->Name = L"button_open_data_base";
            this->button_open_data_base->Size = System::Drawing::Size(145, 35);
            this->button_open_data_base->TabIndex = 8;
            this->button_open_data_base->Text = L"Open Data Base";
            this->button_open_data_base->UseVisualStyleBackColor = true;
            this->button_open_data_base->Click += gcnew System::EventHandler(this, &Form1::button_open_data_base_Click);
            // 
            // groupBox_adc0
            // 
            this->groupBox_adc0->Controls->Add(this->label_scaled_adc0);
            this->groupBox_adc0->Controls->Add(this->button_adc0_start_stop);
            this->groupBox_adc0->Controls->Add(this->button_adc0_settings);
            this->groupBox_adc0->Controls->Add(this->label_adc0_count);
            this->groupBox_adc0->Location = System::Drawing::Point(12, 240);
            this->groupBox_adc0->Name = L"groupBox_adc0";
            this->groupBox_adc0->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc0->TabIndex = 9;
            this->groupBox_adc0->TabStop = false;
            this->groupBox_adc0->Text = L"ADC0";
            // 
            // button_adc0_start_stop
            // 
            this->button_adc0_start_stop->Enabled = false;
            this->button_adc0_start_stop->Location = System::Drawing::Point(10, 149);
            this->button_adc0_start_stop->Name = L"button_adc0_start_stop";
            this->button_adc0_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc0_start_stop->TabIndex = 2;
            this->button_adc0_start_stop->Text = L"Start";
            this->button_adc0_start_stop->UseVisualStyleBackColor = true;
            this->button_adc0_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc0_start_stop_Click);
            // 
            // button_adc0_settings
            // 
            this->button_adc0_settings->Location = System::Drawing::Point(10, 105);
            this->button_adc0_settings->Name = L"button_adc0_settings";
            this->button_adc0_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc0_settings->TabIndex = 1;
            this->button_adc0_settings->Text = L"Settings";
            this->button_adc0_settings->UseVisualStyleBackColor = true;
            this->button_adc0_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc0_settings_Click);
            // 
            // label_adc0_count
            // 
            this->label_adc0_count->AutoSize = true;
            this->label_adc0_count->Location = System::Drawing::Point(10, 79);
            this->label_adc0_count->Name = L"label_adc0_count";
            this->label_adc0_count->Size = System::Drawing::Size(16, 17);
            this->label_adc0_count->TabIndex = 0;
            this->label_adc0_count->Text = L"\?";
            // 
            // groupBox_adc1
            // 
            this->groupBox_adc1->Controls->Add(this->label_scaled_adc1);
            this->groupBox_adc1->Controls->Add(this->button_adc1_start_stop);
            this->groupBox_adc1->Controls->Add(this->button_adc1_settings);
            this->groupBox_adc1->Controls->Add(this->label_adc1_count);
            this->groupBox_adc1->Location = System::Drawing::Point(109, 240);
            this->groupBox_adc1->Name = L"groupBox_adc1";
            this->groupBox_adc1->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc1->TabIndex = 10;
            this->groupBox_adc1->TabStop = false;
            this->groupBox_adc1->Text = L"ADC1";
            // 
            // button_adc1_start_stop
            // 
            this->button_adc1_start_stop->Enabled = false;
            this->button_adc1_start_stop->Location = System::Drawing::Point(9, 149);
            this->button_adc1_start_stop->Name = L"button_adc1_start_stop";
            this->button_adc1_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc1_start_stop->TabIndex = 2;
            this->button_adc1_start_stop->Text = L"Start";
            this->button_adc1_start_stop->UseVisualStyleBackColor = true;
            this->button_adc1_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc1_start_stop_Click);
            // 
            // button_adc1_settings
            // 
            this->button_adc1_settings->Location = System::Drawing::Point(9, 108);
            this->button_adc1_settings->Name = L"button_adc1_settings";
            this->button_adc1_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc1_settings->TabIndex = 1;
            this->button_adc1_settings->Text = L"Settings";
            this->button_adc1_settings->UseVisualStyleBackColor = true;
            this->button_adc1_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc1_settings_Click);
            // 
            // label_adc1_count
            // 
            this->label_adc1_count->AutoSize = true;
            this->label_adc1_count->Location = System::Drawing::Point(9, 82);
            this->label_adc1_count->Name = L"label_adc1_count";
            this->label_adc1_count->Size = System::Drawing::Size(16, 17);
            this->label_adc1_count->TabIndex = 0;
            this->label_adc1_count->Text = L"\?";
            // 
            // groupBox_adc2
            // 
            this->groupBox_adc2->Controls->Add(this->label_scaled_adc2);
            this->groupBox_adc2->Controls->Add(this->button_adc2_start_stop);
            this->groupBox_adc2->Controls->Add(this->button_adc2_settings);
            this->groupBox_adc2->Controls->Add(this->label_adc2_count);
            this->groupBox_adc2->Location = System::Drawing::Point(207, 240);
            this->groupBox_adc2->Name = L"groupBox_adc2";
            this->groupBox_adc2->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc2->TabIndex = 11;
            this->groupBox_adc2->TabStop = false;
            this->groupBox_adc2->Text = L"ADC2";
            // 
            // button_adc2_start_stop
            // 
            this->button_adc2_start_stop->Enabled = false;
            this->button_adc2_start_stop->Location = System::Drawing::Point(9, 149);
            this->button_adc2_start_stop->Name = L"button_adc2_start_stop";
            this->button_adc2_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc2_start_stop->TabIndex = 2;
            this->button_adc2_start_stop->Text = L"Start";
            this->button_adc2_start_stop->UseVisualStyleBackColor = true;
            this->button_adc2_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc2_start_stop_Click);
            // 
            // button_adc2_settings
            // 
            this->button_adc2_settings->Location = System::Drawing::Point(9, 108);
            this->button_adc2_settings->Name = L"button_adc2_settings";
            this->button_adc2_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc2_settings->TabIndex = 1;
            this->button_adc2_settings->Text = L"Settings";
            this->button_adc2_settings->UseVisualStyleBackColor = true;
            this->button_adc2_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc2_settings_Click);
            // 
            // label_adc2_count
            // 
            this->label_adc2_count->AutoSize = true;
            this->label_adc2_count->Location = System::Drawing::Point(9, 82);
            this->label_adc2_count->Name = L"label_adc2_count";
            this->label_adc2_count->Size = System::Drawing::Size(16, 17);
            this->label_adc2_count->TabIndex = 0;
            this->label_adc2_count->Text = L"\?";
            // 
            // groupBox_adc3
            // 
            this->groupBox_adc3->Controls->Add(this->label_scaled_adc3);
            this->groupBox_adc3->Controls->Add(this->button_adc3_start_stop);
            this->groupBox_adc3->Controls->Add(this->button_adc3_settings);
            this->groupBox_adc3->Controls->Add(this->label_adc3_count);
            this->groupBox_adc3->Location = System::Drawing::Point(305, 240);
            this->groupBox_adc3->Name = L"groupBox_adc3";
            this->groupBox_adc3->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc3->TabIndex = 12;
            this->groupBox_adc3->TabStop = false;
            this->groupBox_adc3->Text = L"ADC3";
            // 
            // button_adc3_start_stop
            // 
            this->button_adc3_start_stop->Enabled = false;
            this->button_adc3_start_stop->Location = System::Drawing::Point(9, 149);
            this->button_adc3_start_stop->Name = L"button_adc3_start_stop";
            this->button_adc3_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc3_start_stop->TabIndex = 2;
            this->button_adc3_start_stop->Text = L"Start";
            this->button_adc3_start_stop->UseVisualStyleBackColor = true;
            this->button_adc3_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc3_start_stop_Click);
            // 
            // button_adc3_settings
            // 
            this->button_adc3_settings->Location = System::Drawing::Point(9, 108);
            this->button_adc3_settings->Name = L"button_adc3_settings";
            this->button_adc3_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc3_settings->TabIndex = 1;
            this->button_adc3_settings->Text = L"Settings";
            this->button_adc3_settings->UseVisualStyleBackColor = true;
            this->button_adc3_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc3_settings_Click);
            // 
            // label_adc3_count
            // 
            this->label_adc3_count->AutoSize = true;
            this->label_adc3_count->Location = System::Drawing::Point(9, 82);
            this->label_adc3_count->Name = L"label_adc3_count";
            this->label_adc3_count->Size = System::Drawing::Size(16, 17);
            this->label_adc3_count->TabIndex = 0;
            this->label_adc3_count->Text = L"\?";
            // 
            // groupBox_adc4
            // 
            this->groupBox_adc4->Controls->Add(this->label_scaled_adc4);
            this->groupBox_adc4->Controls->Add(this->button_adc4_start_stop);
            this->groupBox_adc4->Controls->Add(this->button_adc4_settings);
            this->groupBox_adc4->Controls->Add(this->label_adc4_count);
            this->groupBox_adc4->Location = System::Drawing::Point(403, 240);
            this->groupBox_adc4->Name = L"groupBox_adc4";
            this->groupBox_adc4->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc4->TabIndex = 13;
            this->groupBox_adc4->TabStop = false;
            this->groupBox_adc4->Text = L"ADC4";
            // 
            // button_adc4_start_stop
            // 
            this->button_adc4_start_stop->Enabled = false;
            this->button_adc4_start_stop->Location = System::Drawing::Point(9, 149);
            this->button_adc4_start_stop->Name = L"button_adc4_start_stop";
            this->button_adc4_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc4_start_stop->TabIndex = 2;
            this->button_adc4_start_stop->Text = L"Start";
            this->button_adc4_start_stop->UseVisualStyleBackColor = true;
            this->button_adc4_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc4_start_stop_Click);
            // 
            // button_adc4_settings
            // 
            this->button_adc4_settings->Location = System::Drawing::Point(9, 108);
            this->button_adc4_settings->Name = L"button_adc4_settings";
            this->button_adc4_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc4_settings->TabIndex = 1;
            this->button_adc4_settings->Text = L"Settings";
            this->button_adc4_settings->UseVisualStyleBackColor = true;
            this->button_adc4_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc4_settings_Click);
            // 
            // label_adc4_count
            // 
            this->label_adc4_count->AutoSize = true;
            this->label_adc4_count->Location = System::Drawing::Point(9, 82);
            this->label_adc4_count->Name = L"label_adc4_count";
            this->label_adc4_count->Size = System::Drawing::Size(16, 17);
            this->label_adc4_count->TabIndex = 0;
            this->label_adc4_count->Text = L"\?";
            // 
            // groupBox_adc5
            // 
            this->groupBox_adc5->Controls->Add(this->label_scaled_adc5);
            this->groupBox_adc5->Controls->Add(this->button_adc5_start_stop);
            this->groupBox_adc5->Controls->Add(this->button_adc5_settings);
            this->groupBox_adc5->Controls->Add(this->label_adc5_count);
            this->groupBox_adc5->Location = System::Drawing::Point(501, 240);
            this->groupBox_adc5->Name = L"groupBox_adc5";
            this->groupBox_adc5->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc5->TabIndex = 14;
            this->groupBox_adc5->TabStop = false;
            this->groupBox_adc5->Text = L"ADC5";
            // 
            // button_adc5_start_stop
            // 
            this->button_adc5_start_stop->Enabled = false;
            this->button_adc5_start_stop->Location = System::Drawing::Point(9, 149);
            this->button_adc5_start_stop->Name = L"button_adc5_start_stop";
            this->button_adc5_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc5_start_stop->TabIndex = 2;
            this->button_adc5_start_stop->Text = L"Start";
            this->button_adc5_start_stop->UseVisualStyleBackColor = true;
            this->button_adc5_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc5_start_stop_Click);
            // 
            // button_adc5_settings
            // 
            this->button_adc5_settings->Location = System::Drawing::Point(9, 108);
            this->button_adc5_settings->Name = L"button_adc5_settings";
            this->button_adc5_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc5_settings->TabIndex = 1;
            this->button_adc5_settings->Text = L"Settings";
            this->button_adc5_settings->UseVisualStyleBackColor = true;
            this->button_adc5_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc5_settings_Click);
            // 
            // label_adc5_count
            // 
            this->label_adc5_count->AutoSize = true;
            this->label_adc5_count->Location = System::Drawing::Point(9, 82);
            this->label_adc5_count->Name = L"label_adc5_count";
            this->label_adc5_count->Size = System::Drawing::Size(16, 17);
            this->label_adc5_count->TabIndex = 0;
            this->label_adc5_count->Text = L"\?";
            // 
            // groupBox_adc6
            // 
            this->groupBox_adc6->Controls->Add(this->label_scaled_adc6);
            this->groupBox_adc6->Controls->Add(this->button_adc6_start_stop);
            this->groupBox_adc6->Controls->Add(this->button_adc6_settings);
            this->groupBox_adc6->Controls->Add(this->label_adc6_count);
            this->groupBox_adc6->Location = System::Drawing::Point(599, 240);
            this->groupBox_adc6->Name = L"groupBox_adc6";
            this->groupBox_adc6->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc6->TabIndex = 15;
            this->groupBox_adc6->TabStop = false;
            this->groupBox_adc6->Text = L"ADC6";
            // 
            // button_adc6_start_stop
            // 
            this->button_adc6_start_stop->Enabled = false;
            this->button_adc6_start_stop->Location = System::Drawing::Point(10, 149);
            this->button_adc6_start_stop->Name = L"button_adc6_start_stop";
            this->button_adc6_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc6_start_stop->TabIndex = 2;
            this->button_adc6_start_stop->Text = L"Start";
            this->button_adc6_start_stop->UseVisualStyleBackColor = true;
            this->button_adc6_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc6_start_stop_Click);
            // 
            // button_adc6_settings
            // 
            this->button_adc6_settings->Location = System::Drawing::Point(10, 108);
            this->button_adc6_settings->Name = L"button_adc6_settings";
            this->button_adc6_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc6_settings->TabIndex = 1;
            this->button_adc6_settings->Text = L"Settings";
            this->button_adc6_settings->UseVisualStyleBackColor = true;
            this->button_adc6_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc6_settings_Click);
            // 
            // label_adc6_count
            // 
            this->label_adc6_count->AutoSize = true;
            this->label_adc6_count->Location = System::Drawing::Point(10, 82);
            this->label_adc6_count->Name = L"label_adc6_count";
            this->label_adc6_count->Size = System::Drawing::Size(16, 17);
            this->label_adc6_count->TabIndex = 0;
            this->label_adc6_count->Text = L"\?";
            // 
            // groupBox_adc7
            // 
            this->groupBox_adc7->Controls->Add(this->label_scaled_adc7);
            this->groupBox_adc7->Controls->Add(this->button_adc7_start_stop);
            this->groupBox_adc7->Controls->Add(this->button_adc7_settings);
            this->groupBox_adc7->Controls->Add(this->label_adc7_count);
            this->groupBox_adc7->Location = System::Drawing::Point(697, 240);
            this->groupBox_adc7->Name = L"groupBox_adc7";
            this->groupBox_adc7->Size = System::Drawing::Size(94, 194);
            this->groupBox_adc7->TabIndex = 16;
            this->groupBox_adc7->TabStop = false;
            this->groupBox_adc7->Text = L"ADC7";
            // 
            // button_adc7_start_stop
            // 
            this->button_adc7_start_stop->Enabled = false;
            this->button_adc7_start_stop->Location = System::Drawing::Point(9, 149);
            this->button_adc7_start_stop->Name = L"button_adc7_start_stop";
            this->button_adc7_start_stop->Size = System::Drawing::Size(75, 35);
            this->button_adc7_start_stop->TabIndex = 2;
            this->button_adc7_start_stop->Text = L"Start";
            this->button_adc7_start_stop->UseVisualStyleBackColor = true;
            this->button_adc7_start_stop->Click += gcnew System::EventHandler(this, &Form1::button_adc7_start_stop_Click);
            // 
            // button_adc7_settings
            // 
            this->button_adc7_settings->Location = System::Drawing::Point(9, 108);
            this->button_adc7_settings->Name = L"button_adc7_settings";
            this->button_adc7_settings->Size = System::Drawing::Size(75, 35);
            this->button_adc7_settings->TabIndex = 1;
            this->button_adc7_settings->Text = L"Settings";
            this->button_adc7_settings->UseVisualStyleBackColor = true;
            this->button_adc7_settings->Click += gcnew System::EventHandler(this, &Form1::button_adc7_settings_Click);
            // 
            // label_adc7_count
            // 
            this->label_adc7_count->AutoSize = true;
            this->label_adc7_count->Location = System::Drawing::Point(9, 82);
            this->label_adc7_count->Name = L"label_adc7_count";
            this->label_adc7_count->Size = System::Drawing::Size(16, 17);
            this->label_adc7_count->TabIndex = 0;
            this->label_adc7_count->Text = L"\?";
            // 
            // button_app_exit
            // 
            this->button_app_exit->Location = System::Drawing::Point(126, 187);
            this->button_app_exit->Name = L"button_app_exit";
            this->button_app_exit->Size = System::Drawing::Size(145, 35);
            this->button_app_exit->TabIndex = 17;
            this->button_app_exit->Text = L"Exit";
            this->button_app_exit->UseVisualStyleBackColor = true;
            this->button_app_exit->Click += gcnew System::EventHandler(this, &Form1::button_app_exit_Click);
            // 
            // label_scaled_adc0
            // 
            this->label_scaled_adc0->AutoSize = true;
            this->label_scaled_adc0->Location = System::Drawing::Point(10, 53);
            this->label_scaled_adc0->Name = L"label_scaled_adc0";
            this->label_scaled_adc0->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc0->TabIndex = 3;
            this->label_scaled_adc0->Text = L"\?";
            // 
            // label_scaled_adc1
            // 
            this->label_scaled_adc1->AutoSize = true;
            this->label_scaled_adc1->Location = System::Drawing::Point(9, 53);
            this->label_scaled_adc1->Name = L"label_scaled_adc1";
            this->label_scaled_adc1->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc1->TabIndex = 3;
            this->label_scaled_adc1->Text = L"\?";
            // 
            // label_scaled_adc2
            // 
            this->label_scaled_adc2->AutoSize = true;
            this->label_scaled_adc2->Location = System::Drawing::Point(9, 53);
            this->label_scaled_adc2->Name = L"label_scaled_adc2";
            this->label_scaled_adc2->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc2->TabIndex = 3;
            this->label_scaled_adc2->Text = L"\?";
            // 
            // label_scaled_adc3
            // 
            this->label_scaled_adc3->AutoSize = true;
            this->label_scaled_adc3->Location = System::Drawing::Point(9, 53);
            this->label_scaled_adc3->Name = L"label_scaled_adc3";
            this->label_scaled_adc3->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc3->TabIndex = 3;
            this->label_scaled_adc3->Text = L"\?";
            // 
            // label_scaled_adc4
            // 
            this->label_scaled_adc4->AutoSize = true;
            this->label_scaled_adc4->Location = System::Drawing::Point(9, 53);
            this->label_scaled_adc4->Name = L"label_scaled_adc4";
            this->label_scaled_adc4->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc4->TabIndex = 3;
            this->label_scaled_adc4->Text = L"\?";
            // 
            // label_scaled_adc5
            // 
            this->label_scaled_adc5->AutoSize = true;
            this->label_scaled_adc5->Location = System::Drawing::Point(9, 53);
            this->label_scaled_adc5->Name = L"label_scaled_adc5";
            this->label_scaled_adc5->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc5->TabIndex = 3;
            this->label_scaled_adc5->Text = L"\?";
            // 
            // label_scaled_adc6
            // 
            this->label_scaled_adc6->AutoSize = true;
            this->label_scaled_adc6->Location = System::Drawing::Point(10, 53);
            this->label_scaled_adc6->Name = L"label_scaled_adc6";
            this->label_scaled_adc6->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc6->TabIndex = 3;
            this->label_scaled_adc6->Text = L"\?";
            // 
            // label_scaled_adc7
            // 
            this->label_scaled_adc7->AutoSize = true;
            this->label_scaled_adc7->Location = System::Drawing::Point(9, 53);
            this->label_scaled_adc7->Name = L"label_scaled_adc7";
            this->label_scaled_adc7->Size = System::Drawing::Size(16, 17);
            this->label_scaled_adc7->TabIndex = 3;
            this->label_scaled_adc7->Text = L"\?";
            // 
            // Form1
            // 
            this->AutoScaleDimensions = System::Drawing::SizeF(8, 16);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->ClientSize = System::Drawing::Size(810, 444);
            this->Controls->Add(this->button_app_exit);
            this->Controls->Add(this->groupBox_adc7);
            this->Controls->Add(this->groupBox_adc6);
            this->Controls->Add(this->groupBox_adc5);
            this->Controls->Add(this->groupBox_adc4);
            this->Controls->Add(this->groupBox_adc3);
            this->Controls->Add(this->groupBox_adc2);
            this->Controls->Add(this->groupBox_adc1);
            this->Controls->Add(this->groupBox_adc0);
            this->Controls->Add(this->button_open_data_base);
            this->Controls->Add(this->label_status_data_base);
            this->Controls->Add(this->groupBox_messages);
            this->Controls->Add(this->button_open_com_port);
            this->Controls->Add(this->label_status_com_port);
            this->Controls->Add(this->comboBox_baud_rate);
            this->Controls->Add(this->label_baud_rate);
            this->Controls->Add(this->comboBox_com_port);
            this->Controls->Add(this->label_com_port);
            this->FormBorderStyle = System::Windows::Forms::FormBorderStyle::FixedDialog;
            this->Name = L"Form1";
            this->Text = L"Store Analog Values V-0.02";
            this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &Form1::Form1_FormClosing);
            this->groupBox_messages->ResumeLayout(false);
            this->groupBox_messages->PerformLayout();
            this->groupBox_adc0->ResumeLayout(false);
            this->groupBox_adc0->PerformLayout();
            this->groupBox_adc1->ResumeLayout(false);
            this->groupBox_adc1->PerformLayout();
            this->groupBox_adc2->ResumeLayout(false);
            this->groupBox_adc2->PerformLayout();
            this->groupBox_adc3->ResumeLayout(false);
            this->groupBox_adc3->PerformLayout();
            this->groupBox_adc4->ResumeLayout(false);
            this->groupBox_adc4->PerformLayout();
            this->groupBox_adc5->ResumeLayout(false);
            this->groupBox_adc5->PerformLayout();
            this->groupBox_adc6->ResumeLayout(false);
            this->groupBox_adc6->PerformLayout();
            this->groupBox_adc7->ResumeLayout(false);
            this->groupBox_adc7->PerformLayout();
            this->ResumeLayout(false);
            this->PerformLayout();

        }
#pragma endregion
//-----------------------------------------------
 private: System::Void timer1_Tick(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    static UInt32 ui_intervals_count = 0;
    int i_hi_byte = 0;
    int i_low_byte = 0;
    String ^ s_result = nullptr;
    ui_intervals_count++;
    if(!this->serialPort1->IsOpen)
        return;
    if(!this->msql_data_base->IsOpen)
        return;
    this->serialPort1->DiscardInBuffer();
    this->serialPort1->DiscardOutBuffer();
    for(Int32 i_channel = 0; i_channel < 8; i_channel++)
        {
        if(this->mao_adc_params[i_channel]->Status)
            {
            if(0 == (ui_intervals_count % this->mao_adc_params[i_channel]->Interval))
                {
                try
                    {
                    this->serialPort1->Write(this->mauc_cmd, i_channel, 1);
                    i_low_byte = this->serialPort1->ReadByte();
                    i_hi_byte = this->serialPort1->ReadByte();
                    this->mao_adc_params[i_channel]->Value = Convert::ToUInt16(((i_hi_byte << 8) | i_low_byte));
                    }
                catch(System::IO::IOException ^ e)
                    {
                    this->textBox_messages->AppendText(e->Message + "\n");
                    return;
                    }
                catch(System::TimeoutException ^ e)
                    {
                    this->textBox_messages->AppendText(e->Message + "\n");
                    return;
                    }
                catch(System::Exception ^ e)
                    {
                    this->textBox_messages->AppendText(e->Message + "\n");
                    return;
                    }
                if(0x0400 > this->mao_adc_params[i_channel]->Value)
                    {
                    s_result = this->msql_data_base->InsertRow(
                        i_channel.ToString(),
                        this->mao_adc_params[i_channel]->Name,
                        this->mao_adc_params[i_channel]->Value.ToString(),
                        this->mao_adc_params[i_channel]->Scaled.ToString()
                        );
                    if("OK" == s_result)
                        {
                        this->SetLabelScaled(i_channel);
                        this->mao_adc_params[i_channel]->Count++;
                        this->SetLabelCount(i_channel);
                        }
                    else
                        this->textBox_messages->AppendText(s_result + "\n");
                    }
                }
            }
        }
    }
//-----------------------------------------------
 private: System::Void SetGroupBoxText(Int32 i_channel)
    {
    String ^ s_name;
    if(10 < this->mao_adc_params[i_channel]->Name->Length)
        s_name = this->mao_adc_params[i_channel]->Name->Substring(0, 10);
    else
        s_name = this->mao_adc_params[i_channel]->Name;
    switch(i_channel)
        {
        case 0: this->groupBox_adc0->Text = s_name; break;
        case 1: this->groupBox_adc1->Text = s_name; break;
        case 2: this->groupBox_adc2->Text = s_name; break;
        case 3: this->groupBox_adc3->Text = s_name; break;
        case 4: this->groupBox_adc4->Text = s_name; break;
        case 5: this->groupBox_adc5->Text = s_name; break;
        case 6: this->groupBox_adc6->Text = s_name; break;
        case 7: this->groupBox_adc7->Text = s_name; break;
        }
    }
//-----------------------------------------------
 private: System::Void SetLabelScaled(Int32 i_channel)
    {
    switch(i_channel)
        {
        case 0: this->label_scaled_adc0->Text = this->mao_adc_params[0]->Scaled.ToString(); break;
        case 1: this->label_scaled_adc1->Text = this->mao_adc_params[1]->Scaled.ToString(); break;
        case 2: this->label_scaled_adc2->Text = this->mao_adc_params[2]->Scaled.ToString(); break;
        case 3: this->label_scaled_adc3->Text = this->mao_adc_params[3]->Scaled.ToString(); break;
        case 4: this->label_scaled_adc4->Text = this->mao_adc_params[4]->Scaled.ToString(); break;
        case 5: this->label_scaled_adc5->Text = this->mao_adc_params[5]->Scaled.ToString(); break;
        case 6: this->label_scaled_adc6->Text = this->mao_adc_params[6]->Scaled.ToString(); break;
        case 7: this->label_scaled_adc7->Text = this->mao_adc_params[7]->Scaled.ToString(); break;
        }
    }
//-----------------------------------------------
 private: System::Void SetLabelCount(Int32 i_channel)
    {
    switch(i_channel)
        {
        case 0: this->label_adc0_count->Text = this->mao_adc_params[0]->Count.ToString(); break;
        case 1: this->label_adc1_count->Text = this->mao_adc_params[1]->Count.ToString(); break;
        case 2: this->label_adc2_count->Text = this->mao_adc_params[2]->Count.ToString(); break;
        case 3: this->label_adc3_count->Text = this->mao_adc_params[3]->Count.ToString(); break;
        case 4: this->label_adc4_count->Text = this->mao_adc_params[4]->Count.ToString(); break;
        case 5: this->label_adc5_count->Text = this->mao_adc_params[5]->Count.ToString(); break;
        case 6: this->label_adc6_count->Text = this->mao_adc_params[6]->Count.ToString(); break;
        case 7: this->label_adc7_count->Text = this->mao_adc_params[7]->Count.ToString(); break;
        }
    }
//-----------------------------------------------
 private: System::Void comboBox_baud_rate_DropDown(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    array<Int32> ^ ai_baud_rates = gcnew array<Int32>(11);
    ai_baud_rates[0] = 300;
    ai_baud_rates[1] = 600;
    ai_baud_rates[2] = 1200;
    ai_baud_rates[3] = 2400;
    ai_baud_rates[4] = 9600;
    ai_baud_rates[5] = 14400;
    ai_baud_rates[6] = 19200;
    ai_baud_rates[7] = 38400;
    ai_baud_rates[8] = 57600;
    ai_baud_rates[9] = 115200;
    ai_baud_rates[10] = 128000;
    this->comboBox_baud_rate->DataSource = ai_baud_rates;
    }
//-----------------------------------------------
 private: System::Void comboBox_baud_rate_SelectedIndexChanged(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    this->mo_xml_params->BaudRate = Convert::ToInt32(this->comboBox_baud_rate->SelectedItem->ToString());
    }
//-----------------------------------------------
 private: System::Void comboBox_com_port_DropDown(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    this->comboBox_com_port->DataSource = SerialPort::GetPortNames();
    }
//-----------------------------------------------
 private: System::Void comboBox_com_port_SelectedIndexChanged(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    this->mo_xml_params->PortName = this->comboBox_com_port->SelectedItem->ToString();
    }
//-----------------------------------------------
 private: System::Void button_open_com_port_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    try
        {
        if(this->serialPort1->IsOpen)
            this->serialPort1->Close();
        this->label_status_com_port->Text = this->ms_status_closed;
        }
    catch(System::IO::IOException ^ e)
        {
        this->textBox_messages->AppendText(e->Message + "\n");
        }
    catch(System::ObjectDisposedException ^ e)
        {
        this->textBox_messages->AppendText(e->Message + "\n");
        }
    this->serialPort1->PortName = this->comboBox_com_port->SelectedItem->ToString();
    this->serialPort1->BaudRate = Convert::ToInt32(this->comboBox_baud_rate->SelectedItem->ToString());
    try
        {
        this->serialPort1->Open();
        }
    catch(System::IO::IOException ^ e)
        {
        this->textBox_messages->AppendText("Error open COMx-Port " + e->Message + "\n");
        this->label_status_com_port->Text = this->ms_status_closed;
        }
    catch(System::UnauthorizedAccessException ^ e)
        {
        this->textBox_messages->AppendText("Error open COMx-Port " + e->Message + "\n");
        this->label_status_com_port->Text = this->ms_status_closed;
        }
    if(this->serialPort1->IsOpen)
        {
        this->mby_port_cmd[0] = CMD_SEND_TEST;
        this->serialPort1->DiscardInBuffer();
        this->serialPort1->DiscardOutBuffer();
        this->serialPort1->Write(this->mby_port_cmd, 0, 1);
        try
            {
            if(TEST_OK == this->serialPort1->ReadByte())
                {
                this->label_status_com_port->Text = this->ms_status_open;
                }
            else
                {
                this->serialPort1->Close();
                this->label_status_com_port->Text = this->ms_status_closed;
                this->textBox_messages->AppendText("No connection to the installation\n");
                }
            }
        catch(System::TimeoutException ^ e)
            {
            this->serialPort1->Close();
            this->label_status_com_port->Text = this->ms_status_closed;
            this->textBox_messages->AppendText(e->Message + "\n");
            }
        }
    CheckIsReady();
    }
//-----------------------------------------------
 private: System::Void button_open_data_base_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    String ^ s_db_file = nullptr;
    String ^ s_result = nullptr;
    if(this->msql_data_base->IsOpen)
        {
        s_result = msql_data_base->Close();
        if("OK" != s_result)
            this->textBox_messages->AppendText(s_result + "\n");
        else
            this->label_status_data_base->Text = this->ms_status_closed;
        }
    if(mbo_auto_start)
        {
        mbo_auto_start = false;
        if(File::Exists(mo_xml_params->DataBase))
            s_db_file = mo_xml_params->DataBase;
        else
            return;
        }
    else
        {
        OpenFileDialog ^ of_dlg_db_file = gcnew OpenFileDialog();
        of_dlg_db_file->DefaultExt = "mdf";
        of_dlg_db_file->Filter = "SQL Data Base files (*.mdf)|*.mdf|All files (*.*)|*.*";
        if(File::Exists(this->mo_xml_params->DataBase))
            of_dlg_db_file->InitialDirectory = Path::GetFullPath(this->mo_xml_params->DataBase);
        else
            of_dlg_db_file->InitialDirectory = System::Environment::CurrentDirectory;
        if(System::Windows::Forms::DialogResult::OK == of_dlg_db_file->ShowDialog())
            s_db_file = of_dlg_db_file->FileName;
        else
            return;
        }
    s_result = this->msql_data_base->Open(s_db_file);
    if("OK" == s_result)
        {
        this->label_status_data_base->Text = this->ms_status_open;
        this->mo_xml_params->DataBase = s_db_file;
        for(Int32 i_channel = 0; i_channel < 8; i_channel++)
            {
            this->mao_adc_params[i_channel]->Count = this->msql_data_base->GetRowsCount(i_channel);
            SetLabelCount(i_channel);
            }
        }
    else
        this->textBox_messages->AppendText(s_result + "\n");
    CheckIsReady();
    }
//-----------------------------------------------
 private: System::Void CheckIsReady(void)
    {
    if(this->msql_data_base->IsOpen && this->serialPort1->IsOpen)
        {
        this->button_adc0_start_stop->Enabled = true;
        this->button_adc1_start_stop->Enabled = true;
        this->button_adc2_start_stop->Enabled = true;
        this->button_adc3_start_stop->Enabled = true;
        this->button_adc4_start_stop->Enabled = true;
        this->button_adc5_start_stop->Enabled = true;
        this->button_adc6_start_stop->Enabled = true;
        this->button_adc7_start_stop->Enabled = true;
        this->timer1->Start();
        }
    else
        {
        this->button_adc0_start_stop->Enabled = false;
        this->button_adc1_start_stop->Enabled = false;
        this->button_adc2_start_stop->Enabled = false;
        this->button_adc3_start_stop->Enabled = false;
        this->button_adc4_start_stop->Enabled = false;
        this->button_adc5_start_stop->Enabled = false;
        this->button_adc6_start_stop->Enabled = false;
        this->button_adc7_start_stop->Enabled = false;
        this->timer1->Stop();
        }
    }
//----------------------------------------------
 private: System::Void button_clear_messages_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    this->textBox_messages->Clear();
    }
//-----------------------------------------------
 private: System::Void ADCSettings(UInt16 ui_channel)
    {
    SetADCParams ^ dlg_adc_params = gcnew SetADCParams(this->mao_adc_params[ui_channel]);
    dlg_adc_params->Text = "Set Parametres AD-Channel: " + ui_channel.ToString();
    if(System::Windows::Forms::DialogResult::OK == dlg_adc_params->ShowDialog())
        {
        this->mao_adc_params[ui_channel] = dlg_adc_params->mo_params;
        this->mao_adc_params[ui_channel]->Count = this->msql_data_base->GetRowsCount(ui_channel);
        SetGroupBoxText(ui_channel);
        SetLabelCount(ui_channel);
        }
    }
//-----------------------------------------------
 private: System::Void button_adc0_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(0);
    }
//-----------------------------------------------
 private: System::Void button_adc1_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(1);
    }
//-----------------------------------------------
 private: System::Void button_adc2_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(2);
    }
//-----------------------------------------------
 private: System::Void button_adc3_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(3);
    }
//-----------------------------------------------
 private: System::Void button_adc4_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(4);
    }
//-----------------------------------------------
 private: System::Void button_adc5_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(5);
    }
//-----------------------------------------------
 private: System::Void button_adc6_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(6);
    }
//-----------------------------------------------
 private: System::Void button_adc7_settings_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    ADCSettings(7);
    }
//-----------------------------------------------
 private: System::Void StartStop(System::Object ^ sender, Int32 i_channel)
    {
    if(this->mao_adc_params[i_channel]->Status)
        {
        this->mao_adc_params[i_channel]->Status = false;
        ((Button ^)sender)->Text = "Start";
        }
    else
        {
        this->mao_adc_params[i_channel]->Status = true;
        ((Button ^)sender)->Text = "Stop";
        }
    }
//-----------------------------------------------
 private: System::Void button_adc0_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 0);
    }
//-----------------------------------------------
 private: System::Void button_adc1_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 1);
    }
//-----------------------------------------------
 private: System::Void button_adc2_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 2);
    }
//-----------------------------------------------
 private: System::Void button_adc3_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 3);
    }
//-----------------------------------------------
 private: System::Void button_adc4_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 4);
    }
//-----------------------------------------------
 private: System::Void button_adc5_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 5);
    }
//-----------------------------------------------
 private: System::Void button_adc6_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 6);
    }
//-----------------------------------------------
 private: System::Void button_adc7_start_stop_Click(System::Object ^ sender, System::EventArgs ^ /*e*/)
    {
    StartStop(sender, 7);
    }
//-----------------------------------------------
 private: System::Void Form1_FormClosing(System::Object ^ /*sender*/, System::Windows::Forms::FormClosingEventArgs ^ /*e*/)
    {
    this->mo_xml_params->SaveProperties(this->mao_adc_params);
    }
//-----------------------------------------------
 private: System::Void button_app_exit_Click(System::Object ^ /*sender*/, System::EventArgs ^ /*e*/)
    {
    this->Close();
    }
//-----------------------------------------------
};
}

