/*** ShowAnalogValues-0.01.cc ***/
//------------------------------------------------
 #include "SerialPortCmd.h"
 #define SERIAL_PORT 0
//------------------------------------------------
// 35 byte send-buffer and receive-buffer + 6 byte internal FIFO administration.
 byte by_serial_buffer[41];
//------------------------------------------------
 void main(void)
    {
    word w_received;
    word w_ad_value;
    int i_delay;
// Initialize serial interface.
	Serial_Init_IRQ(
        SERIAL_PORT,
        by_serial_buffer,
        20,
        15,
        SR_8BIT | SR_1STOP | SR_NO_PAR,
        SR_BD57600
        );
// Initialize analog-digital converter.
    Port_DataDir(PortA, 0xFF);
    Port_Write(PortA, 0);
    while(true)
        {
        w_received = Serial_ReadExt(SERIAL_PORT);
        switch(w_received)
            {
            case EMPTY_BUFFER:
                break;
            case CMD_GET_ADC0:
            case CMD_GET_ADC1:
            case CMD_GET_ADC2:
            case CMD_GET_ADC3:
            case CMD_GET_ADC4:
            case CMD_GET_ADC5:
            case CMD_GET_ADC6:
            case CMD_GET_ADC7:
                ADC_Set(ADC_VREF_VCC, w_received - CMD_GET_ADC0);
                for(i_delay = 0; i_delay < 4; i_delay++) { }
                w_ad_value = ADC_Read();
                Serial_Write(SERIAL_PORT, w_ad_value);
                Serial_Write(SERIAL_PORT, w_ad_value >> 8);
                break;
            case CMD_SEND_TEST:
                Serial_Write(SERIAL_PORT, TEST_OK);
                break;
            default:
                Serial_Write(SERIAL_PORT, UNKNOWN_CMD);
                Serial_Write(SERIAL_PORT, UNKNOWN_CMD >> 8);
                break;
            }
        }
    }
//------------------------------------------------