/*** DCF77Time-1.01.cc ***/
//------------------------------------------------
// Copyright (C) 2011 by Torsten Knorr
// create-soft@freenet.de
// All rights reserved!
// Permission is hereby granted to modify or enhance this sample code.
// This source code is provided "as is" and without any express or
// implied warranties, including, without limitation, the implied
// warranties of merchantibility and fitness for a particular purpose.
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "DCF77.h"
//------------------------------------------------
 flash char g_ac_parity_error[ERROR_MSG_LENGTH] =
    {'P', 'a', 'r', 'i', 't', 'y', ' ', ' ', ' ', ' ', ' ', 'E', 'r', 'r', 'o', 'r', ' ', ' ', '!', 0};
 flash char g_ac_out_of_range[ERROR_MSG_LENGTH] =
    {'O', 'u', 't', ' ', 'O', 'f', ' ', ' ', ' ', ' ', ' ', 'R', 'a', 'n', 'g', 'e', ' ', ' ', '!', 0};
 flash char g_ac_signal_error[ERROR_MSG_LENGTH] =
    {'S', 'i', 'g', 'n', 'a', 'l', ' ', ' ', ' ', ' ', ' ', 'E', 'r', 'r', 'o', 'r', ' ', ' ', '!', 0};
 flash char g_ac_weekdays[WEEKDAYS][WEEKDAY_LENGTH] =
    {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    'M', 'o', 'n', 't', 'a', 'g', 0, 0, 0, 0, 0,
    'D', 'i', 'e', 'n', 's', 't', 'a', 'g', 0, 0, 0,
    'M', 'i', 't', 't', 'w', 'o', 'c', 'h', 0, 0, 0,
    'D', 'o', 'n', 'n', 'e', 'r', 's', 't', 'a', 'g', 0,
    'F', 'r', 'e', 'i', 't', 'a', 'g', 0, 0, 0, 0,
    'S', 'o', 'n', 'n', 'a', 'b', 'e', 'n', 'd', 0, 0,
    'S', 'o', 'n', 'n', 't', 'a', 'g', 0, 0, 0, 0
    };
//------------------------------------------------
 byte g_aby_dcf77_double_buffer[2][DCF_SIZE];
 byte g_by_dcf77_flip;
 byte g_by_dcf77_puls_count;
 byte g_by_dcf77_error;
//------------------------------------------------
// void DCF77Init(void)
// Initialize the global variables and put the DCF77-databuffer on a defined state.
// Parameters:
// 	No parameters.
// Result:
// 	No returned value.
// Description:
// 	Always call this function first.
 void DCF77Init(void)
    {
 	int i_index;
// Port D.7 = input.
    Port_DataDirBit(DCF_IN, 0);
// Pull up on.
    Port_WriteBit(DCF_IN, 1);
    for(i_index = 0; i_index < DCF_SIZE; i_index++)
        {
        g_aby_dcf77_double_buffer[0][i_index] = 0;
        g_aby_dcf77_double_buffer[1][i_index] = 0;
        }
    g_by_dcf77_flip = 0;
    g_by_dcf77_puls_count = 0;
    g_by_dcf77_error = 0xFF;
    Irq_SetVect(INT_TIM2COMP, DCF77ReceiveSignal);
    Thread_Start(THREAD_NUMBER_DCF77, DCF77ThreadSetSystemTime);
    }
//------------------------------------------------
// void DCF77ReceiveSignal(void)
// This function captures the pulse lengths of the DCF77-signals.
// Parameters:
// 	No parameters.
// Result:
// 	No returned value.
// Description:
//  The system will call this function all 10 ms.
//  When a new minute begins and the pulse is without error, a thread
//  will be resumed to set the system time.
 void DCF77ReceiveSignal(void)
    {
    static byte by_interrupt_count;
    static byte by_status_old;
    static byte by_bit_pos;
    static byte by_byte_count;
    byte by_status_new;
    by_status_new = Port_ReadBit(DCF_IN);
// If flank change?
    if(by_status_new ^ by_status_old)
        {
// If positive flank?
        if(by_status_new)
            {
            switch(by_interrupt_count)
                {
// If you want to adapt the monitoring of the DCF77-signal then
// change the 'case' instructions.
                //case 78:
                case 79:
                case 80:
                case 81:
                case 82:
                //case 83:
                //case 88:
                case 89:
                case 90:
                case 91:
                case 92:
                //case 93:
                    g_by_dcf77_puls_count++;
                    break;
// Synchronization pulse.
                //case 178:
                case 179:
                case 180:
                case 181:
                //case 182:
                //case 188:
                case 189:
                case 190:
                case 191:
                //case 192:
                    if((0x0F | g_by_dcf77_error) ==   (by_byte_count | by_bit_pos))
 			            {
                        g_by_dcf77_flip = g_by_dcf77_flip ^ 0x01;
                        g_by_dcf77_error = 0;
                        Thread_Resume(THREAD_NUMBER_DCF77);
 				        }
                    else
                        g_by_dcf77_error = 0x0F;
                    by_bit_pos = 1;
			        by_byte_count = 0;
                    g_by_dcf77_puls_count = 0;
                    break;
                default:
                    g_by_dcf77_error = 0xFF;
                }
            }
// Negative flank.
        else
            {
            switch(by_interrupt_count)
                {
// Logical 0. (100ms)
                //case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                //case 12:
	                g_aby_dcf77_double_buffer[g_by_dcf77_flip][by_byte_count] =
                        g_aby_dcf77_double_buffer[g_by_dcf77_flip][by_byte_count] & ~by_bit_pos;
                    break;
// Logical 1. (200ms)
                //case 17:
                case 18:
                case 19:
                case 20:
                case 21:
                //case 22:
			        g_aby_dcf77_double_buffer[g_by_dcf77_flip][by_byte_count] =
                        g_aby_dcf77_double_buffer[g_by_dcf77_flip][by_byte_count] | by_bit_pos;
                    break;
                default:
                    g_by_dcf77_error = 0xFF;
                }
            by_bit_pos = by_bit_pos << 1;
            if(!by_bit_pos)
                {
                by_bit_pos = 1;
                by_byte_count = 0x07 & ++by_byte_count;
                }
            }
        by_interrupt_count = 0;
        }
    else
// If no pulse?
        if(193 < by_interrupt_count)
            g_by_dcf77_error = 0xFF;
    by_status_old = by_status_new;
    by_interrupt_count = by_interrupt_count + Irq_GetCount(INT_TIM2COMP);
    }
//------------------------------------------------
// void DCF77ThreadSetSystemTime(void)
// This function sets the system time.
// Parameters:
//  No parameters.
// Result:
//  No returned value.
// Description:
//  The thread is stopped immediately after he is started.
//  If a faultless data acquisition is ended, he is woken up with
//  the first positive flank of the new minute.
// Since the DCF77-signal is interference-prone, it should be checked before use.
// It is my opinion, better to have no time as using the wrong time.
// If you think differently, please feel free to remove some checks.
 void DCF77ThreadSetSystemTime(void)
    {
    byte aby_dcf[DCF_SIZE];
 	int ai_values[VALUES_SIZE];
 	byte aby_bcd[BCD_SIZE];
    while(1)
        {
        Thread_Wait(THREAD_NUMBER_DCF77, THREAD_SIGNAL_DCF77);
        if(DCF77CopyBuffer(aby_dcf))
            {
            if(DCF77CheckParity(aby_dcf))
                {
 	    	    DCF77ToBCD(aby_dcf, aby_bcd);
	    	    DCF77BCDToInteger(aby_bcd, ai_values);
 	    	    if(DCF77CheckRange(ai_values))
                    {
                    Clock_SetTime(ai_values[HOUR], ai_values[MINUTE], g_by_dcf77_puls_count, 0x00);
                    Clock_SetDate(ai_values[DAY] - 1, ai_values[MONTH] - 1, ai_values[YEAR]);
                    }
                }
            }
        }
    }
//------------------------------------------------
// BOOL DCF77CopyBuffer(byte pby_dcf[])
// This function copies the current DCF77-data in a array.
// Parameters:
//  byte pby_dcf[]
//      Pointer to an array of bytes with the size of 8 bytes (DCF_SIZE),
//      in which the DCF77-data are copied.
// Result:
// 	Is the copy-operation successful  the function returns true. Otherwise false.
// Description:
//  You should not access directly the global array 'g_aby_dcf77_double_buffer'!
//  Firstly: Because the DCF77-data can be faulty.
//  Secondly: Reading and writing to the same array at the same time
//  can cause problems.
 BOOL DCF77CopyBuffer(byte pby_dcf[])
    {
    byte by_flop;
    int i_index;
    if(g_by_dcf77_error)
        return false;
    by_flop = g_by_dcf77_flip ^ 0x01;
    for(i_index = 0; i_index < DCF_SIZE; i_index++)
        pby_dcf[i_index] = g_aby_dcf77_double_buffer[by_flop][i_index];
    return true;
    }
//------------------------------------------------
// BOOL DCF77CheckParity(byte pby_dcf[])
// Checks the parity of the DCF77-Signal for minute, hour and date.
// Parameters:
// 	byte pby_dcf[]
//      Pointer to an array which contains the DCF77-data.
// Result:
// 	Is the  check successful  the function returns true. Otherwise false.
// Description:
 BOOL DCF77CheckParity(byte pby_dcf[])
 	{
 	int i_byte;
 	int i_bit;
	int i_pos;
 	int i_count;
 	i_pos = 0;
 	for(i_byte = 2; i_byte <= 7; i_byte++)
 		{
 		for(i_bit = 1; i_bit <= 128; i_bit = i_bit << 1)
 			{
 			if(pby_dcf[i_byte] & i_bit)
 				i_count++;
 			switch(i_pos)
 				{
 				case 4: i_count = 0; break;
 				case 12:
 				case 19: if(i_count & 1) return false; break;
 				case 42:
                    if(i_count & 1)
 						return false;
 					else
 						return true;
 			 	}
 			i_pos++;
 			}
 		}
 	return false;
 	}
//------------------------------------------------
// BOOL DCF77CheckRange(int pi_values[])
// This function checks whether the data lie in the allowed field for minute, hour,
// day, weekday, month and year.
// Parameters:
// 	int pi_values[]
// 		Pointer to an array which contains the DCF77-data as integer values.
// Result:
// 	Is the  check successful  the function returns true. Otherwise false.
// Description:
// 	If all data lie in the permissible field true is returned.
//  The value for the year must be adjusted.
 BOOL DCF77CheckRange(int pi_values[])
 	{
 	if((0 > pi_values[MINUTE]) || (59 < pi_values[MINUTE]))
 		return false;
 	if((0 > pi_values[HOUR]) || (23 < pi_values[HOUR]))
 		return false;
 	if((1 > pi_values[DAY]) || (31 < pi_values[DAY]))
 		return false;
 	if((1 > pi_values[WEEKDAY]) || (7 < pi_values[WEEKDAY]))
 		return false;
 	if((1 > pi_values[MONTH]) || (12 < pi_values[MONTH]))
 		return false;
 	if((11 > pi_values[YEAR]) || (20 < pi_values[YEAR]))
 		return false;
 	return true;
 	}
//------------------------------------------------
// void DCF77ToBCD(byte pby_dcf, byte pby_bcd[])
// In this function the DCF77 signal data are moved into a BCD data format.
// Parameters:
//  byte pby_dcf[]
//      Pointer to an array with the size of 8 bytes (DCF_SIZE) which contains
//      the DCF77-data.
// 	byte pby_bcd[]
// 		Pointer to an array with the size of 6 bytes (BCD_SIZE) into which
//      the values will be inserted.
// Result:
// 	No returned value.
// Description:
// 	The DCF77-data will be inserted in the array in BCD-format.
// 	Except of "weekday" every byte contains two decades.
 void DCF77ToBCD(byte pby_dcf[], byte pby_bcd[])
 	{
	pby_bcd[MINUTE] = ((pby_dcf[2] >> 5) | (pby_dcf[3] << 3)) & 127;
	pby_bcd[HOUR] = ((pby_dcf[3] >> 5) | (pby_dcf[4] << 3)) & 63;
	pby_bcd[DAY] = ((pby_dcf[4] >> 4) | (pby_dcf[5] << 4)) & 63;
	pby_bcd[WEEKDAY] = (pby_dcf[5] >> 2) & 7;
	pby_bcd[MONTH] = ((pby_dcf[5] >> 5) | (pby_dcf[6] << 3)) & 31;
	pby_bcd[YEAR] = (pby_dcf[6] >> 2) | (pby_dcf[7] << 6);
 	}
//------------------------------------------------
// void DCF77BCDToInteger(byte pby_bcd[], int pi_values[])
// This function converts the DCF77-data from BCD-format into the
// corresponding integer values.
// Parameters:
// 	byte pby_bcd[]
// 		Pointer to an array which contains the DCF77-data in BCD-format.
// 	pi_values[]
// 		Pointer to an array with the size of 6 integers (VALUES_SIZE) into which
//      the values will be inserted.
// Result:
// 	No returned value.
// Description:
// 	The integer values are better suitable for the further processing in many possible applications.
 void DCF77BCDToInteger(byte pby_bcd[], int pi_values[])
 	{
 	int i_index;
 	for(i_index = MINUTE; i_index <= YEAR; i_index++)
 		pi_values[i_index] = (((pby_bcd[i_index] >> 4) * 10) + (pby_bcd[i_index] & 0x0F));
 	}
//------------------------------------------------
// void DCF77BCDToString(byte pby_bcd[], char pc_buffer[])
// This function converts the BCD-coded DCF77-data into a readable string.
// Parameters:
// 	byte pby_bcd[]
// 		Pointer to an array which contains the DCF77-data in BCD-format.
// 	char pc_buffer[]
// 		Pointer to an array with the size of 35 chars (MSG_LENGTH) into which
//      the values will be inserted.
// Result:
// 	No returned value.
// Description:
// 	The character string has the format: "06-08-2011 14:13:06 weekday DCF"
 void DCF77BCDToString(byte pby_bcd[], char pc_buffer[])
    {
 	int i_index;
    int i_pos;
 	pc_buffer[0] = (pby_bcd[DAY] >> 4) + 0x30;
 	pc_buffer[1] = (pby_bcd[DAY] & 0x0F) + 0x30;
 	pc_buffer[2] = '-';
 	pc_buffer[3] = (pby_bcd[MONTH] >> 4) + 0x30;
 	pc_buffer[4] = (pby_bcd[MONTH] & 0x0F) + 0x30;
 	pc_buffer[5] = '-';
 	pc_buffer[6] = '2';
 	pc_buffer[7] = '0';
 	pc_buffer[8] = (pby_bcd[YEAR] >> 4) + 0x30;
 	pc_buffer[9] = (pby_bcd[YEAR] & 0x0F) + 0x30;
	pc_buffer[10] = ' ';
 	pc_buffer[11] = (pby_bcd[HOUR] >> 4) + 0x30;
 	pc_buffer[12] = (pby_bcd[HOUR] & 0x0F) + 0x30;
 	pc_buffer[13] = ':';
 	pc_buffer[14] = (pby_bcd[MINUTE] >> 4) + 0x30;
 	pc_buffer[15] = (pby_bcd[MINUTE] & 0x0F) + 0x30;
 	pc_buffer[16] = ':';
 	pc_buffer[17] = ((g_by_dcf77_puls_count % 100) / 10) + 0x30;
 	pc_buffer[18] = (g_by_dcf77_puls_count % 10) + 0x30;
// Because there is no flank at the 59. second, we must simulate the last second of
// the minute.
    if(58 == g_by_dcf77_puls_count)
        g_by_dcf77_puls_count++;
    pc_buffer[19] = ' ';
    i_index = 20;
    i_pos = 0;
	while(g_ac_weekdays[pby_bcd[WEEKDAY]][i_pos])
 		pc_buffer[i_index++] = g_ac_weekdays[pby_bcd[WEEKDAY]][i_pos++];
    pc_buffer[i_index++] = ' ';
    pc_buffer[i_index++] = 'D';
    pc_buffer[i_index++] = 'C';
    pc_buffer[i_index++] = 'F';
 	pc_buffer[i_index] = 0x00;
    }
//------------------------------------------------
// void DCF77TimeAsString(char pc_buffer[])
// This function copies the DCF77-time into a readable character string.
// Parameters:
//  char pc_buffer[]
//      Pointer to an array of char with the size of 35 (MSG_LENGTH).
// Result:
// 	No returned value.
// Description:
//  If you need the DCF77-time in form of a string, this function does the whole work.
//  If during the checks an error is found, then an error-message is copied into the buffer.
 void DCF77TimeAsString(char pc_buffer[])
    {
    byte aby_dcf[DCF_SIZE];
 	int ai_values[VALUES_SIZE];
 	byte aby_bcd[BCD_SIZE];
    int i_index;
    i_index = 0;
    if(DCF77CopyBuffer(aby_dcf))
        {
        if(DCF77CheckParity(aby_dcf))
            {
 	    	DCF77ToBCD(aby_dcf, aby_bcd);
	    	DCF77BCDToInteger(aby_bcd, ai_values);
 	    	if(DCF77CheckRange(ai_values))
                DCF77BCDToString(aby_bcd, pc_buffer);
            else
                do
                    pc_buffer[i_index] = g_ac_out_of_range[i_index];
                    while(pc_buffer[i_index++]);
            }
        else
            do
                pc_buffer[i_index] = g_ac_parity_error[i_index];
                while(pc_buffer[i_index++]);
        }
    else
        do
            pc_buffer[i_index] = g_ac_signal_error[i_index];
            while(pc_buffer[i_index++]);
    }
//------------------------------------------------

