;*** StringContainer-0.01.asm ***;
;-------------------------------------------------
; Copyright (C) 2011 by Torsten Knorr
; create-soft@freenet.de
; All rights reserved!
; This source code is provided "as is", without any guarantee made as to its
; suitability or fitness for any particular use. Permission is hereby granted to
; modify or enhance this sample code.
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
; Define error codes.
 .EQU OK_INIT         = 0x0001
 .EQU OK_CLEAR    = 0x0002
 .EQU OK_PUSH       = 0x0003
 .EQU OK_POP          = 0x0004
 .EQU OK_UNSHIFT = 0x0005
 .EQU OK_SHIFT       = 0x0006
 .EQU OK_INSERT    = 0x0007
 .EQU OK_DELETE   = 0x0008
 .EQU IS_EMPTY      = 0x0009
 .EQU E_INIT            = 0xFFFF
 .EQU E_CLEAR       = 0xFFFE
 .EQU E_PUSH          = 0xFFFD
 .EQU E_POP            = 0xFFFC
 .EQU E_UNSHIFT  = 0xFFFB
 .EQU E_SHIFT        = 0xFFFA
 .EQU E_INSERT     = 0xFFF9
 .EQU E_DELETE   = 0xFFF8
 .EQU E_EMPTY     = 0x0000
;-------------------------------------------------
; Byte 1 = Lowbyte container end
; Byte 2 = Highbyte container end
; Byte 3 = Lowbyte container pos
; Byte 4 = Highbyte container pos
; (R0:R1) container begin
 .DEF   BEGIN_LOW   = R0
 .DEF   BEGIN_HIGH  = R1
; (R2:R3) container end
 .DEF   END_LOW       = R2
 .DEF   END_HIGH      = R3
; (R4:R5) container pos
 .DEF   POS_LOW       = R4
 .DEF   POS_HIGH      = R5
; (R8:R9) new string
 .DEF   NEW_LOW     = R8
 .DEF   NEW_HIGH    = R9
; (R22:R23:R24:R25) params or return values
 .DEF   RET_LOW      = R22
 .DEF   RET_HIGH     = R23
;-------------------------------------------------
 .MACRO RETURN_VALUE
    eor       R24,       R24
    eor       R25,       R25
    movw    R30,    R6
    adiw      R30,    4
    movw    R6,      R30
    st           Z+,      RET_LOW
    st           Z+,      RET_HIGH
    st           Z+,      R24
    st           Z,        R25
 .ENDMACRO
;-------------------------------------------------
 .MACRO GET_PARAMS
    movw    R30,    R10
; 2. Parameter to (R22:R23).
    ld          R22,    Z+
    ld          R23,    Z+
; 1. Parameter container begin to Z.
    ld          BEGIN_LOW,  Z+
    ld          BEGIN_HIGH, Z
    movw    R30,                   BEGIN_LOW
 .ENDMACRO
;-------------------------------------------------
 .MACRO GET_CONTAINER_BEGIN
; 1. Parameter container begin to Z.
    movw    R30,    R10
    ld           BEGIN_LOW,  Z+
    ld           BEGIN_HIGH, Z
    movw    R30,                   BEGIN_LOW
 .ENDMACRO
;-------------------------------------------------
 .MACRO PUSH_R2R3R4R5R8R9
    push    END_LOW
    push    END_HIGH
    push    POS_LOW
    push    POS_HIGH
    push    NEW_LOW
    push    NEW_HIGH
 .ENDMACRO
;-------------------------------------------------
 .MACRO POP_R9R8R5R4R3R2
    pop NEW_HIGH
    pop NEW_LOW
    pop POS_HIGH
    pop POS_LOW
    pop END_HIGH
    pop END_LOW
 .ENDMACRO
;-------------------------------------------------
 .MACRO GET_NEW_STRING
    movw    R30,    R10
; 2. Parameter: new string.
    ld          NEW_LOW,  Z+
    ld          NEW_HIGH, Z+
; 1. Parameter container begin to Z.
    ld          BEGIN_LOW,  Z+
    ld          BEGIN_HIGH, Z
    movw    R30,                  BEGIN_LOW
; Get container end. (1.+2. Byte)
    ld           END_LOW,  Z+
    ld           END_HIGH, Z+
; Get container pos. (3.+4. Byte)
    ld          POS_LOW,  Z+
    ld          POS_HIGH, Z
; New string to X.
    movw    R26,       NEW_LOW
; Get new string length to (R24:R25).
    eor        R24,        R24
    eor        R25,        R25
 .ENDMACRO
;-------------------------------------------------
 .ifdef TagInitContainer
 InitContainer:
    GET_PARAMS
    movw    R26,    BEGIN_LOW
; Calculate last address of the container.
; Startaddress + memorysize - 1
    add         R30,     R22
    adc          R31,     R23
    sbiw        R30,    1
; Store container end to the 1.+2. Byte.
    st           X+,       R30
    st           X+,       R31
; Store container pos to the 3.+4. Byte. (container begin + 5)
    movw    R24,     BEGIN_LOW
    adiw      R24,      5
    st          X+,        R24
    st          X+,        R25
; Set the memory to 0.
    eor        R24,     R24
 InitContainer_LoopZeroMemory:
    st           X+,       R24
    cp          R26,      R30
    cpc         R27,     R31
    brlo      InitContainer_LoopZeroMemory
    st           X,          R24
; If no error return OK_INIT.
    ldi         RET_LOW,  LOW(OK_INIT)
    ldi         RET_HIGH, HIGH(OK_INIT)
    jmp       InitContainer_ReturnOk
 InitContainer_ReturnError:
; If error return E_INIT.
    ldi         RET_LOW,  LOW(E_INIT)
    ldi         RET_HIGH, HIGH(E_INIT)
 InitContainer_ReturnOk:
    RETURN_VALUE
    ret
 .endif
;-------------------------------------------------
 .ifdef TagClearContainer
 ClearContainer:
    movw    R30,    R10
; 1. Parameter container begin to X and Z.
    ld          R26,       Z+
    ld          R27,       Z+
    movw    R30,      R26
; Get container end.
    ld          R24,       Z+
    ld          R25,       Z+
; Store container pos (container begin + 5).
    adiw     R26,     5
    st          Z+,        R26
    st          Z+,        R27
; Zero memory until container end.
    eor       R22,      R22
 ClearContainer_LoopZeroMemory:
    st          Z+,         R22
    cp         R30,      R24
    cpc       R31,       R25
    brlo     ClearContainer_LoopZeroMemory
    st          Z,           R22
; If no error return OK_CLEAR.
    ldi        RET_LOW,  LOW(OK_CLEAR)
    ldi        RET_HIGH, HIGH(OK_CLEAR)
    jmp      ClearContainer_ReturnOk
 ClearContainer_ReturnError:
; If error return E_CLEAR.
    ldi        RET_LOW,  LOW(E_CLEAR)
    ldi        RET_HIGH, HIGH(E_CLEAR)
 ClearContainer_ReturnOk:
    RETURN_VALUE
    ret
 .endif
;-------------------------------------------------
 .ifdef TagPushString
 PushString:
    PUSH_R2R3R4R5R8R9
    GET_NEW_STRING
 PushString_LoopCountChars:
    adiw      R24,       1
    ld          R22,        X+
    cpi        R22,        0
    brne     PushString_LoopCountChars
; Check if memory free.
    movw   R22,      POS_LOW
; Container pos + new string length.
    add      R22,      R24
    adc      R23,      R25
; If container end < (container pos + new string length)?
    cp        END_LOW,  R22
    cpc      END_HIGH, R23
    brlo    PushString_ReturnError
; New string to X.
    movw    R26,    NEW_LOW
; Container pos to Z.
    movw    R30,    POS_LOW
 PushString_LoopCopyString:
; Copy the string into the container.
    ld      R22,       X+
    st       Z+,         R22
    cpi     R22,      0
    brne PushString_LoopCopyString
; Store container pos.
    movw    R26,      BEGIN_LOW
    adiw      R26,      2
    st          X+,          R30
    st          X,            R31
; If no error return OK_PUSH.
    ldi        RET_LOW,  LOW(OK_PUSH)
    ldi        RET_HIGH, HIGH(OK_PUSH)
    jmp PushString_ReturnOk
 PushString_ReturnError:
; If error return E_PUSH.
    ldi       RET_LOW,  LOW(E_PUSH)
    ldi       RET_HIGH, HIGH(E_PUSH)
 PushString_ReturnOk:
    RETURN_VALUE
    POP_R9R8R5R4R3R2
    ret
.endif
;-------------------------------------------------
 .ifdef TagPopString
 PopString:
    GET_CONTAINER_BEGIN
; Container pos to X.
    adiw    R30,    2
    ld         R26,     Z+
    ld         R27,     Z+
; Is container empty?
    adiw    R30,      1
    cp        R30,      R26
    cpc      R31,      R27
    breq    PopString_ReturnError
; Container pos 2 back.
    sbiw    R26,     2
; Write zeros backwards.
    eor        R22,      R22
 PopString_LoopZeroMemory:
    st            X,        R22
    ld           R23,     -X
    cpi          R23,       0
    brne       PopString_LoopZeroMemory
; Store new container pos.
    sbiw        R30,       3
    adiw        R26,      1
    st             Z+,        R26
    st             Z,          R27
    ldi           RET_LOW,  LOW(OK_POP)
    ldi           RET_HIGH, HIGH(OK_POP)
    jmp         PopString_ReturnOK
 PopString_ReturnError:
; if error return E_POP
    ldi          RET_LOW,  LOW(E_POP)
    ldi          RET_HIGH, HIGH(E_POP)
 PopString_ReturnOk:
    RETURN_VALUE
    ret
 .endif
;-------------------------------------------------
 .ifdef TagUnshiftString
 UnshiftString:
    PUSH_R2R3R4R5R8R9
    GET_NEW_STRING
 UnshiftString_LoopCountChars:
    adiw      R24,       1
    ld           R22,        X+
    cpi         R22,        0
    brne     UnshiftString_LoopCountChars
; Check if memory free.
    movw   R22,      POS_LOW
; Container pos + new string length.
    add      R22,      R24
    adc      R23,      R25
; If container end < (container pos + new string length).
    cp        END_LOW, R22
    cpc      END_HIGH, R23
    brlo    UnshiftString_ReturnError
; Store new container pos.
    movw    R30,    BEGIN_LOW
    adiw      R30,    2
    st           Z+,       R22
    st           Z,         R23
; If container empty?
    movw    R24,     BEGIN_LOW
    adiw      R24,     5
    cp          R24,     POS_LOW
    cpc        R25,     POS_HIGH
    breq       UnshiftString_FirstValue
; Shift the container.
; Container pos to X.
    movw    R26,     POS_LOW
; new container pos to Z.
    movw    R30,     R22
 UnshiftString_LoopShiftContainer:
    ld          R22,      -X
    st           -Z,        R22
    cp          R24,     R26
    cpc        R25,     R27
    brlo       UnshiftString_LoopShiftContainer
; Insert the new string.
 UnshiftString_FirstValue:
; New string to X.
    movw    R26,    NEW_LOW
; Container start to Z
    movw    R30,    BEGIN_LOW
    adiw      R30,    5
 UnshiftString_LoopInsertString:
    ld          R22,    X+
    st          Z+,       R22
    cpi        R22,     0
    brne      UnshiftString_LoopInsertString
    ldi       RET_LOW,  LOW(OK_UNSHIFT)
    ldi       RET_HIGH, HIGH(OK_UNSHIFT)
    jmp     UnshiftString_ReturnOk
 UnshiftString_ReturnError:
    ldi      RET_LOW,  LOW(E_UNSHIFT)
    ldi      RET_HIGH, HIGH(E_UNSHIFT)
 UnshiftString_ReturnOk:
    RETURN_VALUE
    POP_R9R8R5R4R3R2
    ret
 .endif
;-------------------------------------------------
 .ifdef TagShiftString
 ShiftString:
    push    POS_LOW
    push    POS_HIGH
    GET_CONTAINER_BEGIN
; Get container pos.
    adiw     R30,              2
    ld          POS_LOW,  Z+
    ld          POS_HIGH, Z+
; Is container empty?
    adiw      R30,     1
    cp          R30,     POS_LOW
    cpc        R31,     POS_HIGH
    breq     ShiftString_ReturnError
; First string begin to Z and X.
    movw    R26,    R30
; Loop to first string end.
 ShiftString_LoopFirstStringEnd:
    ld         R22,     Z+
    cpi       R22,      0
    brne    ShiftString_LoopFirstStringEnd
; If next string.
    ld          R22,     Z
    cpi        R22,     0
    breq    ShiftString_LastString
; Shift container.
 ShiftString_LoopShiftContainer:
    ld          R22,      Z+
    st           X+,        R22
    cp          R30,      POS_LOW
    cpc        R31,      POS_HIGH
    brlo      ShiftString_LoopShiftContainer
 ShiftString_LastString:
; Store new container pos.
    movw    R30,       BEGIN_LOW
    adiw      R30,       2
    st           Z+,          R26
    st           Z,            R27
; Write zeros until old container pos.
    eor         R22,        R22
 ShiftString_LoopWriteZeros:
    st           X+,           R22
    cp          R26,         POS_LOW
    cpc        R27,         POS_HIGH
    brlo      ShiftString_LoopWriteZeros
    ldi         RET_LOW,  LOW(OK_SHIFT)
    ldi         RET_HIGH, HIGH(OK_SHIFT)
    jmp       ShiftString_ReturnOk
 ShiftString_ReturnError:
    ldi        RET_LOW,  LOW(E_SHIFT)
    ldi        RET_HIGH, HIGH(E_SHIFT)
 ShiftString_ReturnOk:
    RETURN_VALUE
    pop     POS_HIGH
    pop     POS_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagInsertString
 InsertString:
    PUSH_R2R3R4R5R8R9
    movw    R30,    R10
; 3. Parameter string position.
    ld           R22,    Z+
    ld           R23,    Z+
; 2. Parameter new string.
    ld           NEW_LOW,  Z+
    ld           NEW_HIGH, Z+
; 1. Parameter container begin.
    ld           BEGIN_LOW,  Z+
    ld           BEGIN_HIGH, Z
; Get container end.
    movw    R30,              BEGIN_LOW
    ld           END_LOW,  Z+
    ld           END_HIGH, Z+
; Get container pos.
    ld           POS_LOW,  Z+
    ld           POS_HIGH, Z
; Get new string length.
    movw    R30,        NEW_LOW
; Set chars counter (R24:R25) to 0.
    eor         R24,       R24
    eor         R25,       R25
 InsertString_LoopCountChars:
    adiw      R24,       1
    ld           R26,       Z+
    cpi         R26,        0
    brne       InsertString_LoopCountChars
; Check if space free.
    movw   R30,      POS_LOW
; Container pos + new string length.
    add      R30,      R24
    adc      R31,      R25
; If container end < (container pos + new string length)?
    cp        END_LOW,  R30
    cpc      END_HIGH, R31
    brlo    InsertString_ReturnError
; Store new container pos.
    movw    R26,    BEGIN_LOW
    adiw      R26,    2
    st           X+,       R30
    st           X,         R31
; Count zeros to get position.
    eor         R26,      R26
    eor         R27,      R27
    movw    R30,       BEGIN_LOW
    adiw      R30,        4
 InsertString_LoopCountZeros:
    cp           R30,      POS_LOW
    cpc         R31,      POS_HIGH
    brsh        InsertString_CopyString
    ld            R24,       Z+
    cpi          R24,       0
    brne        InsertString_LoopCountZeros
    adiw        R26,      1
    cp            R26,      R22
    cpc          R27,      R23
    brlo    InsertString_LoopCountZeros
; Is Z at old container pos?
    cp           R30,      POS_LOW
    cpc         R31,      POS_HIGH
    brsh        InsertString_CopyString
; Store insert position.
    movw      R24,     R30
; New container pos to X.
    movw      R30,      BEGIN_LOW
    adiw        R30,      2
    ld             R26,      Z+
    ld             R27,      Z
; Old container pos to Z.
    movw       R30,      POS_LOW
; Shift container.
 InsertString_LoopShiftContainer:
    ld              R22,     -Z
    st              -X,         R22
    cp             R24,      R30
    cpc           R25,      R31
    brlo         InsertString_LoopShiftContainer
; Insert the new string.
 InsertString_CopyString:
; New string to X.
    movw    R26,    NEW_LOW
 InsertString_LoopInsertString:
    ld          R22,    X+
    st          Z+,       R22
    cpi        R22,     0
    brne      InsertString_LoopInsertString
    ldi           RET_LOW,  LOW(OK_INSERT)
    ldi           RET_HIGH, HIGH(OK_INSERT)
    jmp         InsertString_ReturnOk
 InsertString_ReturnError:
    ldi           RET_LOW,  LOW(E_INSERT)
    ldi           RET_HIGH, HIGH(E_INSERT)
 InsertString_ReturnOk:
    RETURN_VALUE
    POP_R9R8R5R4R3R2
    ret
 .endif
;-------------------------------------------------
 .ifdef TagDeleteString
 DeleteString:
    push      END_LOW
    push      END_HIGH
    push      POS_LOW
    push      POS_HIGH
    GET_PARAMS
; Get container end.
    ld          END_LOW,  Z+
    ld          END_HIGH, Z+
; Get container pos (R4:R5).
    ld          POS_LOW,  Z+
    ld          POS_HIGH, Z+
; String counter to 0.
    eor        R26,      R26
    eor        R27,      R27
; Check is container empty.
    adiw      R30,       1
    cp          R30,       POS_LOW
    cpc        R31,       POS_HIGH
    breq      DeleteString_ReturnError
; Count zeros in container.
    sbiw       R30,     1
 DeleteString_LoopCountZeros:
; Is string number to high?
    cp         R30,      POS_LOW
    cpc       R31,      POS_HIGH
    brsh    DeleteString_ReturnError
    ld         R24,      Z+
    cpi       R24,      0
    brne    DeleteString_LoopCountZeros
    adiw    R26,      1
    cp        R26,      R22
    cpc       R27,      R23
    brlo    DeleteString_LoopCountZeros
; Load start address of the old string to X.
     movw   R26,     R30
; Loop to address of the next string.
 DeleteString_LoopToNextZero:
; Is string number to high?
    cp         R30,      POS_LOW
    cpc       R31,      POS_HIGH
    brsh    DeleteString_ReturnError
    ld           R24,       Z+
    cpi         R24,        0
    brne       DeleteString_LoopToNextZero
; Check is old string last string.
    cp          R30,        POS_LOW
    cpc        R31,        POS_HIGH
    brsh       DeleteString_DeleteLastString
; Shift container until old container pos.
 DeleteString_LoopShift:
    ld          R24,        Z+
    st           X+,          R24
    cp          R30,         POS_LOW
    cpc        R31,         POS_HIGH
    brlo      DeleteString_LoopShift
 DeleteString_DeleteLastString:
; Store new container pos.
    movw    R30,    BEGIN_LOW
    adiw      R30,    2
    st           Z+,      R26
    st           Z,        R27
; Write Zeros until the old container pos.
    eor          R24,      R24
 DeleteString_LoopWriteZero:
    st            X+,         R24
    cp           R26,       POS_LOW
    cpc         R27,       POS_HIGH
    brlo        DeleteString_LoopWriteZero
; If no error return OK_DELETE.
    ldi          RET_LOW,  LOW(OK_DELETE)
    ldi          RET_HIGH, HIGH(OK_DELETE)
    jmp        DeleteString_ReturnOk
 DeleteString_ReturnError:
; If error return E_DELETE.
    ldi         RET_LOW,  LOW(E_DELETE)
    ldi         RET_HIGH, HIGH(E_DELETE)
 DeleteString_ReturnOk:
    RETURN_VALUE
    pop        POS_HIGH
    pop        POS_LOW
    pop        END_HIGH
    pop        END_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagIsEmpty
 IsEmpty:
    GET_CONTAINER_BEGIN
; Get container pos.
    adiw       R30,     2
    ld           R22,      Z+
    ld           R23,      Z+
; Compare container pos with first pos
    adiw      R30,        1
    cp          R30,         R22
    cpc        R31,         R23
    breq    IsEmpty_ReturnIsEmpty
    ldi         RET_LOW,  LOW(E_EMPTY)
    ldi         RET_HIGH, HIGH(E_EMPTY)
    jmp     IsEmpty_ReturnNotEmpty
 IsEmpty_ReturnIsEmpty:
    ldi          RET_LOW,  LOW(IS_EMPTY)
    ldi          RET_HIGH, HIGH(IS_EMPTY)
 IsEmpty_ReturnNotEmpty:
    RETURN_VALUE
    ret
 .endif
;-------------------------------------------------
 .ifdef TagGetOffset
 GetOffset:
    push      POS_LOW
    push      POS_HIGH
    GET_PARAMS
; Get container pos.
    adiw     R30,              2
    ld          POS_LOW,  Z+
    ld          POS_HIGH, Z+
; String counter to 0.
    eor        R26,      R26
    eor        R27,      R27
; Count Zeros in container memory.
 GetOffset_LoopCountZeros:
    cp         R30,      POS_LOW
    cpc       R31,      POS_HIGH
    brsh    GetOffset_NumberOutOfRange
    ld         R24,      Z+
    cpi       R24,      0
    brne    GetOffset_LoopCountZeros
    adiw    R26,      1
    cp        R26,      R22
    cpc       R27,      R23
    brlo    GetOffset_LoopCountZeros
 GetOffset_NumberOutOfRange:
; Return string offset.
    sub        R30,      BEGIN_LOW
    sbc         R31,     BEGIN_HIGH
    movw    RET_LOW, R30
    RETURN_VALUE
    pop        POS_HIGH
    pop        POS_LOW
    ret
 .endif
;-------------------------------------------------
 .ifdef TagGetSize
 GetSize:
    GET_CONTAINER_BEGIN
; Get container end.
    ld           R24,      Z+
    ld           R25,      Z
    sub        R24,       BEGIN_LOW
    sbc        R25,       BEGIN_HIGH
    adiw      R24,        1
    movw    RET_LOW, R24
    RETURN_VALUE
    ret
 .endif
;-------------------------------------------------
 .ifdef TagGetUsed
 GetUsed:
    GET_CONTAINER_BEGIN
; Get container pos.
    adiw    R30,    2
    ld         R24,    Z+
    ld         R25,    Z
; Container pos - container begin.
    sub      R24,     BEGIN_LOW
    sbc       R25,    BEGIN_HIGH
    movw   RET_LOW, R24
    RETURN_VALUE
    ret
 .endif
;-------------------------------------------------
