'Imports System.Runtime.Interopservices
Imports System.IO.Ports.SerialPort
Imports System.Media
Imports System.Threading

Public Class Form1

    Public ports As String() = GetPortNames()
    Public port As String = ""
    Declare Sub Beep Lib "kernel32.dll" (ByVal tone As Integer, ByVal dauer As Integer)

    Dim gMyGraphics As Graphics ' the drawing surface
    Dim cMyColor As Color ' used to hold colors for the pen and brush
    Dim pMyPen As Pen ' used to draw the lines
    Dim bMyBrush As SolidBrush = New SolidBrush(Color.White) ' used to draw the background
    Dim intPosition As Integer ' position to draw the animated lines
    Dim intDirection As Integer ' controls direction of the animated lines

    Dim In_Buffer As String

    Dim ADC0 As Integer
    Dim ADC1 As Integer
    Dim ADC2 As Integer
    Dim ADC3 As Integer

    Dim Spg_0 As Single
    Dim Spg_1 As Single
    Dim Spg_2 As Single
    Dim Spg_3 As Single

    Dim X1 As Long

    Dim X_Last_1 As Long
    Dim X_Last_2 As Long
    Dim X_Last_3 As Long
    Dim X_Last_4 As Long

    Dim Y_Last_1 As Long
    Dim Y_Last_2 As Long
    Dim Y_Last_3 As Long
    Dim Y_Last_4 As Long

    Dim Trigger_0 As Single
    Dim Trigger_Flag As Byte
    Dim Start_Flag As Byte
    Dim Time_Loop As Long
    Dim Time_Loop_X As Single



    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        For Each port In ports
            ComboBox_Comport.Items.Add(port)
        Next port

        Button_Disconnect.Enabled = False
        Button_Connect.Enabled = False
        Button_Start.Enabled = False
        Button_Stop.Enabled = False

        ComboBox_Baudrate.Items.Add(9600)
        ComboBox_Baudrate.Items.Add(19200)
        ComboBox_Baudrate.Items.Add(57600)
        ComboBox_Baudrate.Items.Add(76800)
        ComboBox_Baudrate.Items.Add(115200)
        ComboBox_Baudrate.SelectedItem = 19200

        RadioButton2.Checked = True
        RadioButton1.Enabled = False
        RadioButton2.Enabled = False
        RadioButton3.Enabled = False
        RadioButton4.Enabled = False

        'set up the drawing surface to draw in the picturebox
        gMyGraphics = picDisplay.CreateGraphics

        Label3.Text = "ADC(0): 0.00V"
        Label4.Text = "ADC(1): 0.00V"
        Label11.Text = "ADC(2): 0.00V"
        Label12.Text = "ADC(3): 0.00V"
        Label13.Text = TrackBar1.Value & " V"

        Y_Last_1 = 0
        Y_Last_2 = 0
        Y_Last_3 = 0
        Y_Last_4 = 0

        TrackBar1.Enabled = False
        Trigger_Flag = 0
        Start_Flag = 0


    End Sub

    Private Sub Button_Connect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Connect.Click

        Try

            Button_Connect.Enabled = False
            Button_Disconnect.Enabled = True
            ComboBox_Comport.Enabled = False
            ComboBox_Baudrate.Enabled = False
            Button_Start.Enabled = True
            Button_Stop.Enabled = False

            RadioButton1.Enabled = True
            RadioButton2.Enabled = True
            RadioButton3.Enabled = True
            RadioButton4.Enabled = True

            SerialPort1.PortName = ComboBox_Comport.Text
            SerialPort1.BaudRate = ComboBox_Baudrate.Text
            SerialPort1.Open()

        Catch ex As Exception

            MessageBox.Show("Achtung die Schnittstelle konnte nicht geffnet werden! " + e.ToString _
                       , "Ausnahmefehler", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Button_Connect.Enabled = True
            Button_Disconnect.Enabled = False
            ComboBox_Comport.Enabled = True
            ComboBox_Baudrate.Enabled = True
            Button_Start.Enabled = False
            Button_Stop.Enabled = False
            RadioButton1.Enabled = False
            RadioButton2.Enabled = False
            RadioButton3.Enabled = False
            RadioButton4.Enabled = False

        End Try

    End Sub

    Private Sub Button_Disconnect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Disconnect.Click

        Button_Connect.Enabled = True
        Button_Disconnect.Enabled = False
        Button_Start.Enabled = False
        Button_Stop.Enabled = False
        ComboBox_Comport.Enabled = True
        ComboBox_Baudrate.Enabled = True
        RadioButton1.Enabled = False
        RadioButton2.Enabled = False
        RadioButton3.Enabled = False
        RadioButton4.Enabled = False
        SerialPort1.Close()

    End Sub

    Private Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived

        'TextBox1.Text = ""
        Control.CheckForIllegalCrossThreadCalls = False
        In_Buffer = (SerialPort1.ReadExisting)
        'TextBox1.AppendText(In_Buffer)
        Call RS232_Daten()

    End Sub

    Private Sub rs232_daten()

        Dim StrPos As String
        Dim Daten As String
        ' Dim CRC As String
        Dim CRC_Input As String
        Dim CRC_Input_Val As Single

        Dim Var1 As String
        Dim Var2 As String
        Dim Var3 As String
        Dim Var4 As String


        Try

            Daten = In_Buffer

            StrPos = InStr(Daten, "Mega,")

            'ADC 0
            Daten = Mid(Daten, InStr(Daten, ",") + 1)
            Var1 = Format(Mid(Daten, 1, 4))
            Spg_0 = Val(Var1)

            'ADC 1
            Daten = Mid(Daten, InStr(Daten, ",") + 1)
            Var2 = Format(Mid(Daten, 1, 4))
            Spg_1 = Val(Var2)

            'ADC 2
            Daten = Mid(Daten, InStr(Daten, ",") + 1)
            Var3 = Format(Mid(Daten, 1, 4))
            Spg_2 = Val(Var3)

            'ADC 3
            Daten = Mid(Daten, InStr(Daten, ",") + 1)
            Var4 = Format(Mid(Daten, 1, 4))
            Spg_3 = Val(Var4)

            'CRC 
            Daten = Mid(Daten, InStr(Daten, ",") + 1)
            CRC_Input = Format(Mid(Daten, 1, 3))
            CRC_Input_Val = Val(CRC_Input)


            'CRC Prfung
            'CRC = Spg_0 Xor Spg_1 Xor Spg_2 Xor Spg_3

            'If CRC = CRC_Input_Val Then

            'ADC 0
            If CheckBox1.Checked = True Then
                Spg_0 = Format((Spg_0 * (5 / 1023)), "0.00")
                Label3.Text = "ADC(0): " & Spg_0 & "V"
                ADC0 = Val(Var1)   'ASCII in Zahl wandeln
                ADC0 = 1025 - ADC0 'Wert umdrehen mit Offset damit die Linie nicht ins Netz luft
                ADC0 = ADC0 / 2.97 'Skalierung auf Anzeige
            End If

            'ADC 1
            If CheckBox2.Checked = True Then
                Spg_1 = Format((Spg_1 * (5 / 1023)), "0.00")
                Label4.Text = "ADC(1): " & Spg_1 & "V"
                ADC1 = Val(Var2)
                ADC1 = 1025 - ADC1
                ADC1 = ADC1 / 2.97
            End If

            'ADC 2
            If CheckBox3.Checked = True Then
                Spg_2 = Format((Spg_2 * (5 / 1023)), "0.00")
                Label11.Text = "ADC(2): " & Spg_2 & "V"
                ADC2 = Val(Var3)
                ADC2 = 1025 - ADC2
                ADC2 = ADC2 / 2.97
            End If

            'ADC 3
            If CheckBox4.Checked = True Then
                Spg_3 = Format((Spg_3 * (5 / 1023)), "0.00")
                Label12.Text = "ADC(3): " & Spg_3 & "V"
                ADC3 = Val(Var4)
                ADC3 = 1025 - ADC3
                ADC3 = ADC3 / 2.97
            End If

            'End If
            If Start_Flag = 1 Then Call Plot()

        Catch ex As Exception
            Exit Sub
        End Try


    End Sub

    Private Sub ComboBox_Comport_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox_Comport.SelectedIndexChanged

        If ComboBox_Comport.SelectedItem <> "" Then
            Button_Connect.Enabled = True
        End If

    End Sub

    Private Sub Button_Start_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Start.Click

        If RadioButton1.Checked = True Then Time_Loop = 0
        If RadioButton2.Checked = True Then Time_Loop = 1
        If RadioButton3.Checked = True Then Time_Loop = 19
        If RadioButton4.Checked = True Then Time_Loop = 205

        RadioButton1.Enabled = False
        RadioButton2.Enabled = False
        RadioButton3.Enabled = False
        RadioButton4.Enabled = False

        'Init
        X1 = 0
        X_Last_1 = 0
        X_Last_2 = 0
        X_Last_3 = 0
        X_Last_4 = 0
        gMyGraphics.Clear(Color.Black)
        Trigger_Flag = 0

        Button_Start.Enabled = False
        Button_Stop.Enabled = True
        Time_Loop_X = 0
        Start_Flag = 1

    End Sub

    Private Sub Plot()

        Dim i As Integer

        'Netz zeichnen
        cMyColor = Color.GreenYellow
        pMyPen = New Pen(cMyColor, 1)

        For i = 0 To 500 Step 50
            gMyGraphics.DrawLine(pMyPen, i, 0, i, 350)
        Next i

        For i = 0 To 350 Step 70
            gMyGraphics.DrawLine(pMyPen, 0, i, 500, i)
        Next

        'Zeitschleife fr Interval
        Time_Loop_X = Time_Loop_X + 1
        If Time_Loop_X <= Time_Loop Then Exit Sub
        Time_Loop_X = 0


        'Plotten
        If CheckBox5.Checked = True Then
            If Trigger_0 <= Spg_0 Or Trigger_Flag = 1 Then
                Trigger_Flag = 1

                'Plotten
                X1 = X1 + 1 'alle X ms ein Point

                If X1 >= 500 Then
                    If CheckBox6.Checked = True Then
                        Button_Start.Enabled = True
                        Button_Stop.Enabled = False
                        RadioButton1.Enabled = True
                        RadioButton2.Enabled = True
                        RadioButton3.Enabled = True
                        RadioButton4.Enabled = True
                        'Timer2.Enabled = False
                        Exit Sub
                    End If
                    X1 = 0
                    X_Last_1 = 0
                    X_Last_2 = 0
                    X_Last_3 = 0
                    X_Last_4 = 0
                    gMyGraphics.Clear(Color.Black)
                    Trigger_Flag = 0
                End If

                'ADC 0
                If CheckBox1.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Red
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_1, Y_Last_1, X1, ADC0)
                    'letzte Werte speichern
                    X_Last_1 = X1
                    Y_Last_1 = ADC0
                End If

                'ADC 1
                If CheckBox2.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Magenta
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_2, Y_Last_2, X1, ADC1)
                    X_Last_2 = X1
                    Y_Last_2 = ADC1
                End If

                'ADC 2
                If CheckBox3.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Yellow
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_3, Y_Last_3, X1, ADC2)
                    X_Last_3 = X1
                    Y_Last_3 = ADC2
                End If

                'ADC 3
                If CheckBox4.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Cyan
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_4, Y_Last_4, X1, ADC3)
                    X_Last_4 = X1
                    Y_Last_4 = ADC3
                End If
            End If


        Else

            If CheckBox5.Checked = False Then

                'Plotten
                X1 = X1 + 1 'alle X ms ein Point

                If X1 >= 500 Then
                    If CheckBox6.Checked = True Then
                        Button_Start.Enabled = True
                        Button_Stop.Enabled = False
                        RadioButton1.Enabled = True
                        RadioButton2.Enabled = True
                        RadioButton3.Enabled = True
                        RadioButton4.Enabled = True
                        Exit Sub
                    End If
                    X1 = 0
                    X_Last_1 = 0
                    X_Last_2 = 0
                    X_Last_3 = 0
                    X_Last_4 = 0
                    gMyGraphics.Clear(Color.Black)
                    Trigger_Flag = 0
                End If

                'ADC 0
                If CheckBox1.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Red
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_1, Y_Last_1, X1, ADC0)
                    'letzte Werte speichern
                    X_Last_1 = X1
                    Y_Last_1 = ADC0
                End If

                'ADC 1
                If CheckBox2.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Magenta
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_2, Y_Last_2, X1, ADC1)
                    X_Last_2 = X1
                    Y_Last_2 = ADC1
                End If

                'ADC 2
                If CheckBox3.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Yellow
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_3, Y_Last_3, X1, ADC2)
                    X_Last_3 = X1
                    Y_Last_3 = ADC2
                End If

                'ADC 3
                If CheckBox4.Checked = True Then
                    'Farbe der Linie
                    cMyColor = Color.Cyan
                    pMyPen = New Pen(cMyColor, 1)
                    'X,Y Start ; X,Y Ende
                    gMyGraphics.DrawLine(pMyPen, X_Last_4, Y_Last_4, X1, ADC3)
                    X_Last_4 = X1
                    Y_Last_4 = ADC3
                End If
            End If
        End If

    End Sub

    Private Sub Button_Stop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_Stop.Click

        Button_Start.Enabled = True
        Button_Stop.Enabled = False
        RadioButton1.Enabled = True
        RadioButton2.Enabled = True
        RadioButton3.Enabled = True
        RadioButton4.Enabled = True
        Start_Flag = 0

    End Sub

    Private Sub TrackBar1_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar1.Scroll

        If CheckBox5.Checked = True Then
            Trigger_0 = Format((TrackBar1.Value / 1000), "0.00")
            Label13.Text = Trigger_0 & " V"
        End If

    End Sub

    Private Sub CheckBox5_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox5.CheckedChanged

        If CheckBox5.Checked = True Then
            TrackBar1.Enabled = True
            Trigger_Flag = 1
        Else
            TrackBar1.Enabled = False
        End If

    End Sub

    Public Sub New()

        ' Dieser Aufruf ist fr den Windows Form-Designer erforderlich.
        InitializeComponent()

        ' Fgen Sie Initialisierungen nach dem InitializeComponent()-Aufruf hinzu.

    End Sub
End Class
