/*** DemoRS232.cc ***/
//------------------------------------------------
// This program controls the 8 x conrad relay cards (Nr. 19 77 30)
// via the 1st serial interface.
// The correct number of the relay cards must be defined
// in the headerfile "RelayCard.h".
//-----------------------------------------------
/*** Keyboard ***/
// key   #  = select value to set
// key   *  = execute command
// keys 0-8 = values to set
/*** LCD-Display ***/
// |--------|
// |C???A???|
// |00100000|
// |--------|
// 1st line C = Commando, A = Address
// 2nd line = Data
//------------------------------------------------
// This program requires these other modules and libraries:
// 1. main.h
// 2. RelayCard.h
// 3. RelayCardRS232.cc
// 4. ThreadDisplay.cc
// 5. ThreadKeyboard.cc
/*** Please add the required files to your project! ***/
//-----------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "main.h"
 #include "RelayCard.h"
//------------------------------------------------
 void main(void)
    {
    byte by_expected_frames;

    gby_item   = 0;
    gbo_result = false;
    gbo_send   = false;

    LCD_Init();
    LCD_CursorOn();
    LCD_CursorPos(0x00);
    Thread_Delay(1);
    LCD_WriteText("-Set Up-");
    LCD_CursorPos(0x40);
    Thread_Delay(1);
    if(RelayCardRS232Init())
        {
        LCD_WriteText("---OK---");
 #ifdef DEBUG
        Msg_WriteText("RelayCardRS232Init -> OK\r");
 #endif
        }
    else
        {
        LCD_WriteText("--ERROR-");
 #ifdef DEBUG
        Msg_WriteText("RelayCardRS232Init -> ERROR\r");
 #endif
        }

 #ifdef DEBUG
    RelayCardRS232ShowFrames(FRAME_SIZE * (RELAY_CARDS_COUNT + 1));
 #endif
    Thread_Delay(200);

    Thread_Start(THREAD_KEYBOARD, ThreadKeyboard);
    Thread_Start(THREAD_DISPLAY,  ThreadDisplay);

    while(1)
        {
        if(gbo_send)
            {
            Thread_Lock(1);
            if((BROADCAST_ADDR == gaby_tx_buffer[ADDRESS])
               ||
               (SETUP          == gaby_tx_buffer[COMMAND]))
                    by_expected_frames = RELAY_CARDS_COUNT + 1;
            else
                by_expected_frames = 1;

            gbo_result = RelayCardRS232Send(FRAME_SIZE * by_expected_frames);

            gby_item = SHOW_RESULT;

 #ifdef DEBUG
            RelayCardRS232ShowFrames(FRAME_SIZE * by_expected_frames);
            Msg_WriteChar(13);
 #endif
            Thread_Lock(0);
            gbo_send = false;
            }
        Thread_Delay(50);
        }
    }
//------------------------------------------------