/*** DS18S20.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "DS18S20.h"
//------------------------------------------------
 flash byte gaby_crc_table[256] =
    {
    000, 094, 188, 226, 097, 063, 221, 131, 194, 156, 126, 032, 163, 253, 031, 065,
    157, 195, 033, 127, 252, 162, 064, 030, 095, 001, 227, 189, 062, 096, 130, 220,
    035, 125, 159, 193, 066, 028, 254, 160, 225, 191, 093, 003, 128, 222, 060, 098,
    190, 224, 002, 092, 223, 129, 099, 061, 124, 034, 192, 158, 029, 067, 161, 255,
    070, 024, 250, 164, 039, 121, 155, 197, 132, 218, 056, 102, 229, 187, 089, 007,
    219, 133, 103, 057, 186, 228, 006, 088, 025, 071, 165, 251, 120, 038, 196, 154,
    101, 059, 217, 135, 004, 090, 184, 230, 167, 249, 027, 069, 198, 152, 122, 036,
    248, 166, 068, 026, 153, 199, 037, 123, 058, 100, 134, 216, 091, 005, 231, 185,
    140, 210, 048, 110, 237, 179, 081, 015, 078, 016, 242, 172, 047, 113, 147, 205,
    017, 079, 173, 243, 112, 046, 204, 146, 211, 141, 111, 049, 178, 236, 014, 080,
    175, 241, 019, 077, 206, 144, 114, 044, 109, 051, 209, 143, 012, 082, 176, 238,
    050, 108, 142, 208, 083, 013, 239, 177, 240, 174, 076, 018, 145, 207, 045, 115,
    202, 148, 118, 040, 171, 245, 023, 073, 008, 086, 180, 234, 105, 055, 213, 139,
    087, 009, 235, 181, 054, 104, 138, 212, 149, 203, 041, 119, 244, 170, 072, 022,
    233, 183, 085, 011, 136, 214, 052, 106, 043, 117, 151, 201, 074, 020, 246, 168,
    116, 042, 200, 150, 021, 075, 169, 247, 182, 232, 010, 084, 215, 137, 107, 053
    };
//------------------------------------------------
 BOOL DS18S20Checksum(byte p_data[], int i_size)
    {
    byte by_checksum;
    int i_index;

    by_checksum = 0x00;
    for(i_index = 0; i_index < i_size; i_index++)
        by_checksum = gaby_crc_table[by_checksum ^ p_data[i_index]];

    if(by_checksum)
        return false;

    return true;
    }
//------------------------------------------------