/*** WatchDogDemo-0.02.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. WatchDog.asm
// 2. RegDef.inc
// 3. WatchDog.cc
/*** Please add the required files to your project! ***/
//------------------------------------------------
 #define PORT_HIGH         1
 #define PORT_LOW          0
//------------------------------------------------
 void main(void)
    {
    word w_count;

    Port_DataDirBit(PORT_LED2, PORT_OUT);
    Port_WriteBit(PORT_LED2,   PORT_LOW);
    Port_DataDirBit(PORT_LED1, PORT_OUT);
    Port_WriteBit(PORT_LED1,   PORT_LOW);

 #ifdef MEGA128
    if(WatchDogIsReset());
        {
        WatchDogClear();
// Here we can do something special after a Watchdog Timer Reset.
// But only on Mega128 because the Mega32 always begins with a
// low reset flag. Actually there are no flags set in the
// MCUCSR-register of the Mega32. In addition the program on
// Mega128 always starts with the Watchdog-Timer-Reset flag set,
// if the IDE is connected.
        }
 #endif

// The LED1 flashes during the restart of the program.
    for(w_count = 0; w_count <= 20; w_count++)
        {
        Port_ToggleBit(PORT_LED1);
        Thread_Delay(10);
        }

// Initialize and start the watchdog-timer before entering the main loop.
// Look at the prescaler definitions in the file "WatchDog.cc".
    WatchDogInit(WDT_1536_MS);
    WatchDogStart();

    while(1)
        {
// Here we can do our tasks.
        Thread_Delay(140);
        Port_ToggleBit(PORT_LED2);
// You must call the function "WatchDogReset()" after 1536 ms.
        WatchDogReset();
        }
    }
//------------------------------------------------