/*** DemoADCapture.cc ***/
//------------------------------------------------
// Authors: Torsten Knorr, Pepe V??? create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
// This program requires these other modules and libraries:
// 1. ADCapture.asm
// 2. ADCapture.cc
/*** Please add the required files to your porject! ***/
//------------------------------------------------
 #define BUFFER_SIZE 128
//------------------------------------------------
 void main(void)
    {
    float f_buffer[BUFFER_SIZE];
    word w_buffer[BUFFER_SIZE];
    word w_time;
    byte by_flip_flop;

    ADCaptureInit(ADC_VREF_VCC, ADC_FRQ_115kHz, ADC0);
    by_flip_flop = 1;

    while(1)
        {
        Msg_WriteChar(13);
//------------------------------------------------
/*** Demo ADCaptureRun(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_115kHz);
        ADCaptureSetChannel(ADC0);
        Timer_TickCount();
        ADCaptureRun(w_buffer, BUFFER_SIZE);
        w_time = Timer_TickCount();
        ADCaptureRelease();

        Msg_WriteText("ADCaptureRun: ");
        Msg_WriteWord(10 * w_time);
        Msg_WriteText(" ms\r");
        ADCaptureShowBuffer(w_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRunFree(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_460kHz);
        ADCaptureSetChannel(ADC1);
        Timer_TickCount();
        ADCaptureRunFree(w_buffer, BUFFER_SIZE);
        w_time = Timer_TickCount();
        ADCaptureRelease();

        Msg_WriteText("ADCaptureRunFree: ");
        Msg_WriteWord(10 * w_time);
        Msg_WriteText(" ms\r");
        ADCaptureShowBuffer(w_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRunQuiet(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_1_8MHz);
        ADCaptureSetChannel(ADC2);
        Timer_TickCount();
        ADCaptureRunQuiet(w_buffer, BUFFER_SIZE);
        w_time = Timer_TickCount();
        ADCaptureRelease();

        Msg_WriteText("ADCaptureRunQuiet: ");
        Msg_WriteWord(10 * w_time);
        Msg_WriteText(" ms\r");
        ADCaptureShowBuffer(w_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
/*** Demo ADCaptureRunFreeFloat(...) ***/
        ADCaptureSetPrescaler(ADC_FRQ_230kHz);
        ADCaptureSetChannel(ADC3);
        Timer_TickCount();
        ADCaptureRunFreeFloat(f_buffer, BUFFER_SIZE);
        w_time = Timer_TickCount();
        ADCaptureRelease();

        Msg_WriteText("ADCaptureRunFreeFloat: ");
        Msg_WriteWord(10 * w_time);
        Msg_WriteText(" ms\r");
        ADCaptureShowFloatBuffer(f_buffer, BUFFER_SIZE);
        Thread_Delay(300);
//------------------------------------------------
        if(by_flip_flop)
            ADCaptureSetVref(ADC_VREF_BG);
        else
            ADCaptureSetVref(ADC_VREF_VCC);
        by_flip_flop = 1 ^ by_flip_flop;
        }
    }
//------------------------------------------------