;*** ADCapture-0.04.asm ***;
;-------------------------------------------------
; Author: Torsten Knorr, create-soft@freenet.de
;*** BUGS ***;
; Maybe you'll find some. Please let me know.
; By the way I am pleased with every kind of feedback.
;-------------------------------------------------
;*** Register Definitions ***;
 .def R_DATA_LOW   = R0
 .def R_DATA_HIGH  = R1
 .def R_SP_LOW     = R6
 .def R_SP_HIGH    = R7
 .def R_PARAM_LOW  = R10
 .def R_PARAM_HIGH = R11
 .def R_TEMP_LOW   = R22
 .def R_TEMP_HIGH  = R23
 .def R_COUNT_LOW  = R24
 .def R_COUNT_HIGH = R25
 .def R_XP_LOW     = R26
 .def R_XP_HIGH    = R27
 .def R_ZP_LOW     = R30
 .def R_ZP_HIGH    = R31
;-------------------------------------------------
;*** ADMUX - ADC Multiplexer Selection Register ***;
 .equ ADMUX = 0x07
 .equ MUX0  = 0    ; Analog Channel and Gain Selection Bits
 .equ MUX1  = 1    ; Analog Channel and Gain Selection Bits
 .equ MUX2  = 2    ; Analog Channel and Gain Selection Bits
 .equ MUX3  = 3    ; Analog Channel and Gain Selection Bits
 .equ MUX4  = 4    ; Analog Channel and Gain Selection Bits
 .equ MUXM  = 0x1F ; Analog Channel and Gain Selection Mask
 .equ ADLAR = 5	   ; Left Adjust Result
 .equ REFS0 = 6	   ; Reference Selection Bit 0
 .equ REFS1 = 7    ; Reference Selection Bit 1
 .equ REFSM = 0xC0 ; Reference Selection Mask
;-------------------------------------------------
;*** ADCSRA - ADC Control and Status Register A ***;
 .equ ADCSRA = 0x06
 .equ ADCSR  = ADCSRA ; For compatibility
 .equ ADPS0  = 0      ; ADC Prescaler Select Bits
 .equ ADPS1  = 1      ; ADC Prescaler Select Bits
 .equ ADPS2  = 2      ; ADC Prescaler Select Bits
 .equ ADPSM  = 0x07   ; ADC Prescaler Select Mask
 .equ ADIE   = 3      ; ADC Interrupt Enable
 .equ ADIF   = 4      ; ADC Interrupt Flag
 .equ ADFR   = 5      ; ADC  Free Running Select
 .equ ADSC   = 6      ; ADC Start Conversion
 .equ ADEN   = 7      ; ADC Enable
;-------------------------------------------------
;*** ADCH - ADC Data Register High Byte ***;
 .equ ADCH  = 0x05
;-------------------------------------------------
;*** ADCL - ADC Data Register Low Byte ***;
 .equ ADCL  = 0x04
;-------------------------------------------------
;*** SREG - Status Register ***;
 .equ SREG  = 0x3F
;-------------------------------------------------
;*** MCUCR - MCU Control Register ***;
 .equ MCUCR = 0x35
 .equ IVCE  = 0    ; Interrupt Vector Change Enable
 .equ IVSEL = 1    ; Interrupt Vector Select
 .equ SM2   = 2    ; Sleep Mode Select
 .equ SM0   = 3    ; Sleep Mode Select
 .equ SM1   = 4    ; Sleep Mode Select
 .equ SE    = 5    ; Sleep Enable
 .equ SRW10 = 6    ; External SRAM Wait State Select
 .equ SRE   = 7    ; External SRAM Enable
;-------------------------------------------------
 .ifdef TagADCaptureSetVref
 ADCaptureSetVref:

; get pointer to parameter
    movw R_ZP_LOW,    R_PARAM_LOW

; 1. parameter = by_vref
    ld   R_TEMP_LOW,  Z

; mask bits REFS0/REFS1
    andi R_TEMP_LOW,  REFSM

    cbi  ADMUX,       REFS0
    cbi  ADMUX,       REFS1
    in   R_TEMP_HIGH, ADMUX
    or   R_TEMP_LOW,  R_TEMP_HIGH

    out  ADMUX,       R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetPrescaler
 ADCaptureSetPrescaler:

; get pointer to parameter
    movw R_ZP_LOW,    R_PARAM_LOW

; 1. parameter = by_prescaler
    ld   R_TEMP_LOW,  Z

; mask bits ADPS0/ADPS1/ADPS2
    andi R_TEMP_LOW,  ADPSM

    in   R_TEMP_HIGH, ADCSRA
    andi R_TEMP_HIGH, ~ADPSM
    or   R_TEMP_LOW,  R_TEMP_HIGH

    out  ADCSRA,      R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureSetChannel
 ADCaptureSetChannel:

; get pointer to parameter
    movw R_ZP_LOW,    R_PARAM_LOW

; 1. parameter = by_channel
    ld   R_TEMP_LOW,  Z

; mask bits MUX0/MUX1/MUX2/MUX3/MUX4
    andi R_TEMP_LOW,  MUXM

    in   R_TEMP_HIGH, ADMUX
    andi R_TEMP_HIGH, ~MUXM
    or   R_TEMP_LOW,  R_TEMP_HIGH

    out  ADMUX,       R_TEMP_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRun
 ADCaptureRun:

; get pointer to parameter
    movw R_ZP_LOW,    R_PARAM_LOW

; 2. parameter = w_buffer_size
    ld R_COUNT_LOW,   Z+
    ld R_COUNT_HIGH,  Z+

; 1. parameter = p_buffer
    ld   R_XP_LOW,    Z+
    ld   R_XP_HIGH,   Z

    cbi ADCSRA,       ADFR
    sbi ADCSRA,       ADEN

 AD_CAPTURE_LOOP:
    sbi  ADCSRA,      ADSC
 AD_CAPTURE_WAIT:
    sbic ADCSRA,      ADSC
    rjmp AD_CAPTURE_WAIT

; move the values in the array
    in   R_TEMP_LOW,  ADCL
    in   R_TEMP_HIGH, ADCH
    st   X+,          R_TEMP_LOW
    st   X+,          R_TEMP_HIGH

    sbiw R_COUNT_LOW, 1

    brne AD_CAPTURE_LOOP

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunFree
 ADCaptureRunFree:

; get pointer to parameter
    movw R_ZP_LOW,   R_PARAM_LOW

; 2. parameter = w_buffer_size
    ld R_COUNT_LOW,  Z+
    ld R_COUNT_HIGH, Z+

; 1. parameter = p_buffer
    ld   R_XP_LOW,    Z+
    ld   R_XP_HIGH,   Z

    in   R_DATA_LOW,  SREG
; clear global interrupt flag
    cli

    sbi ADCSRA,       ADFR
    sbi ADCSRA,       ADEN

    sbi  ADCSRA,      ADSC
 AD_CAPTURE_RUN_FREE_LOOP:

 AD_CAPTURE_RUN_FREE_WAIT:
    sbis ADCSRA,      ADIF
    rjmp AD_CAPTURE_RUN_FREE_WAIT

    sbi  ADCSRA,      ADIF

; move the values in the array
    in   R_TEMP_LOW,  ADCL
    in   R_TEMP_HIGH, ADCH
    st   X+,          R_TEMP_LOW
    st   X+,          R_TEMP_HIGH

    sbiw R_COUNT_LOW, 1
    brne AD_CAPTURE_RUN_FREE_LOOP

; restore status register
    out  SREG,         R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunQuiet
 ADCaptureRunQuiet:

; get pointer to parameter
    movw R_ZP_LOW,     R_PARAM_LOW

; 2. parameter = w_buffer_size
    ld   R_COUNT_LOW,  Z+
    ld   R_COUNT_HIGH, Z+

; 1. parameter = p_buffer
    ld   R_XP_LOW,    Z+
    ld   R_XP_HIGH,   Z

    in   R_DATA_LOW, SREG
    sei

    cbi  ADCSRA,     ADFR
    sbi  ADCSRA,     ADEN
    sbi  ADCSRA,     ADIE

; enable sleep mode
    ldi  R_ZP_LOW,   (1 << SE) | (1 << SM0)
    in   R_ZP_HIGH,  MCUCR
    or   R_ZP_LOW,   R_ZP_HIGH
    out  MCUCR,      R_ZP_LOW

 AD_CAPTURE_RUN_QUIET:

    sbi  ADCSRA,     ADSC

; Enter ADC Noise Reduction mode.
    sleep


; Maybe an other event woke up the cpu,
; before the conversion is complete.
 AD_CAPTURE_RUN_QUIET_WAIT:
    sbic ADCSRA,      ADSC
    rjmp AD_CAPTURE_RUN_QUIET_WAIT

; move the values in the array
    in   R_TEMP_LOW,  ADCL
    in   R_TEMP_HIGH, ADCH
    st   X+,          R_TEMP_LOW
    st   X+,          R_TEMP_HIGH

    sbiw R_COUNT_LOW, 1
    brne AD_CAPTURE_RUN_QUIET

    out  MCUCR,       R_ZP_HIGH
; restore status register
    out  SREG,        R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRunFreeFloat
 ADCaptureRunFreeFloat:

; get pointer to parameter
    movw R_ZP_LOW,     R_PARAM_LOW

; 2. parameter = w_buffer_size
    ld   R_COUNT_LOW,  Z+
    ld   R_COUNT_HIGH, Z+

; 1. parameter = p_buffer
    ld   R_XP_LOW,     Z+
    ld   R_XP_HIGH,    Z

    in   R_DATA_LOW,   SREG
; clear global interrupt flag
    cli

    sbi  ADCSRA,       ADFR
    sbi  ADCSRA,       ADEN
    sbi  ADCSRA,       ADSC
 AD_CAPTURE_RUN_FREE_FLOAT_LOOP:

 AD_CAPTURE_RUN_FREE_FLOAT_WAIT:
    sbis ADCSRA,       ADIF
    rjmp AD_CAPTURE_RUN_FREE_FLOAT_WAIT
    sbi  ADCSRA,       ADIF

; read ad-values
    in   R_TEMP_LOW,   ADCL
    in   R_TEMP_HIGH,  ADCH

; convert the values to float
    clr  R_ZP_LOW
    ldi  R_ZP_HIGH,    0x10
    clr  R_DATA_HIGH

 AD_CAPTURE_FIND_EXPONENT:
    inc  R_ZP_LOW
    lsl  R_TEMP_HIGH
    brcs AD_CAPTURE_EXPONENT_FOUND
    lsl  R_TEMP_LOW
    adc  R_TEMP_HIGH,  R_DATA_HIGH

    dec  R_ZP_HIGH
    brne AD_CAPTURE_FIND_EXPONENT

    rjmp AD_CAPTURE_STORE_VALUE

 AD_CAPTURE_EXPONENT_FOUND:
    lsr  R_TEMP_HIGH

    ldi  R_ZP_HIGH,    0x10
    sub  R_ZP_HIGH,    R_ZP_LOW

    ldi  R_ZP_LOW,     0x7F
    add  R_ZP_HIGH,    R_ZP_LOW

    lsr  R_ZP_HIGH
    brcc AD_CAPTURE_STORE_VALUE
    sbr  R_TEMP_HIGH,  0x80

; move the values in the array
 AD_CAPTURE_STORE_VALUE:
    st   X+,           R_DATA_HIGH
    st   X+,           R_TEMP_LOW
    st   X+,           R_TEMP_HIGH
    st   X+,           R_ZP_HIGH

    sbiw R_COUNT_LOW,  1
    brne AD_CAPTURE_RUN_FREE_FLOAT_LOOP


; restore status register
    out  SREG,         R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
 .ifdef TagADCaptureRelease
 ADCaptureRelease:

    cbi ADCSRA, ADEN

    ret
 .endif
;-------------------------------------------------