;*** InputCaptureT3-0.02.asm ***;
;-------------------------------------------------
 .include "Cpu128Def.inc"
 .include "RegDef.inc"
;-------------------------------------------------
 .ifdef TagICT3Init
 ICT3Init:

; 1. Parametre by_prescaler
    movw R_ZP_LOW,   R_PARAM_LOW
    ld   R_DATA_LOW, Z

; Configure PortE7 as input.
    cbi  DDRE,       PORTE7
; Pullup on
    sbi  PORTE,      PORTE7

; Set TCCR3A - Timer/Counter3 Control Register A.
    clr  R_TEMP_LOW
    sts  TCCR3A,     R_TEMP_LOW

; Set TCCR3B - Timer/Counter3 Control Register B.
; ICNC3 Input Capture Noise Canceler
; ICES3: Input Capture Edge Select
; ICES3 = 0 -> a falling (negative) edge is used as trigger
; ICES3 = 1 -> a rising (positive) edge will trigger the capture
; Clock Select Bit Description
; CS32 CS31 CS30 Description
; 0    0    0    No clock source. (Timer/Counter stopped)
; 0    0    1    clkI/O/1 (No prescaling
; 0    1    0    clkI/O/8 (From prescaler)
; 0    1    1    clkI/O/64 (From prescaler)
; 1    0    0    clkI/O/256 (From prescaler)
; 1    0    1    clkI/O/1024 (From prescaler)
; 1    1    0    External clock source on Tn pin. Clock on falling edge
; 1    1    1    External clock source on Tn pin. Clock on rising edge
    mov  R_TEMP_LOW,  R_DATA_LOW
    sbr  R_TEMP_LOW,  (1 << ICNC3) | (1 << ICES3)
    sts  TCCR3B,      R_TEMP_LOW

; ETIMSK - Extended Timer/Counter Interrupt Mask Register
    lds  R_TEMP_LOW,  ETIMSK
; Set overflow and input capture interrupt
    sbr  R_TEMP_LOW,  (1 << TICIE3) | (1 << TOIE3)
    sts  ETIMSK,      R_TEMP_LOW

; Set global interrupt flag
    sei

    ret
 .endif
;-------------------------------------------------
 .ifdef TagICT3GetCapture
 ICT3GetCapture:

; Read timer value
    lds  R_DATA_LOW,   ICR3L
    lds  R_DATA_HIGH,  ICR3H

; Return timer value
    movw R_ZP_LOW, R_SP_LOW
    adiw R_ZP_LOW, 4
    movw R_SP_LOW, R_ZP_LOW
    st   Z+,       R_DATA_LOW
    st   Z+,       R_DATA_HIGH
    clr  R_DATA_LOW
    st   Z+,       R_DATA_LOW
    st   Z,        R_DATA_LOW

    ret
 .endif
;-------------------------------------------------
