package jr.ccloader.main;

/**
 * The Main class for the c-control native loader
 * 
 * It allows programming the c-control units with native code.
 * The Code was partly ported from the C# Code from Thomas Beier.
 * It saved me a lot of time to implement the loader in java
 * 
 * Jens Riebold, jens.riebold AT web.de
 * 
 */

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

import jr.ccloader.devices.ATMega32;
import jr.ccloader.devices.Device;
import jr.ccloader.util.HexFileParser;

public class Main implements Runnable
{
	private Device device = null;
	private HexFileParser hfp = null;
	private String filename;
	private byte[]	buffer;
	
	public Main(String[] args) 
	{
		this.filename = args[0];
	}
	
	public void readfile() throws FileNotFoundException, IOException
	{
		File f = new File(filename);
		hfp = new HexFileParser(f);
		buffer = hfp.parseFile();
	}
	
	public void program() throws InterruptedException
	{
		Thread t = new Thread(this);
		t.start();
		t.join();			
	}

	public static void main(String[] args)
	{
		Main main = null;
		try
		{
			main = new Main(args);
			main.readfile();
			main.program();
		}
		catch (FileNotFoundException e1)
		{
			System.out.println("FileNotFoundException: File not found: " + main.getFilename());
		}
		catch (IOException e)
		{
			System.out.println("IOException: File: " + main.getFilename() + "\n" + e.getMessage());
		}
		catch (InterruptedException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("Main terminated");
		System.exit(0);
	}

	@Override
	public void run()
	{
		try
		{
			device = new ATMega32();
			if (buffer.length > device.getMaxAddress())
			{
				System.out.println("To big for controller: " + buffer.length + " (Maximum=" + device.getMaxAddress() + ")");
				return;
			}
			device.setProgramBuffer(buffer);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return;
		}
		
		if (device.reset() == false)
		{
			System.out.println("Device reset failed");
			return;
		}
		
		if (device.init() == false)
		{
			System.out.println("Device init failed");
			return;			
		}
		
		if (device.writeHex() == false)
		{
			System.out.println("Device write failed");
			return;			
		}
		
		System.out.println("Device initalisation success");
		
		device.close();
	}

	public String getFilename()
	{
		return filename;
	}
}
