/*** ADCapture.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "ADCapture.h"
//------------------------------------------------
 #if MEGA32
 void ADCaptureSetDevice    $asm("TagADCaptureSetDeviceMega32") (void);
 #endif

 #if MEGA128
 void ADCaptureSetDevice    $asm("TagADCaptureSetDeviceMega128") (void);
 #endif

 void ADCaptureSetVref      $asm("TagADCaptureSetVref")      (byte by_vref);
 void ADCaptureSetPrescaler $asm("TagADCaptureSetPrescaler") (byte by_prescaler);
 void ADCaptureSetChannel   $asm("TagADCaptureSetChannel")   (byte by_channel);

// Use ADCaptureRun(...)
// when your project contains time-critical interrupt functions.
 void ADCaptureRun     $asm("TagADCaptureRun")
    (word p_buffer[], word w_buffer_size);

// Use ADCaptureRunFree(...)
// when you need a precise sampling rate.
 void ADCaptureRunFree $asm("TagADCaptureRunFree")
    (word p_buffer[], word w_buffer_size);

// Use ADCaptureRunFreeFloat(...)
// if you need the data as float for further calculations.
 void ADCaptureRunFreeFloat $asm("TagADCaptureRunFreeFloat")
    (float p_buffer[], word w_buffer_size);

// Use ADCaptureRunQuiet(...)
// when you need a more accurate measurement or
// you like to use a higher AD-Clock frequency.
// No other interrupts should be enabled while
// you running this function.
 void ADCaptureRunQuiet $asm("TagADCaptureRunQuiet")
    (word p_buffer[], word w_buffer_size);

// Do not call the function ADCaptureNoiseReduction() directly
// instead use the function ADCaptureSleep().
 void ADCaptureNoiseReduction $asm("TagADCaptureNoiseReduction") (void);

 void ADCaptureSmooth  $asm("TagADCaptureSmooth")
    (word p_buffer[], word w_buffer_size);

 void ADCaptureRelease $asm("TagADCaptureRelease") (void);
//------------------------------------------------
 void ADCaptureInit(
    byte by_vref,
    byte by_prescaler,
    byte by_channel
    )
    {
    ADCaptureSetDevice();
    ADCaptureSetVref(by_vref);
    ADCaptureSetPrescaler(by_prescaler);
    ADCaptureSetChannel(by_channel);
    }
//------------------------------------------------
 void ADCaptureShowBuffer(word p_buffer[], int i_buffer_size)
    {
    int i_index;
    char ac_msg[20];

    for(i_index = 0; i_index < i_buffer_size; i_index++)
        {
        Str_Printf(ac_msg, "%6d", p_buffer[i_index]);
        Msg_WriteText(ac_msg);

        if(!((1 + i_index) % 16))
            Msg_WriteChar(13);

        Thread_Delay(1);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------
 void ADCaptureShowFloatBuffer(float p_buffer[], int i_buffer_size)
    {
    int i_index;
    char ac_msg[20];

    for(i_index = 0; i_index < i_buffer_size; i_index++)
        {
        Str_Printf(ac_msg, "%7.1f", p_buffer[i_index]);
        Msg_WriteText(ac_msg);

        if(!((1 + i_index) % 16))
            Msg_WriteChar(13);

        Thread_Delay(1);
        }
    Msg_WriteChar(13);
    }
//------------------------------------------------
 void ADCaptureCallback(void)
    {
    ADCaptureValue(Irq_GetCount(INT_ADC), ADC_ReadInt());
    }
//------------------------------------------------
 word ADCaptureValue(byte by_set, word w_ad_value_new)
    {
    static word sw_ad_value;

    if(by_set)
        sw_ad_value = w_ad_value_new;

    return sw_ad_value;
    }
//------------------------------------------------
 word ADCaptureSleep(void)
    {
    Irq_SetVect(INT_ADC, ADCaptureCallback);
    Thread_Delay(2);
    ADCaptureNoiseReduction();
    Thread_Delay(2);
    Irq_SetVect(INT_ADC, 0L);
    Thread_Delay(2);
    return ADCaptureValue(GET, 0);
    }
//------------------------------------------------
 void ADCaptureSmoothFloat(float p_buffer[], word w_buffer_size)
    {
    word w_index;

    for(w_index = 0; w_index < (w_buffer_size - 2); w_index++)
        {
        p_buffer[w_index] =
            (0.25 * p_buffer[w_index])
            +
            (0.5 * p_buffer[w_index + 1])
            +
            (0.25 * p_buffer[w_index + 2]);
        }
    }
//------------------------------------------------