/*** WatchDog.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
/*** Define Watchdog Timer Prescaler ***/
 #ifdef MEGA32
    #define WDT_16_3_MS 0x00  // 16.3 ms
    #define WDT_32_5_MS 0x01  // 32.5 ms
    #define WDT_65_MS   0x02  // 65.0 ms
    #define WDT_0_13_S  0x03  // 00.13 s
    #define WDT_0_26_S  0x04  // 00.26 s
    #define WDT_0_52_S  0x05  // 00.52 s
    #define WDT_1_S     0x06  // 01.00 s
    #define WDT_2_1_S   0x07  // 02.10 s
 #elif MEGA128 // ??? || MEGA128CAN
    #define WDT_14_MS   0x00  // 14.0 ms
    #define WDT_28_1_MS 0x01  // 28.1 ms
    #define WDT_56_2_MS 0x02  // 56.2 ms
    #define WDT_0_11_S  0x03  // 00.11 s
    #define WDT_0_22_S  0x04  // 00.22 s
    #define WDT_0_45_S  0x05  // 00.45 s
    #define WDT_0_9_S   0x06  // 00.90 s
    #define WDT_1_8_S   0x07  // 01.80 s
 #endif
//------------------------------------------------
/*** Declare The Functions ***/
 void WatchDogInit    $asm("TagWatchDogInit")    (byte by_prescaler);
 void WatchDogSetTime $asm("TagWatchDogSetTime") (byte by_prescaler);
 void WatchDogStart   $asm("TagWatchDogStart")   (void);
 void WatchDogStop    $asm("TagWatchDogStop")    (void);
 void WatchDogReset   $asm("TagWatchDogReset")   (void);
/*** ToDo ***/
// It doesn't work properly on Mega32! I don't know why?
 #ifdef MEGA128
 byte WatchDogIsReset $asm("TagWatchDogIsReset") (void);
 #endif
//------------------------------------------------