/*** DS2482.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "DS2482.h"
 #include "../DS18S20Lib/DS18S20.h"
//------------------------------------------------
 BOOL ConvInit(byte by_write_addr)
    {
    byte aby_data[2];
    byte aby_rom_code[ROM_CODE_SIZE];
    byte by_checksum;
    int i_index;

    if(!ConvReset(by_write_addr))
        return false;

    if(!ConvConfig(by_write_addr, 0x00))
        return false;

    if(!ConvOWReset(by_write_addr))
        return false;

    aby_data[0] = CONV_WRITE_BYTE;
    aby_data[1] = OW_READ_ROM;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return false;
    Thread_Delay(1);

    for(i_index = 0; i_index < ROM_CODE_SIZE; i_index++)
        {
        if(!ConvOWReadByte(by_write_addr, aby_data))
            return false;
        aby_rom_code[i_index] = aby_data[0];
        }

    return DS18S20Checksum(aby_rom_code, ROM_CODE_SIZE);
    }
//------------------------------------------------
 BOOL ConvReset(byte by_write_addr)
    {
    byte aby_data[1];
    byte by_read_addr;

    aby_data[0] = CONV_RESET;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, false))
        return false;

    by_read_addr = by_write_addr + 1;
    aby_data[0] = 0x00;
    if(!I2CReceiveData(by_read_addr, aby_data, 1, true))
        return false;

    if(((1 << BIT_DEVICE_RESET) | (1 << BIT_LOGIC_LEVEL)) == aby_data[0])
        return true;

    return false;
    }
//------------------------------------------------
 BOOL ConvConfig(byte by_write_addr, byte by_config)
    {
    byte aby_data[2];
    byte by_read_addr;


    by_config = by_config & 0x0F;
    by_config = by_config | (~(by_config << 4) & 0xF0);

    aby_data[0] = CONV_CONFIG;
    aby_data[1] = by_config;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, false))
        return false;

    by_read_addr = by_write_addr + 1;
    aby_data[0] = 0x00;
    if(!I2CReceiveData(by_read_addr, aby_data, 1, true))
        return false;

    if((0x0F & by_config) == aby_data[0])
        return true;

    return false;
    }
//------------------------------------------------
 BOOL ConvOWReset(byte by_write_addr)
    {
    byte aby_data[1];
    byte by_read_addr;

    aby_data[0] = CONV_OW_RESET;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, true))
        return false;

    Thread_Delay(1);

    by_read_addr = by_write_addr + 1;
    aby_data[0] = 0x00;
    if(!I2CReceiveData(by_read_addr, aby_data, 1, false))
        return false;

    if((1 << BIT_PRESENCE_DETECT) & aby_data[0])
        return true;

    return false;
    }
//------------------------------------------------
 BOOL ConvOWWriteByte(byte by_write_addr, byte by_to_write)
    {
    byte aby_data[2];

    aby_data[0] = CONV_WRITE_BYTE;
    aby_data[1] = by_to_write;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return false;

    Thread_Delay(1);

    return true;
    }
//------------------------------------------------
 BOOL ConvOWReadByte(byte by_write_addr, byte p_read[])
    {
    byte aby_data[2];
    byte by_read_addr;

    aby_data[0] = CONV_READ_BYTE;
    if(!I2CTransmitData(by_write_addr, aby_data, 1, true))
        return false;
    Thread_Delay(1);

    aby_data[0] = CONV_SET_READ_POINTER;
    aby_data[1] = CONV_DATA_REG;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, false))
        return false;
    Thread_Delay(1);

    by_read_addr = by_write_addr + 1;
    if(!I2CReceiveData(by_read_addr, aby_data, 1, true))
        return false;

    p_read[0] = aby_data[0];

    return true;
    }
//------------------------------------------------
 float ConvRead(byte by_write_addr)
    {
    byte aby_scratchpad[SCRATCHPAD_SIZE];
    byte aby_data[2];
    byte by_timeout;
    float f_value;
    float f_temp;
    int i_temp;
    int i_index;

    if(!ConvOWReset(by_write_addr))
        return INVALID_VALUE;

    aby_data[0] = CONV_WRITE_BYTE;
    aby_data[1] = OW_SKIP_ROM;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return INVALID_VALUE;
    Thread_Delay(1);

    //aby_data[0] = CONV_WRITE_BYTE;
    aby_data[1] = OW_CONVERT;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return INVALID_VALUE;
    Thread_Delay(1);

    by_timeout = 1;
    do
        {
        if(!ConvOWReadByte(by_write_addr, aby_data))
            return INVALID_VALUE;
        if(!by_timeout++)
            return INVALID_VALUE;
        } while(0xFF != aby_data[0]);

    if(!ConvOWReset(by_write_addr))
        return INVALID_VALUE;

    aby_data[0] = CONV_WRITE_BYTE;
    aby_data[1] = OW_SKIP_ROM;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return INVALID_VALUE;
    Thread_Delay(1);

    //aby_data[0] = CONV_WRITE_BYTE;
    aby_data[1] = OW_READ_SCRATCHPAD;
    if(!I2CTransmitData(by_write_addr, aby_data, 2, true))
        return INVALID_VALUE;
    Thread_Delay(1);

    for(i_index = 0; i_index < SCRATCHPAD_SIZE; i_index++)
        {
        if(!ConvOWReadByte(by_write_addr, aby_data))
            return INVALID_VALUE;
        aby_scratchpad[i_index] = aby_data[0];
        }

    if(!ConvOWReset(by_write_addr))
        return INVALID_VALUE;

    if(!DS18S20Checksum(aby_scratchpad, SCRATCHPAD_SIZE))
        return INVALID_VALUE;

    i_temp = (aby_scratchpad[BYTE_TEMP_MSB] << 8);
    i_temp = i_temp | aby_scratchpad[BYTE_TEMP_LSB];
    i_temp = i_temp & 0xFFFE;
    f_temp = i_temp;
    f_temp = f_temp / 2.0;

    f_value = aby_scratchpad[BYTE_COUNT_PER_C] - aby_scratchpad[BYTE_COUNT_REMAIN];
    f_value = f_value / aby_scratchpad[BYTE_COUNT_PER_C];
    f_temp = f_temp + f_value;

    if((DS18S20_MIN_VALUE < f_temp) && (DS18S20_MAX_VALUE > f_temp))
        return f_temp;

    return INVALID_VALUE;
    }
//------------------------------------------------
 void ConvSendValue(byte by_write_addr, int i_device_number)
    {
    char ac_msg[30];
    float f_value;

    f_value = ConvRead(by_write_addr);
    if(INVALID_VALUE != f_value)
        Str_Printf(ac_msg, "%d. Temperature: %5.2f C\r", i_device_number, f_value);
    else
        Str_Printf(ac_msg, "%d. Temperature: ERROR\r", i_device_number);

    Msg_WriteText(ac_msg);

    }
//------------------------------------------------