/*** 4-20mA.h ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//-----------------------------------------------
 #ifndef __CURRENT_LOOP__
 #define __CURRENT_LOOP__
//------------------------------------------------
 #define BOOL int
 #define INVALID_VALUE 210.0
 #define SET true
 #define GET false
//------------------------------------------------
// U     / R       = I
// 5 V   / 200 Ohm = 0.025 A = 25 mA
// 4 V   / 200 Ohm = 0.02 A  = 20 mA
// 0.8 V / 200 Ohm = 0.004 A = 4 mA
// (5 V  / 1024) * w_ad_read = V

// over control field
// 20.0005787 mA - 22.81 mA
// (5 V / 1024) * 934,2976 = 4,562 V = 22,81 mA
// 934 = 0x03A6
 #define CL_MAX_VALUE 0x03A6

// Nominal field
// 4 mA - 20 mA
// (5 V / 1024) * 819.2 = 4 V = 20 mA
// 819 = 0x0333
// (5 V / 1024) * 163.84 = 0.8 V = 4 mA
// 163 = 0x00A3
 #define CL_INPUT_MIN 163.84
 #define CL_INPUT_MAX 819.2
 #define CL_INPUT_RANGE (819.2 - 163.84)

// under control field
// 3.999 mA - 1.185 mA
// (5 V / 1024) * 48.5376 = 0.237 V = 1,185 mA
// 48 = 0x0030
 #define CL_MIN_VALUE 0x0030
//------------------------------------------------
// (CL_INPUT_MAX - CL_INPUT_MIN) = CL_INPUT_RANGE
// (f_20mA_value - f_4mA_value ) / CL_INPUT_RANGE = FACTOR
// (ADC_VALUE    - CL_INPUT_MIN) = INPUT_VALUE
// (INPUT_VALUE  * FACTOR      ) + f_4mA_value    = f_measuring_value
//------------------------------------------------
 #endif
//------------------------------------------------