/*** 4-20mA.cc ***/
//------------------------------------------------
// Author: Torsten Knorr, create-soft@freenet.de
/*** BUGS ***/
// Maybe you'll find some. Please let me know.
// By the way I am pleased with every kind of feedback.
//------------------------------------------------
 #include "4-20mA.h"
//------------------------------------------------
 float CurrentLoop4mAValue(byte by_ad_port, float f_4mA_value, BOOL bo_set)
    {
    static float saf_4mA_values[8];

    if(bo_set)
        saf_4mA_values[by_ad_port] = f_4mA_value;

    return saf_4mA_values[by_ad_port];
    }
//------------------------------------------------
 float CurrentLoop20mAValue(byte by_ad_port, float f_20mA_value, BOOL bo_set)
    {
    static float saf_20mA_values[8];

    if(bo_set)
        saf_20mA_values[by_ad_port] = f_20mA_value;

    return saf_20mA_values[by_ad_port];
    }
//------------------------------------------------
 float CurrentLoopFactor(
    byte by_ad_port,
    float f_4mA_value,
    float f_20mA_value,
    BOOL bo_set
    )
    {
    static float saf_factor[8];

    if(bo_set)
        saf_factor[by_ad_port] = (f_20mA_value - f_4mA_value) / CL_INPUT_RANGE;

    return saf_factor[by_ad_port];
    }
//------------------------------------------------
 BOOL CurrentLoopInit(byte by_ad_port, float f_4mA_value, float f_20mA_value)
    {
    word w_ad_read;

    CurrentLoop4mAValue(by_ad_port, f_4mA_value, SET);
    CurrentLoop20mAValue(by_ad_port, f_20mA_value, SET);
    CurrentLoopFactor(by_ad_port, f_4mA_value, f_20mA_value, SET);

// Make test
    ADC_Set(ADC_VREF_VCC, by_ad_port);
    w_ad_read = ADC_Read();
    if((CL_MIN_VALUE < w_ad_read) && (CL_MAX_VALUE > w_ad_read))
        return true;
    return false;
    }
//------------------------------------------------
 float CurrentLoopRead(byte by_ad_port)
    {
    word w_ad_read;
    float f_value;

    ADC_Set(ADC_VREF_VCC, by_ad_port);
    w_ad_read = ADC_Read();
    if((CL_MIN_VALUE < w_ad_read) && (CL_MAX_VALUE > w_ad_read))
        {
        f_value = w_ad_read;
        f_value = f_value - CL_INPUT_MIN;
        f_value = f_value * CurrentLoopFactor(by_ad_port, 0.0, 0.0, GET);
        f_value = f_value + CurrentLoop4mAValue(by_ad_port, 0.0, GET);
        return f_value;
        }

    return INVALID_VALUE;
    }
//------------------------------------------------
 void CurrentLoopSendValue(byte by_ad_port, int i_device_number)
    {
    char ac_msg[30];
    float f_value;

    f_value = CurrentLoopRead(by_ad_port);
    Str_Printf(
        ac_msg,
        "%d. 4-20mA: %5.2f",
        i_device_number,
        f_value
        );
    Msg_WriteText(ac_msg);

    if(INVALID_VALUE == f_value)
        Msg_WriteText(" ERROR\r");
    else
        Msg_WriteText(" OK\r");

    }
//------------------------------------------------