/*** RelayCard.cc ***/
//------------------------------------------------
 #include "RelayCard.h"
//------------------------------------------------
// 35 byte Sende + Empfungspuffer + 6 byte interne FIFO Verwaltung
 byte gaby_serial_port_buffer[41];
//------------------------------------------------
 BOOL RelayCardSendFrame(byte p_frame_write[])
    {
    int i_index;
    BOOL bo_result;
    word aw_frame_read[FRAME_SIZE];
    p_frame_write[CHECKSUM] =
        p_frame_write[COMMAND] ^
        p_frame_write[ADDRESS] ^
        p_frame_write[DATA];
    for(i_index = 0; i_index < FRAME_SIZE; i_index++)
        Serial_Write(SERIAL_PORT, p_frame_write[i_index]);
    Thread_Delay(10);
    for(i_index = 0; i_index < FRAME_SIZE; i_index++)
        {
        aw_frame_read[i_index] = Serial_ReadExt(SERIAL_PORT);
        if(0x100 <= aw_frame_read[i_index])
            return false;
        }
    bo_result = RelayCardCheckResponse(p_frame_write, aw_frame_read);
    return bo_result;
    }
//------------------------------------------------
 BOOL RelayCardCheckResponse(byte p_frame_write[], word p_frame_read[])
    {
    if(p_frame_read[CHECKSUM] != (
        p_frame_read[COMMAND] ^
        p_frame_read[ADDRESS] ^
        p_frame_read[DATA]))
            return false;
    switch(p_frame_write[COMMAND])
        {
        case NO_OPERATION:
            if(NO_OPERATION_OK == p_frame_read[COMMAND])
                return true;
            break;
        case SETUP:
            if(
                (SETUP_OK == p_frame_read[COMMAND])
                ||
                (SETUP == p_frame_read[COMMAND])
                )
                return true;
            break;
        case GET_PORT:
            if(GET_PORT_OK == p_frame_read[COMMAND])
                return true;
            break;
        case SET_PORT:
            if(SET_PORT_OK == p_frame_read[COMMAND])
                return true;
            break;
        case GET_OPTION:
            if(GET_OPTION_OK == p_frame_read[COMMAND])
                return true;
            break;
        case SET_OPTION:
            if(SET_OPTION_OK == p_frame_read[COMMAND])
                return true;
            break;
        case SET_SINGLE:
            if(SET_SINGLE_OK == p_frame_read[COMMAND])
                return true;
            break;
        case DEL_SINGLE:
            if(DEL_SINGLE_OK == p_frame_read[COMMAND])
                return true;
            break;
        case TOGGLE:
            if(TOGGLE_OK == p_frame_read[COMMAND])
                return true;
            break;
        default:
            return false;
        }
    if(
        (BROADCAST_ADDR == p_frame_write[ADDRESS])
        &&
        ((p_frame_write[COMMAND] == p_frame_read[COMMAND])
        ||
        (NO_OPERATION == p_frame_read[COMMAND])
        ||
        (NO_OPERATION_OK == p_frame_read[COMMAND]))
        )
        return true;
    return false;
    }
//------------------------------------------------
 BOOL RelayCardClearBuffer(void)
    {
    int i_timeout;
    i_timeout = FRAME_SIZE;
    do
        {
        if(0x100 == Serial_ReadExt(SERIAL_PORT))
            {
            Serial_Write(SERIAL_PORT, 0x00);
            Thread_Delay(10);
            }
        else
            {
            while(0x100 != Serial_ReadExt(SERIAL_PORT));
            return true;
            }
        } while(i_timeout--);
    return false;
    }
//------------------------------------------------
 BOOL RelayCardInit(void)
    {
    int i_index;
    byte aby_frame_write[FRAME_SIZE];
    word aw_frame_read[FRAME_SIZE];
    word w_response;
// Initialisiere Schnittstelle mit 19200baud, 8 Bit, 1 Stop Bit, keine Paritt
// 20 byte Empfangspuffer - 15 byte Sendepuffer
    Serial_Init_IRQ(
        SERIAL_PORT,
        gaby_serial_port_buffer,
        20,
        15,
        SR_8BIT|SR_1STOP|SR_NO_PAR,
        SR_BD19200
        );
    if(!RelayCardClearBuffer())
        return false;
    aby_frame_write[COMMAND] = SETUP;
    aby_frame_write[ADDRESS] = CARD_1;
    aby_frame_write[DATA] = 0x00;
    if(RelayCardSendFrame(aby_frame_write))
        {
        do
            {
            for(i_index = 0; i_index < FRAME_SIZE; i_index++)
                {
                w_response = Serial_ReadExt(SERIAL_PORT);
                if(0x100 <= w_response)
                    break;
                aw_frame_read[i_index] = w_response;
                }
            } while(0x100 > w_response);
        }
    return RelayCardCheckResponse(aby_frame_write, aw_frame_read);
    }
//------------------------------------------------
